/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.framework.ClientContextHandler;
import com.rameses.util.Service;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class ClientContextHandlers {
    private static final ClientContextHandlers instance = new ClientContextHandlers();
    private static final Object LOCKED = new Object();
    private ClassLoader loader;
    private ExecutorService exec;
    private List<ClientContextHandler> handlers = new ArrayList<ClientContextHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(ClassLoader loader) {
        Object object = LOCKED;
        synchronized (object) {
            instance.loadImpl(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = LOCKED;
        synchronized (object) {
            instance.stopImpl();
        }
    }

    ClientContextHandlers() {
        this.exec = Executors.newFixedThreadPool(100);
    }

    private void loadImpl(ClassLoader loader) {
        if (!this.handlers.isEmpty()) {
            this.stopImpl();
            this.handlers.clear();
        }
        ClassLoader loader1 = this.getClass().getClassLoader();
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader loader0 = loader == null ? loader1 : loader;
        if (!loaders.contains(loader0)) {
            loaders.add(loader0);
        }
        if (!loaders.contains(loader1)) {
            loaders.add(loader1);
        }
        ArrayList list = new ArrayList();
        while (!loaders.isEmpty()) {
            ClassLoader cl = (ClassLoader)loaders.remove(0);
            Iterator itr = Service.providers(ClientContextHandler.class, (ClassLoader)cl);
            while (itr.hasNext()) {
                Object o = itr.next();
                if (list.contains(o.getClass())) continue;
                list.add(o.getClass());
                ClientContextHandler h = (ClientContextHandler)o;
                this.handlers.add(h);
                this.startImpl(h);
            }
        }
        list.clear();
        this.loader = loader;
    }

    private void stopImpl() {
        ClientContextHandler[] values = this.handlers.toArray(new ClientContextHandler[0]);
        this.handlers.clear();
        for (ClientContextHandler h : values) {
            this.stopImpl(h);
        }
        try {
            this.exec.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.exec = Executors.newFixedThreadPool(100);
    }

    private void stopImpl(final ClientContextHandler cch) {
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                cch.stop();
            }
        });
    }

    private void startImpl(final ClientContextHandler cch) {
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                cch.start();
            }
        });
    }
}

