/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.common.ValueResolver;
import com.rameses.platform.interfaces.Platform;
import com.rameses.rcp.framework.ActionProvider;
import com.rameses.rcp.framework.ClientContextHandlers;
import com.rameses.rcp.framework.ClientSecurityProvider;
import com.rameses.rcp.framework.ControllerProvider;
import com.rameses.rcp.framework.EventManager;
import com.rameses.rcp.framework.NavigationHandler;
import com.rameses.rcp.framework.NotificationManager;
import com.rameses.rcp.framework.NotificationProvider;
import com.rameses.rcp.framework.OpenerProvider;
import com.rameses.rcp.framework.ResourceProvider;
import com.rameses.rcp.framework.Services;
import com.rameses.rcp.framework.TaskManager;
import com.rameses.rcp.impl.ClientContextImpl;
import com.rameses.rcp.impl.ControllerProviderImpl;
import com.rameses.rcp.impl.NavigationHandlerImpl;
import com.rameses.util.Service;
import com.rameses.util.URLStreamHandlerFactory;
import com.rameses.util.URLStreamHandlers;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;

public abstract class ClientContext {
    private static ClientContext currentContext;
    private TaskManager taskManager;
    private NavigationHandler navigationHandler;
    private ControllerProvider controllerProvider;
    private ActionProvider actionProvider;
    private OpenerProvider openerProvider;
    private Services services;
    private Map appEnv = new HashMap();
    private Map headers = new HashMap();
    private Map properties = new HashMap();
    private boolean debugMode;
    private NotificationProvider notificationProvider;
    private List<WeakReference<ExecutorService>> executors = new Vector<WeakReference<ExecutorService>>();
    private EventManager eventManager;

    public abstract ValueResolver getValueResolver();

    public abstract Locale getLocale();

    public abstract void setLocale(Locale var1);

    public abstract Platform getPlatform();

    public abstract void setPlatform(Platform var1);

    public abstract ClassLoader getClassLoader();

    public abstract void setClassLoader(ClassLoader var1);

    public abstract ResourceProvider getResourceProvider();

    public abstract void setResourceProvider(ResourceProvider var1);

    public abstract ClientSecurityProvider getSecurityProvider();

    public abstract void setSecurityProvider(ClientSecurityProvider var1);

    public final ControllerProvider getControllerProvider() {
        if (this.controllerProvider == null) {
            Iterator itr = Service.providers(ControllerProvider.class, (ClassLoader)this.getClassLoader());
            this.controllerProvider = itr.hasNext() ? (ControllerProvider)itr.next() : new ControllerProviderImpl();
        }
        return this.controllerProvider;
    }

    public final NavigationHandler getNavigationHandler() {
        if (this.navigationHandler == null) {
            Iterator itr = Service.providers(NavigationHandler.class, (ClassLoader)this.getClassLoader());
            this.navigationHandler = itr.hasNext() ? (NavigationHandler)itr.next() : new NavigationHandlerImpl();
        }
        return this.navigationHandler;
    }

    public final ActionProvider getActionProvider() {
        Iterator itr;
        if (this.actionProvider == null && (itr = Service.providers(ActionProvider.class, (ClassLoader)this.getClassLoader())).hasNext()) {
            this.actionProvider = (ActionProvider)itr.next();
        }
        return this.actionProvider;
    }

    public final OpenerProvider getOpenerProvider() {
        Iterator itr;
        if (this.openerProvider == null && (itr = Service.providers(OpenerProvider.class, (ClassLoader)this.getClassLoader())).hasNext()) {
            this.openerProvider = (OpenerProvider)itr.next();
        }
        return this.openerProvider;
    }

    public static final ClientContext getCurrentContext() {
        if (currentContext == null) {
            ClientContext.setCurrentContext(new ClientContextImpl());
        }
        return currentContext;
    }

    public static final void setCurrentContext(ClientContext context) {
        ClientContext old = currentContext;
        if (old != null) {
            try {
                old.notificationProvider.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                old.taskManager.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                old.services.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                old.eventManager.destroyEvents();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ClientContextHandlers.stop();
        currentContext = context;
        ClientContext.currentContext.eventManager = new EventManager();
        ClientContext.currentContext.taskManager = new TaskManager();
        ClientContext.currentContext.services = new Services();
        NotificationManager.reset();
        URLStreamHandlers.setClassLoader((ClassLoader)currentContext.getClassLoader());
        URLStreamHandlers.load();
        try {
            URL.setURLStreamHandlerFactory(URLStreamHandlers.getFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClientContextHandlers.load(currentContext.getClassLoader());
    }

    public final TaskManager getTaskManager() {
        return this.taskManager;
    }

    public final Services getServices() {
        return this.services;
    }

    public final EventManager getEventManager() {
        return this.eventManager;
    }

    public final NotificationProvider getNotificationProvider() {
        return NotificationManager.getDefaultProvider();
    }

    public void setNotificationProvider(NotificationProvider notificationProvider) {
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Map getAppEnv() {
        return this.appEnv;
    }

    public void setAppEnv(Map appEnv) {
        this.appEnv = appEnv;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public URL getResource(String name) {
        try {
            return URLStreamHandlerFactory.getInstance((ClassLoader)this.getClassLoader()).getResource(name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void registerExecutor(ExecutorService svc) {
        if (!this.executors.contains(svc)) {
            this.executors.add(new WeakReference<ExecutorService>(svc));
        }
    }

    public void unregisterExecutor(ExecutorService svc) {
        this.executors.remove(svc);
    }

    public void shutdown() {
        NotificationProvider np = this.getNotificationProvider();
        if (np != null) {
            np.close();
        }
        this.getTaskManager().stop();
        this.getServices().stop();
        for (WeakReference<ExecutorService> wr : this.executors) {
            try {
                ExecutorService svc = (ExecutorService)wr.get();
                if (svc == null) continue;
                if (this.isDebugMode()) {
                    System.out.println("shutting down executor service: " + svc);
                }
                svc.shutdownNow();
            }
            catch (Exception e) {
                if (!this.isDebugMode()) continue;
                e.printStackTrace();
            }
        }
    }

    public static interface DesktopService {
        public void start();

        public void stop();
    }
}

