/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.framework.ChangeLogHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public final class ChangeLog {
    private final Set<String> prefix = new HashSet<String>();
    private Stack<ChangeEntry> entries = new Stack();
    private CheckChangesHandler changeHandler = new CheckChangesHandler();

    public Set getPrefix() {
        return this.prefix;
    }

    public int size() {
        return this.entries.size();
    }

    public void addEntry(Object bean, String fieldName, Object oldValue, Object newValue) {
        for (String s : this.prefix) {
            if (!fieldName.startsWith(s)) continue;
            PropertyResolver pr = PropertyResolver.getInstance();
            bean = pr.getProperty(bean, s);
            fieldName = fieldName.replace(s + ".", "");
            break;
        }
        this.entries.push(new ChangeEntry(bean, fieldName, oldValue, newValue));
    }

    public void clear() {
        this.clear(null);
    }

    public void clear(ChangeLogHandler handler) {
        this.entries.clear();
        if (handler != null) {
            handler.clear(this);
        }
    }

    public String getDifference() {
        DiffChangeLogOutput out = new DiffChangeLogOutput();
        this.scan(out);
        return out.toString();
    }

    private List<ChangeHist> buildHistory() {
        ArrayList<ChangeHist> list = new ArrayList<ChangeHist>();
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            ChangeEntry ce = (ChangeEntry)e.nextElement();
            ChangeHist ch = new ChangeHist(ce.getId(), ce.getEntity());
            int idx = list.indexOf(ch);
            if (idx < 0) {
                list.add(ch);
            } else {
                ch = (ChangeHist)list.get(idx);
            }
            ch.addEntry(ce.getFieldName(), ce.getOldValue(), ce.getNewValue(), ce.getLogtime());
        }
        return list;
    }

    public void scan(ChangeLogHandler handler) {
        try {
            handler.start();
            for (ChangeHist ch : this.buildHistory()) {
                ch.scan(handler);
            }
            handler.end();
        }
        catch (StopScanningException stopScanningException) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        PrintLogOutput output = new PrintLogOutput();
        this.scan(output);
        return output.toString();
    }

    public boolean hasChanges() {
        this.scan(this.changeHandler);
        return this.changeHandler.getHasChanges();
    }

    public ChangeEntry undo() {
        if (this.entries.empty()) {
            return null;
        }
        ChangeEntry ce = this.entries.pop();
        PropertyResolver pr = PropertyResolver.getInstance();
        pr.setProperty(ce.getEntity(), ce.getFieldName(), ce.getOldValue());
        return ce;
    }

    public List<ChangeEntry> undoAll() {
        ArrayList<ChangeEntry> ceList = new ArrayList<ChangeEntry>();
        while (!this.entries.empty()) {
            ChangeEntry ce = this.undo();
            if (ce == null) continue;
            ceList.add(ce);
        }
        return ceList;
    }

    public void destroy() {
        this.entries.clear();
        this.entries = null;
    }

    private static final class StopScanningException
    extends RuntimeException {
        private StopScanningException() {
        }
    }

    private class DiffChangeLogOutput
    extends DefaultChangeLogHandler {
        private StringBuffer buffer;

        private DiffChangeLogOutput() {
        }

        @Override
        public void start() {
            this.buffer = new StringBuffer();
        }

        @Override
        public void startField(String fieldName) {
            this.buffer.append(" " + fieldName + ": ");
        }

        @Override
        public void showChange(Object oldValue, Object newValue) {
            this.buffer.append(oldValue + " -> " + newValue + " ");
        }

        @Override
        public void endField() {
            this.buffer.append(" | ");
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public void clear(ChangeLog log) {
        }
    }

    private static final class CheckChangesHandler
    extends DefaultChangeLogHandler {
        private boolean hasChanges;

        private CheckChangesHandler() {
        }

        @Override
        public void start() {
            this.hasChanges = false;
        }

        @Override
        public void showChange(Object oldValue, Object newValue) {
            boolean empty1 = this.empty(oldValue);
            boolean empty2 = this.empty(newValue);
            if (empty1 && empty2) {
                this.hasChanges = false;
            } else if (!empty1) {
                this.hasChanges = !oldValue.equals(newValue);
            } else {
                boolean bl = this.hasChanges = !newValue.equals(oldValue);
            }
            if (this.hasChanges) {
                throw new StopScanningException();
            }
        }

        private boolean empty(Object value) {
            if (value == null) {
                return true;
            }
            return value instanceof String && (value + "").trim().length() == 0;
        }

        public boolean getHasChanges() {
            return this.hasChanges;
        }

        @Override
        public void clear(ChangeLog changes) {
        }
    }

    private class PrintLogOutput
    extends DefaultChangeLogHandler {
        private StringBuffer buffer;

        private PrintLogOutput() {
        }

        @Override
        public void start() {
            this.buffer = new StringBuffer();
            this.buffer.append("CHANGE LOG ENTRIES: \n");
        }

        @Override
        public void startEntity(Object entity) {
            this.buffer.append("********************************************\n");
            this.buffer.append("Change Log for class " + entity.getClass() + " id:" + entity.hashCode() + "\n");
        }

        @Override
        public void startField(String fieldName) {
            this.buffer.append("  [name: " + fieldName + "]");
        }

        @Override
        public void showChange(Object oldValue, Object newValue) {
            this.buffer.append("[old:" + oldValue + ", new:" + newValue + "]\n");
        }

        @Override
        public void showHistory(Date timeChanged, Object oldValue, Object newValue) {
            this.buffer.append("         [" + timeChanged + ", old:" + oldValue + ", new:" + newValue + "]\n");
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public void clear(ChangeLog changes) {
        }
    }

    public static abstract class DefaultChangeLogHandler
    implements ChangeLogHandler {
        @Override
        public void start() {
        }

        @Override
        public void startEntity(Object entity) {
        }

        @Override
        public void startField(String fieldName) {
        }

        @Override
        public void showChange(Object oldValue, Object newValue) {
        }

        @Override
        public void showHistory(Date timeChanged, Object oldValue, Object newValue) {
        }

        @Override
        public void endField() {
        }

        @Override
        public void endEntity() {
        }

        @Override
        public void end() {
        }
    }

    public static final class FieldEntry {
        private String name;
        private Object oldValue;
        private Object newValue;
        private List<Object[]> changes = new ArrayList<Object[]>();

        FieldEntry(String name) {
            this.name = name;
        }

        public void addEntry(Date logTime, Object ov, Object nv) {
            if (this.changes.size() == 0) {
                this.oldValue = ov;
            }
            this.newValue = nv;
            this.changes.add(new Object[]{logTime, ov, nv});
        }

        public void scan(ChangeLogHandler handler) {
            handler.startField(this.name);
            handler.showChange(this.oldValue, this.newValue);
            for (Object[] hist : this.changes) {
                Date logTime = (Date)hist[0];
                handler.showHistory(logTime, hist[1], hist[2]);
            }
            handler.endField();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FieldEntry)) {
                return false;
            }
            return this.name.equals(((FieldEntry)obj).name);
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public List<Object[]> getChanges() {
            return this.changes;
        }
    }

    public static final class ChangeHist {
        private Object entity;
        private int id;
        private List<FieldEntry> entries = new ArrayList<FieldEntry>();

        ChangeHist(int id, Object entity) {
            this.id = id;
            this.entity = entity;
        }

        public void addEntry(String fldName, Object oldValue, Object newValue, Date logTime) {
            FieldEntry fe = new FieldEntry(fldName);
            int i = this.entries.indexOf(fe);
            if (i < 0) {
                this.entries.add(fe);
            } else {
                fe = this.entries.get(i);
            }
            fe.addEntry(logTime, oldValue, newValue);
        }

        public void scan(ChangeLogHandler handler) {
            handler.startEntity(this.entity);
            for (FieldEntry fe : this.entries) {
                fe.scan(handler);
            }
            handler.endEntity();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ChangeHist)) {
                return false;
            }
            return this.id == ((ChangeHist)obj).id;
        }
    }

    public static final class ChangeEntry {
        private Object entity;
        private String fieldName;
        private Object oldValue;
        private Object newValue;
        private Date logtime;

        ChangeEntry(Object entity, String fieldName, Object oldValue, Object newValue) {
            this.entity = entity;
            this.fieldName = fieldName;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.logtime = new Date();
        }

        public String getKey() {
            return this.entity.hashCode() + ":" + this.fieldName;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ChangeEntry)) {
                return false;
            }
            return this.getKey().equals(((ChangeEntry)obj).getKey());
        }

        public int getId() {
            return this.entity.hashCode();
        }

        public Object getEntity() {
            return this.entity;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Date getLogtime() {
            return this.logtime;
        }
    }
}

