/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.framework.ValidatorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanValidatorSupport {
    private Map<String, List<Map.Entry>> handlers = new HashMap<String, List<Map.Entry>>();
    private PropertyResolver propertyResolver = PropertyResolver.getInstance();

    public void add(Map map, boolean immediate) {
        if (map == null || map.isEmpty()) {
            return;
        }
        List<Map.Entry> list = this.handlers.get(immediate + "");
        if (list == null) {
            list = new ArrayList<Map.Entry>();
            this.handlers.put(immediate + "", list);
        }
        for (Map.Entry me : map.entrySet()) {
            Object val = me.getValue();
            if (val == null) continue;
            list.add(me);
        }
    }

    public void fireImmediateValidators(String name, Object value) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        List<Map.Entry> list = this.handlers.get("true");
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Map.Entry entry : list) {
            Object callback;
            String regex = entry.getKey() == null ? null : entry.getKey().toString();
            if (!this.match(name, regex) || (callback = entry.getValue()) == null) continue;
            try {
                new CallbackHandlerProxy(callback).call(value);
            }
            catch (Throwable t) {
                throw new ValidatorException(t);
            }
        }
    }

    public void fireValidators(Object bean) {
        if (bean == null) {
            return;
        }
        List<Map.Entry> list = this.handlers.get("false");
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Map.Entry entry : list) {
            Object key = entry.getKey();
            if (key == null || key.toString().trim().length() == 0) continue;
            Object value = null;
            try {
                value = this.propertyResolver.getProperty(bean, key.toString());
            }
            catch (Throwable t) {
                System.out.println("[fireValidators] failed to get bean value for '" + key + "' caused by " + t.getMessage());
            }
            Object callback = entry.getValue();
            if (callback == null) continue;
            try {
                new CallbackHandlerProxy(callback).call(value);
            }
            catch (Throwable t) {
                throw new ValidatorException(t);
            }
        }
    }

    private boolean match(String name, String regex) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        if (regex == null || regex.trim().length() == 0) {
            return false;
        }
        try {
            if ("*".equals(regex)) {
                regex = ".*";
            }
            return name.matches(regex);
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

