/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.control.text.DefaultTextField;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.ValueUtil;
import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class IconedTextField
extends DefaultTextField
implements ActionListener {
    public static final String ICON_ON_LEFT = "LEFT";
    public static final String ICON_ON_RIGHT = "RIGHT";
    private static final int XPAD = 4;
    private static final int MARGIN_PAD = 5;
    private Icon icon;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private String orientation = "RIGHT";
    private boolean mouseOverImage = false;

    public IconedTextField() {
        this(null);
    }

    public IconedTextField(String icon) {
        FieldSupport support = new FieldSupport();
        this.addMouseMotionListener(support);
        this.addMouseListener(support);
        this.addActionListener(this);
        this.setIcon(icon);
    }

    @Override
    protected boolean isEnabledEnterActionSupport() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.paintImpl(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintImpl(Graphics g) {
        super.paint(g);
        if (this.icon != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.isReadonly() || !this.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            } else if (!this.isFocusable() && !Beans.isDesignTime()) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.3f));
            } else if (this.mouseOverImage) {
                g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
            }
            if (this.imgWidth > 0) {
                int x = 0;
                int y = 0;
                if (this.orientation.toUpperCase() == ICON_ON_RIGHT) {
                    x = this.getWidth() - (this.imgWidth + 4);
                    y = (this.getHeight() - this.imgHeight) / 2;
                } else {
                    x = 4;
                    y = (this.getHeight() - this.imgHeight) / 2;
                }
                this.icon.paintIcon(this, g2, x, y);
            }
            g2.dispose();
        }
    }

    @Override
    public void setBorder(Border border) {
        Border inner = null;
        inner = ICON_ON_LEFT.equals(this.orientation) ? BorderFactory.createEmptyBorder(0, this.imgWidth + 5, 0, 0) : BorderFactory.createEmptyBorder(0, 0, 0, this.imgWidth + 5);
        Border newBorder = null;
        newBorder = border != null ? BorderFactory.createCompoundBorder(border, inner) : inner;
        super.setBorder(newBorder);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orient) {
        if (orient != null) {
            orient = orient.toUpperCase();
        }
        this.orientation = orient;
        Insets insets = super.getMargin();
        Insets actualInsets = null;
        if (ICON_ON_LEFT.equals(this.orientation)) {
            actualInsets = new Insets(insets.top, this.imgWidth + 5, insets.bottom, 0);
            super.setMargin(actualInsets);
        } else {
            actualInsets = new Insets(insets.top, insets.left, insets.bottom, this.imgWidth + 5);
            super.setMargin(actualInsets);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (icon != null) {
            this.imgWidth = icon.getIconWidth();
            this.imgHeight = icon.getIconHeight();
        }
    }

    public void setIcon(String path) {
        block4: {
            if (ValueUtil.isEmpty((Object)path)) {
                this.setIcon((Icon)null);
            } else {
                try {
                    ClassLoader loader = null;
                    loader = Beans.isDesignTime() ? this.getClass().getClassLoader() : ClientContext.getCurrentContext().getClassLoader();
                    URL url = loader.getResource(path);
                    this.setIcon(new ImageIcon(url));
                }
                catch (Exception ex) {
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block4;
                    ex.printStackTrace();
                }
            }
        }
    }

    protected void onactionPerformed(ActionEvent e) {
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        try {
            if (!(this.isFocusable() && this.isVisible() && this.isEnabled())) {
                return;
            }
            this.onactionPerformed(e);
        }
        catch (Exception ex) {
            MsgBox.err(ex);
        }
    }

    private class FieldSupport
    implements MouseListener,
    MouseMotionListener {
        private FieldSupport() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (IconedTextField.this.orientation.toUpperCase() == IconedTextField.ICON_ON_RIGHT) {
                if (e.getX() >= IconedTextField.this.getWidth() - (IconedTextField.this.imgWidth + 4)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IconedTextField.this.actionPerformed(null);
                        }
                    });
                }
            } else if (e.getX() > 0 && e.getX() < 4 + IconedTextField.this.imgWidth) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IconedTextField.this.actionPerformed(null);
                    }
                });
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IconedTextField.this.mouseOverImage = false;
            IconedTextField.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (IconedTextField.this.orientation.toUpperCase() == IconedTextField.ICON_ON_RIGHT) {
                if (e.getX() >= IconedTextField.this.getWidth() - (IconedTextField.this.imgWidth + 4)) {
                    IconedTextField.this.setCursor(Cursor.getPredefinedCursor(0));
                    IconedTextField.this.mouseOverImage = true;
                    IconedTextField.this.repaint();
                } else {
                    IconedTextField.this.setCursor(Cursor.getPredefinedCursor(2));
                    IconedTextField.this.mouseOverImage = false;
                    IconedTextField.this.repaint();
                }
            } else if (e.getX() > 0 && e.getX() < 4 + IconedTextField.this.imgWidth) {
                IconedTextField.this.setCursor(Cursor.getPredefinedCursor(0));
                IconedTextField.this.mouseOverImage = true;
                IconedTextField.this.repaint();
            } else {
                IconedTextField.this.setCursor(Cursor.getPredefinedCursor(2));
                IconedTextField.this.mouseOverImage = false;
                IconedTextField.this.repaint();
            }
        }
    }
}

