/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateParser {
    private Map<String, String> months = new HashMap<String, String>();
    private int advanceYearLimit = 15;

    public DateParser() {
        this.months.put("jan", "01");
        this.months.put("feb", "02");
        this.months.put("mar", "03");
        this.months.put("apr", "04");
        this.months.put("may", "05");
        this.months.put("jun", "06");
        this.months.put("jul", "07");
        this.months.put("aug", "08");
        this.months.put("sep", "09");
        this.months.put("oct", "10");
        this.months.put("nov", "11");
        this.months.put("dec", "12");
    }

    public int getAdvanceYearLimit() {
        return this.advanceYearLimit;
    }

    public void setAdvanceYearLimit(int advanceYearLimit) {
        this.advanceYearLimit = advanceYearLimit;
    }

    private Date convert(String text) {
        try {
            java.sql.Date dt = java.sql.Date.valueOf(text);
            return dt;
        }
        catch (Throwable dt) {
            try {
                Timestamp dt2 = Timestamp.valueOf(text);
                return dt2;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public Date parse(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Date dtc = this.convert(text);
        if (dtc != null) {
            return dtc;
        }
        int _advanceYearLimit = this.getAdvanceYearLimit();
        _advanceYearLimit = _advanceYearLimit < 0 ? 0 : _advanceYearLimit + 1;
        java.sql.Date currentDate = new java.sql.Date(System.currentTimeMillis());
        if (text.trim().toLowerCase().matches("now|today")) {
            return currentDate;
        }
        String sval = text.trim().replaceAll("\\s{2,}", " ").replaceAll(" ", "-").replaceAll("/", "-");
        if (sval.matches("[\\d]{8,8}")) {
            String syear = sval.substring(0, 4);
            String smonth = sval.substring(4, 6);
            String sday = sval.substring(6, 8);
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[\\d]{4,4}-[\\d]{1,2}-[\\d]{1,2}")) {
            String[] arr = sval.split("-");
            String syear = arr[0];
            String smonth = this.fillLeadingZeros(arr[1], 2);
            String sday = this.fillLeadingZeros(arr[2], 2);
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[\\d]{4,4}-[\\d]{1,2}")) {
            String[] arr = sval.split("-");
            String syear = arr[0];
            String smonth = this.fillLeadingZeros(arr[1], 2);
            String sday = currentDate.toString().split("-")[2];
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[\\d]{1,2}-[\\d]{1,2}-[\\d]{4,4}")) {
            String[] arr = sval.split("-");
            String syear = arr[2];
            String smonth = this.fillLeadingZeros(arr[0], 2);
            String sday = this.fillLeadingZeros(arr[1], 2);
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[\\d]{1,2}-[\\d]{1,2}-[\\d]{1,2}")) {
            String[] arr = sval.split("-");
            String smonth = this.fillLeadingZeros(arr[0], 2);
            String sday = this.fillLeadingZeros(arr[1], 2);
            String syear = arr[2];
            if (syear.length() <= 2) {
                String curyear = currentDate.toString().split("-")[0];
                int num1 = Integer.parseInt(curyear.substring(0, 2));
                int num2 = Integer.parseInt(curyear.substring(2, 4));
                int num = Integer.parseInt(syear);
                if (num > num2 + _advanceYearLimit) {
                    --num1;
                }
                syear = this.fillLeadingZeros(num1 + "", 2) + this.fillLeadingZeros(syear, 2);
            }
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[\\d]{1,2}-[\\d]{1,2}")) {
            String[] arr = sval.split("-");
            String syear = currentDate.toString().split("-")[0];
            String smonth = this.fillLeadingZeros(arr[0], 2);
            String sday = this.fillLeadingZeros(arr[1], 2);
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[a-zA-Z]{3,3}-[\\d]{1,2}")) {
            String[] arr = sval.split("-");
            String smonth = this.months.get(arr[0].toLowerCase());
            String sday = this.fillLeadingZeros(arr[1], 2);
            String syear = currentDate.toString().split("-")[0];
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[a-zA-Z]{3,3}-[\\d]{1,2}-[\\d]{1,2}")) {
            String[] arr = sval.split("-");
            String smonth = this.months.get(arr[0].toLowerCase());
            String sday = this.fillLeadingZeros(arr[1], 2);
            String syear = arr[2];
            if (syear.length() <= 2) {
                String curyear = currentDate.toString().split("-")[0];
                int num1 = Integer.parseInt(curyear.substring(0, 2));
                int num2 = Integer.parseInt(curyear.substring(2, 4));
                int num = Integer.parseInt(syear);
                if (num > num2 + _advanceYearLimit) {
                    --num1;
                }
                syear = this.fillLeadingZeros(num1 + "", 2) + this.fillLeadingZeros(syear, 2);
            }
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        if (sval.matches("[a-zA-Z]{3,3}-[\\d]{1,2}-[\\d]{4,4}")) {
            String[] arr = sval.split("-");
            String smonth = this.months.get(arr[0].toLowerCase());
            String sday = this.fillLeadingZeros(arr[1], 2);
            String syear = arr[2];
            return java.sql.Date.valueOf(syear + "-" + smonth + "-" + sday);
        }
        return null;
    }

    private String fillLeadingZeros(String value, int length) {
        int rem = length - value.toString().length();
        if (rem <= 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rem; ++i) {
            sb.append("0");
        }
        sb.append(value);
        return sb.toString();
    }
}

