/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.rcp.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

class TableHeaderBorder
extends AbstractBorder {
    private Insets margin = new Insets(0, 0, 0, 0);

    TableHeaderBorder() {
    }

    TableHeaderBorder(Insets margin) {
        if (margin != null) {
            this.margin = margin;
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.margin.top;
        insets.left = this.margin.left;
        insets.bottom = this.margin.bottom;
        insets.right = this.margin.right;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color shadow = UIManager.getColor("controlDkShadow");
        Color oldColor = g.getColor();
        g.setColor(ColorUtil.brighter(shadow, 20));
        g.drawRect(0, 0, w - 1, h - 1);
        g.setColor(ColorUtil.brighter(shadow, 40));
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, 1, w - 2, h - 2);
        g.setColor(ColorUtil.brighter(shadow, 55));
        g.drawRect(0, 0, w, h);
        g.setColor(oldColor);
    }
}

