/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RowHeaderView
extends JPanel
implements TableModelListener {
    private int rowCount;
    private int currentRow = -1;
    private JTable table;

    public RowHeaderView(JTable table) {
        this.table = table;
        this.setLayout(new RowHeaderLayout());
    }

    public void setRowCount(int rowCount) {
        if (this.rowCount == rowCount) {
            return;
        }
        this.rowCount = rowCount;
        this.removeAll();
        Object label = null;
        for (int i = 0; i < rowCount; ++i) {
            this.add(new RowView(this.table));
        }
    }

    public void clearEditing() {
        RowView rh;
        if (this.currentRow != -1 && (rh = this.getRowView(this.currentRow)) != null) {
            rh.edit(false);
        }
        this.currentRow = -1;
    }

    public void editRow(int row) {
        RowView rh;
        if (this.currentRow != row) {
            this.clearEditing();
        }
        if ((rh = this.getRowView(row)) != null) {
            rh.edit(true);
        }
        this.currentRow = row;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setRowCount(this.table.getRowCount());
        this.repaint();
    }

    private RowView getRowView(int index) {
        try {
            return (RowView)this.getComponent(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class RowHeaderLayout
    implements LayoutManager {
        private RowHeaderLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!(comps[i] instanceof RowView)) continue;
                    int rh = RowHeaderView.this.table.getRowHeight(i);
                    comps[i].setBounds(x, y, w, rh);
                    y += rh;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!(comps[i] instanceof RowView)) continue;
                    Dimension dim = comps[i].getPreferredSize();
                    w = Math.max(w, dim.width);
                    h += RowHeaderView.this.table.getRowHeight(i);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }
    }

    private class RowView
    extends JLabel {
        private Color defaultColor = SystemColor.control;
        private JTable table;

        public RowView(JTable table) {
            this.table = table;
            this.setPreferredSize(new Dimension(23, 23));
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setForeground(Color.BLUE);
            this.setFont(new Font("Monospaced", 0, 12));
        }

        @Override
        public void setText(String text) {
        }

        public void edit(boolean b) {
            if (b) {
                super.setText("*");
            } else {
                super.setText("");
            }
        }
    }
}

