/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.DynamicColumn;
import com.rameses.rcp.control.table.CellRenderers;
import com.rameses.rcp.control.table.ColumnHandlerUtil;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;

public class DynamicCellRenderer
extends CellRenderers.AbstractRenderer {
    private ColumnHandlerUtil columnUtil = ColumnHandlerUtil.newInstance();
    private JLabel label = new JLabel("");
    private CellRenderers.Context ctx;

    @Override
    public JComponent getComponent(JTable table, int rowIndex, int columnIndex) {
        return this.label;
    }

    @Override
    public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int columnIndex) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        this.ctx = new CellRenderers.Context(table, value, rowIndex, columnIndex);
        Column itemColumn = this.getItemColumn();
        if (itemColumn == null) {
            return this.label;
        }
        return null;
    }

    private Column getItemColumn() {
        Column oColumn = this.ctx.getColumn();
        if (!(oColumn instanceof DynamicColumn)) {
            return null;
        }
        Object exprBean = this.ctx.createExpressionBean();
        Column selColumn = null;
        DynamicColumn dc = (DynamicColumn)oColumn;
        for (Column ic : dc.getColumns()) {
            String visibleWhen = ic.getVisibleWhen();
            if (visibleWhen == null && ic.isVisible()) {
                selColumn = ic;
                break;
            }
            if (!ic.isVisible()) continue;
            boolean b = false;
            try {
                b = UIControlUtil.evaluateExprBoolean(exprBean, visibleWhen);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!b) continue;
            selColumn = ic;
            break;
        }
        return selColumn;
    }
}

