/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.common.ExpressionResolver;
import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.ButtonColumnHandler;
import com.rameses.rcp.common.CheckBoxColumnHandler;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.ComboBoxColumnHandler;
import com.rameses.rcp.common.DateColumnHandler;
import com.rameses.rcp.common.DecimalColumnHandler;
import com.rameses.rcp.common.EditorListSupport;
import com.rameses.rcp.common.IntegerColumnHandler;
import com.rameses.rcp.common.LabelColumnHandler;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.LookupColumnHandler;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.OpenerColumnHandler;
import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.control.table.ColumnHandlerUtil;
import com.rameses.rcp.control.table.DataTableComponent;
import com.rameses.rcp.control.table.DataTableModel;
import com.rameses.rcp.control.table.DataTableModelDesignTime;
import com.rameses.rcp.control.table.TableBorders;
import com.rameses.rcp.control.table.TableControl;
import com.rameses.rcp.control.table.TableControlModel;
import com.rameses.rcp.control.table.TableUtil;
import com.rameses.rcp.support.ComponentSupport;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class CellRenderers {
    private static Map<String, Class> renderers = new HashMap<String, Class>();

    public static AbstractRenderer getRendererFor(Column oColumn) {
        Column.TypeHandler handler = oColumn.getTypeHandler();
        if (handler == null) {
            handler = ColumnHandlerUtil.newInstance().createTypeHandler(oColumn);
        }
        return null;
    }

    public static String getPreferredAlignment(Column oColumn) {
        if (oColumn == null) {
            return null;
        }
        String alignment = oColumn.getAlignment();
        if (alignment != null) {
            return alignment;
        }
        Column.TypeHandler handler = oColumn.getTypeHandler();
        if (handler instanceof CheckBoxColumnHandler) {
            oColumn.setAlignment("top_center");
        } else if (handler instanceof DecimalColumnHandler) {
            oColumn.setAlignment("top_right");
        } else if (handler instanceof IntegerColumnHandler) {
            oColumn.setAlignment("top_center");
        } else {
            oColumn.setAlignment("top_left");
        }
        return oColumn.getAlignment();
    }

    static {
        renderers.put("text", TextRenderer.class);
        renderers.put("string", TextRenderer.class);
        renderers.put("boolean", CheckBoxRenderer.class);
        renderers.put("checkbox", CheckBoxRenderer.class);
        renderers.put("combo", ComboBoxRenderer.class);
        renderers.put("combobox", ComboBoxRenderer.class);
        renderers.put("date", DateRenderer.class);
        renderers.put("decimal", DecimalRenderer.class);
        renderers.put("double", DecimalRenderer.class);
        renderers.put("integer", IntegerRenderer.class);
        renderers.put("label", LabelRenderer.class);
        renderers.put("lookup", LookupRenderer.class);
        renderers.put("opener", OpenerRenderer.class);
        renderers.put("button", ButtonRenderer.class);
        renderers.put("icon", IconRenderer.class);
    }

    public static interface ActionColumnHandler {
        public void invokeAction() throws Exception;
    }

    static class LabelControl
    extends JLabel {
        private final Insets DEFAULT_MARGIN = TableUtil.CELL_MARGIN;
        private ImageIcon rightIcon;

        LabelControl() {
            this.setBorder(BorderFactory.createEmptyBorder(this.DEFAULT_MARGIN.top, this.DEFAULT_MARGIN.left, this.DEFAULT_MARGIN.bottom, this.DEFAULT_MARGIN.right));
        }

        public ImageIcon getRightIcon() {
            return this.rightIcon;
        }

        public void setRightIcon(ImageIcon rightIcon) {
            this.rightIcon = rightIcon;
        }

        @Override
        public Insets getInsets(Insets insets) {
            int rightPad;
            Insets ins = super.getInsets(insets);
            if (ins == null) {
                ins = new Insets(0, 0, 0, 0);
            }
            ins.top = Math.max(this.DEFAULT_MARGIN.top, ins.top);
            ins.left = Math.max(this.DEFAULT_MARGIN.left, ins.left);
            ins.bottom = Math.max(this.DEFAULT_MARGIN.bottom, ins.bottom);
            ins.right = Math.max(this.DEFAULT_MARGIN.right, ins.right);
            ImageIcon iicon = this.getRightIcon();
            if (iicon == null) {
                return ins;
            }
            Insets ins0 = new Insets(ins.top, ins.left, ins.bottom, ins.right);
            int iconWidth = iicon.getIconWidth();
            ins0.right = rightPad = Math.max(ins0.right, iconWidth + 3);
            return ins0;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ImageIcon iicon = this.getRightIcon();
            if (iicon != null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setComposite(AlphaComposite.getInstance(10, 0.8f));
                int imgWidth = iicon.getIconWidth();
                int imgHeight = iicon.getIconHeight();
                int x = this.getWidth() - (imgWidth + 3);
                int y = (this.getHeight() - imgHeight) / 2;
                iicon.paintIcon(this, g2, x, y);
                g2.dispose();
            }
        }
    }

    public static class IconRenderer
    extends AbstractRenderer {
        private JLabel label = this.createComponent();

        public IconRenderer() {
            this.label.setVerticalAlignment(0);
        }

        private JLabel createComponent() {
            if (this.label == null) {
                this.label = new JLabel();
                this.label.setHorizontalAlignment(0);
            }
            return this.label;
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int columnIndex) {
            return this.label;
        }

        @Override
        protected void decorateSelected(JTable table, JComponent comp, boolean selected, boolean hasFocus) {
            super.decorateSelected(table, comp, false, hasFocus);
        }

        protected Object resolveValue(Context ctx) {
            return ctx.getValue();
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int columnIndex) {
            Object cellValue = this.resolveValue(this.getContext());
            Column oColumn = this.getContext().getColumn();
            Column.TypeHandler handler = oColumn == null ? null : oColumn.getTypeHandler();
            try {
                String expression;
                String string = expression = oColumn == null ? null : oColumn.getExpression();
                if (expression != null && expression.trim().length() > 0) {
                    Object exprBean = this.getContext().createExpressionBean();
                    cellValue = UIControlUtil.evaluateExpr(exprBean, expression);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.loadIcon(cellValue);
        }

        void loadIcon(Object value) {
            block14: {
                this.label.setText("");
                if (value == null) {
                    this.label.setIcon(null);
                } else if (value instanceof ImageIcon) {
                    this.label.setIcon((ImageIcon)value);
                } else if (value instanceof byte[]) {
                    try {
                        this.label.setIcon(new ImageIcon((byte[])value));
                    }
                    catch (Throwable t) {
                        System.out.println("[WARN] failed to render icon caused by " + t.getClass().getName() + ": " + t.getMessage());
                        this.label.setIcon(null);
                    }
                } else if (value instanceof String) {
                    try {
                        String sval = value.toString();
                        if (sval.matches("[a-zA-Z0-9]://.*")) {
                            this.label.setIcon(new ImageIcon(new URL(sval)));
                            break block14;
                        }
                        ImageIcon iicon = ImageIconSupport.getInstance().getIcon(sval);
                        if (iicon == null) {
                            iicon = new ImageIcon(this.getClass().getClassLoader().getResource(sval));
                        }
                        this.label.setIcon(iicon);
                    }
                    catch (Throwable t) {
                        this.label.setIcon(null);
                    }
                } else {
                    this.label.setIcon(null);
                }
            }
        }
    }

    public static class OpenerRenderer
    extends TextRenderer {
        @Override
        protected Object resolveValue(Context ctx) {
            Column oColumn = ctx.getColumn();
            String expression = oColumn.getExpression();
            if ((expression == null || expression.length() == 0) && oColumn.getTypeHandler() instanceof OpenerColumnHandler) {
                expression = ((OpenerColumnHandler)oColumn.getTypeHandler()).getExpression();
            }
            Object cellValue = ctx.getValue();
            if (expression != null) {
                try {
                    Object exprBean = this.getContext().createExpressionBean();
                    cellValue = UIControlUtil.evaluateExpr(exprBean, expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return cellValue;
        }
    }

    public static class LookupRenderer
    extends TextRenderer {
        private ImageIcon icon;

        @Override
        protected void initComponent(LabelControl label) {
            String iconpath = "com/rameses/rcp/icons/search.png";
            this.icon = ImageIconSupport.getInstance().getIcon(iconpath);
        }

        @Override
        protected Object resolveValue(Context ctx) {
            Column oColumn = ctx.getColumn();
            String expression = oColumn.getExpression();
            if ((expression == null || expression.trim().length() == 0) && oColumn.getTypeHandler() instanceof LookupColumnHandler) {
                expression = ((LookupColumnHandler)oColumn.getTypeHandler()).getExpression();
            }
            Object cellValue = ctx.getValue();
            if (expression != null) {
                try {
                    Object exprBean = this.getContext().createExpressionBean();
                    cellValue = UIControlUtil.evaluateExpr(exprBean, expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return cellValue;
        }

        @Override
        protected void decorate(LabelControl label, Column oColumn, ListItem li) {
            if (li == null) {
                label.setRightIcon(null);
            } else if (li.getIndex() == 0) {
                label.setRightIcon(this.icon);
            } else if (li.getState() == 0) {
                label.setRightIcon(null);
            } else {
                label.setRightIcon(this.icon);
            }
        }
    }

    public static class LabelRenderer
    extends AbstractRenderer {
        private JLabel label = this.createComponent();

        public LabelRenderer() {
            this.label.setVerticalAlignment(0);
        }

        private JLabel createComponent() {
            if (this.label == null) {
                this.label = new JLabel();
            }
            return this.label;
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int columnIndex) {
            return this.label;
        }

        protected Object resolveValue(Context ctx) {
            return ctx.getValue();
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int columnIndex) {
            TextCase oTextCase;
            Object columnValue = this.resolveValue(this.getContext());
            Column oColumn = this.getContext().getColumn();
            TextCase textCase = oTextCase = oColumn == null ? null : oColumn.getTextCase();
            if (oTextCase != null && columnValue != null) {
                this.label.setText("<html>" + oTextCase.convert(columnValue.toString()) + "</html>");
            }
            this.label.setHorizontalAlignment(2);
            if (oColumn != null && oColumn.getAlignment() != null) {
                this.getComponentSupport().alignText(this.label, oColumn.getAlignment());
            }
            this.setValue(this.label, oColumn, columnValue);
        }

        protected void setValue(JLabel label, Column oColumn, Object value) {
            Object cellValue = value;
            Column.TypeHandler handler = oColumn == null ? null : oColumn.getTypeHandler();
            try {
                String expression = ((LabelColumnHandler)handler).getExpression();
                if (expression != null && expression.length() > 0) {
                    Object exprBean = this.getContext().createExpressionBean();
                    cellValue = UIControlUtil.evaluateExpr(exprBean, expression);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (oColumn != null && cellValue != null && oColumn.isHtmlDisplay()) {
                cellValue = "<html>" + cellValue + "</html>";
            }
            label.setText("<html>" + (cellValue == null ? "" : cellValue.toString()) + "</html>");
        }
    }

    public static class ButtonRenderer
    extends AbstractRenderer
    implements ActionColumnHandler {
        private JLabel label = new JLabel();
        private JButton button = new JButton();

        public ButtonRenderer() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int columnIndex) {
            this.button.setVisible(this.getContext().getItemData() != null);
            if (!this.button.isVisible()) {
                return this.label;
            }
            Column oColumn = this.getContext().getColumn();
            ButtonColumnHandler bch = (ButtonColumnHandler)oColumn.getTypeHandler();
            String expr = bch.getVisibleWhen();
            if (expr != null && expr.trim().length() > 0) {
                boolean b = false;
                try {
                    Object exprBean = this.getContext().createExpressionBean();
                    b = UIControlUtil.evaluateExprBoolean(exprBean, expr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.button.setVisible(b);
            }
            return this.button.isVisible() ? this.button : this.label;
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int colIndex) {
            if (!this.button.isVisible()) {
                return;
            }
            Object cellValue = null;
            Column oColumn = this.getContext().getColumn();
            String expr = oColumn.getExpression();
            if (expr != null && expr.trim().length() > 0) {
                Object exprBean = this.getContext().createExpressionBean();
                cellValue = UIControlUtil.evaluateExpr(exprBean, expr);
            }
            this.button.setText(cellValue == null ? " " : cellValue.toString());
        }

        @Override
        public void invokeAction() throws Exception {
        }
    }

    public static class IntegerRenderer
    extends AbstractNumberRenderer {
        @Override
        protected String resolveAlignment(String alignment) {
            if (alignment == null || alignment.length() == 0) {
                return "CENTER";
            }
            return alignment;
        }

        @Override
        protected String getFormattedValue(Column c, Object value) {
            Integer num = null;
            if (value != null) {
                if (value instanceof Integer) {
                    num = (Integer)value;
                } else {
                    try {
                        num = new Integer(value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (num == null) {
                return null;
            }
            String format = null;
            format = c.getTypeHandler() instanceof IntegerColumnHandler ? ((IntegerColumnHandler)c.getTypeHandler()).getFormat() : c.getFormat();
            if (format == null || format.length() == 0) {
                return ((Object)num).toString();
            }
            return this.formatValue(num, c.getFormat(), "0");
        }
    }

    public static class DecimalRenderer
    extends AbstractNumberRenderer {
        @Override
        protected String getFormattedValue(Column c, Object value) {
            BigDecimal num = null;
            if (value != null) {
                if (value instanceof BigDecimal) {
                    num = (BigDecimal)value;
                } else {
                    try {
                        num = new BigDecimal(value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (num == null) {
                return null;
            }
            String format = null;
            format = c.getTypeHandler() instanceof DecimalColumnHandler ? ((DecimalColumnHandler)c.getTypeHandler()).getFormat() : c.getFormat();
            if (format == null || format.length() == 0) {
                return ((Object)num).toString();
            }
            return this.formatValue(num, format, "#,##0.00");
        }
    }

    public static class DateRenderer
    extends TextRenderer {
        private SimpleDateFormat outputFormatter;

        @Override
        protected Object resolveValue(Context ctx) {
            String format = null;
            Column oColumn = ctx.getColumn();
            DateColumnHandler dateHandler = null;
            if (oColumn.getTypeHandler() instanceof DateColumnHandler) {
                dateHandler = (DateColumnHandler)oColumn.getTypeHandler();
                format = dateHandler.getOutputFormat();
            } else {
                format = oColumn.getFormat();
            }
            Object cellValue = ctx.getValue();
            if (format == null || format.trim().length() == 0) {
                return cellValue;
            }
            if (dateHandler != null) {
                try {
                    return dateHandler.format(cellValue, format);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (format != null && cellValue instanceof Date) {
                try {
                    if (this.outputFormatter == null) {
                        this.outputFormatter = new SimpleDateFormat(format);
                    }
                    cellValue = this.outputFormatter.format((Date)cellValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return cellValue;
        }
    }

    public static class ComboBoxRenderer
    extends TextRenderer {
        @Override
        protected Object resolveValue(Context ctx) {
            Column oColumn = ctx.getColumn();
            String expression = oColumn.getExpression();
            if ((expression == null || expression.trim().length() == 0) && oColumn.getTypeHandler() instanceof ComboBoxColumnHandler) {
                expression = ((ComboBoxColumnHandler)oColumn.getTypeHandler()).getExpression();
            }
            Object cellValue = ctx.getValue();
            if (expression != null && !(cellValue instanceof String)) {
                try {
                    Object exprBean = ctx.createExpressionBean();
                    cellValue = UIControlUtil.evaluateExpr(exprBean, expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return cellValue;
        }
    }

    public static class CheckBoxRenderer
    extends AbstractRenderer {
        private JCheckBox component = new JCheckBox();
        private JLabel empty;

        public CheckBoxRenderer() {
            this.component.setHorizontalAlignment(0);
            this.component.setBorderPainted(true);
            this.empty = new JLabel("");
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int colIndex) {
            return this.getContext().getItemData() == null ? this.empty : this.component;
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int columnIndex) {
            Object itemData = this.getContext().getItemData();
            if (itemData == null) {
                return;
            }
            Column oColumn = this.getContext().getColumn();
            String str_align = oColumn.getAlignment();
            if (str_align == null || str_align.trim().length() == 0) {
                str_align = "TOP_CENTER";
            }
            this.getComponentSupport().alignText(this.component, str_align);
            this.component.setSelected(this.resolveValue(oColumn, value));
        }

        private boolean resolveValue(Column oColumn, Object value) {
            Object checkValue = null;
            checkValue = oColumn.getTypeHandler() instanceof CheckBoxColumnHandler ? ((CheckBoxColumnHandler)oColumn.getTypeHandler()).getCheckValue() : oColumn.getCheckValue();
            boolean selected = false;
            if (value == null) {
                selected = false;
            } else if (value != null && checkValue != null && value.equals(checkValue)) {
                selected = true;
            } else if (value.equals(checkValue + "")) {
                selected = true;
            } else if ("true".equals(value + "")) {
                selected = true;
            } else if ("yes".equals(value + "")) {
                selected = true;
            } else if ("t".equals(value + "")) {
                selected = true;
            } else if ("y".equals(value + "")) {
                selected = true;
            } else if ("1".equals(value + "")) {
                selected = true;
            }
            return selected;
        }
    }

    public static class TextRenderer
    extends AbstractRenderer {
        private LabelControl label = this.createComponent();

        public TextRenderer() {
            this.label.setVerticalAlignment(1);
            this.initComponent(this.label);
        }

        protected void initComponent(LabelControl label) {
        }

        private LabelControl createComponent() {
            this.label = new LabelControl();
            return this.label;
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int columnIndex) {
            return this.label;
        }

        protected Object resolveValue(Context ctx) {
            return ctx.getValue();
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int columnIndex) {
            TextCase oTextCase;
            Object columnValue = this.resolveValue(this.getContext());
            Column oColumn = this.getContext().getColumn();
            TextCase textCase = oTextCase = oColumn == null ? null : oColumn.getTextCase();
            if (oTextCase != null && columnValue != null) {
                this.label.setText(oTextCase.convert(columnValue.toString()));
            }
            this.label.setHorizontalAlignment(2);
            if (oColumn != null && oColumn.getAlignment() != null) {
                String str_align = oColumn.getAlignment();
                if (str_align.indexOf(95) < 0) {
                    str_align = "TOP_" + str_align;
                }
                this.getComponentSupport().alignText(this.label, str_align);
            }
            try {
                ListItem li = this.getContext().getDataProvider().getListItem(rowIndex);
                this.decorate(this.label, oColumn, li);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setValue(this.label, oColumn, columnValue);
        }

        protected void decorate(LabelControl label, Column oColumn, ListItem li) {
        }

        protected void setValue(JLabel label, Column oColumn, Object value) {
            TextCase oTextCase;
            if (value != null && oColumn != null && oColumn.isHtmlDisplay()) {
                value = "<html>" + value + "</html>";
            }
            String str = value == null ? "" : value.toString();
            TextCase textCase = oTextCase = oColumn == null ? null : oColumn.getTextCase();
            if (oTextCase != null) {
                label.setText(oTextCase.convert(str));
            } else {
                label.setText(str);
            }
        }
    }

    public static abstract class AbstractNumberRenderer
    extends AbstractRenderer {
        private JLabel label = new JLabel();

        public AbstractNumberRenderer() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int columnIndex) {
            return this.label;
        }

        protected abstract String getFormattedValue(Column var1, Object var2);

        protected String resolveAlignment(String alignment) {
            return alignment;
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int columnIndex) {
            Column c = this.getContext().getColumn();
            String result = this.getFormattedValue(c, value);
            this.label.setText(result == null ? "" : result);
            String alignment = c.getAlignment();
            if (alignment == null || alignment.trim().length() == 0) {
                alignment = "TOP_RIGHT";
            }
            this.getComponentSupport().alignText(this.label, alignment);
        }

        protected String formatValue(Number value, String format, String defaultFormat) {
            if (value == null) {
                return null;
            }
            if ("".equals(format)) {
                return value.toString();
            }
            DecimalFormat formatter = null;
            formatter = format != null ? new DecimalFormat(format) : new DecimalFormat(defaultFormat);
            return formatter.format(value);
        }
    }

    public static abstract class AbstractRenderer
    implements TableCellRenderer {
        protected final Insets DEFAULT_MARGIN = TableUtil.CELL_MARGIN;
        private Insets CELL_MARGIN = TableUtil.CELL_MARGIN;
        private Color FOCUS_BG = TableUtil.FOCUS_BG;
        private ComponentSupport componentSupport;
        private Context ctx;

        protected ComponentSupport getComponentSupport() {
            if (this.componentSupport == null) {
                this.componentSupport = new ComponentSupport();
            }
            return this.componentSupport;
        }

        protected Context getContext() {
            return this.ctx;
        }

        protected TableControl getTableControl() {
            return this.ctx.getTableControl();
        }

        protected TableControlModel getTableControlModel() {
            return this.ctx.getTableControlModel();
        }

        public abstract JComponent getComponent(JTable var1, int var2, int var3);

        public abstract void refresh(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            this.ctx = new Context(table, value, rowIndex, columnIndex);
            TableControl tc = this.ctx.getTableControl();
            TableControlModel tcm = this.ctx.getTableControlModel();
            JComponent comp = this.getComponent(table, rowIndex, columnIndex);
            this.getComponentSupport().setEmptyBorder(comp, this.CELL_MARGIN);
            comp.setFont(table.getFont());
            comp.setForeground(table.getForeground());
            comp.setOpaque(false);
            if ((rowIndex + 1) % 2 == 0) {
                if (tc.getEvenBackground() != null) {
                    comp.setBackground(tc.getEvenBackground());
                    comp.setOpaque(true);
                }
                if (tc.getEvenForeground() != null) {
                    comp.setForeground(tc.getEvenForeground());
                }
            } else {
                if (tc.getOddBackground() != null) {
                    comp.setBackground(tc.getOddBackground());
                    comp.setOpaque(true);
                }
                if (tc.getOddForeground() != null) {
                    comp.setForeground(tc.getOddForeground());
                }
            }
            if (isSelected) {
                this.decorateSelected(table, comp, isSelected, hasFocus);
            }
            try {
                this.applyStyles(comp, hasFocus);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AbstractListDataProvider ldp = this.ctx.getDataProvider();
            String errmsg = ldp.getMessageSupport().getErrorMessage(rowIndex);
            if (errmsg != null && !hasFocus) {
                comp.setBackground(tc.getErrorBackground());
                comp.setForeground(tc.getErrorForeground());
                comp.setOpaque(true);
            }
            TableBorders.CellBorder cellborder = new TableBorders.CellBorder(table, rowIndex, columnIndex);
            Border inner = this.getComponentSupport().createEmptyBorder(this.CELL_MARGIN);
            Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
            }
            comp.setBorder(BorderFactory.createCompoundBorder(border, inner));
            this.refresh(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            return comp;
        }

        protected void decorateSelected(JTable table, JComponent comp, boolean selected, boolean hasFocus) {
            if (selected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
                comp.setOpaque(true);
            }
            if (hasFocus) {
                comp.setBackground(this.FOCUS_BG);
                comp.setForeground(table.getForeground());
                comp.setOpaque(true);
            }
        }

        private void applyStyles(JComponent comp, boolean hasFocus) {
            TableControl tc = this.getContext().getTableControl();
            if (tc.getVarName() == null || tc.getVarName().length() == 0) {
                return;
            }
            if (tc.getId() == null || tc.getId().length() == 0) {
                return;
            }
            StyleRule[] styles = tc.getBinding().getStyleRules();
            if (styles == null || styles.length == 0) {
                return;
            }
            String colName = this.getContext().getColumn().getName();
            String sname = tc.getId() + ":" + tc.getVarName() + "." + colName;
            ExpressionResolver res = ExpressionResolver.getInstance();
            FontSupport fontSupport = new FontSupport();
            for (StyleRule r : styles) {
                String pattern = r.getPattern();
                String expr = r.getExpression();
                if (expr == null || !sname.matches(pattern)) continue;
                try {
                    Object exprBean = this.getContext().createExpressionBean();
                    boolean matched = res.evalBoolean(expr, exprBean);
                    if (!matched) continue;
                    if (hasFocus) {
                        fontSupport.applyStyles(comp, r.getProperties());
                        continue;
                    }
                    r.getProperties().remove("enabled");
                    ControlSupport.setStyles(r.getProperties(), comp);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static class HeaderBorder
    extends AbstractBorder {
        private final Color BORDER_COLOR = new Color(204, 204, 204);
        public boolean showLeft = true;
        public boolean showRight = false;
        private Icon ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        private Icon descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");
        private Icon sortIcon;

        public void setSortType(int sortType) {
            this.sortIcon = sortType == 1 ? this.ascendingSortIcon : (sortType == 2 ? this.descendingSortIcon : null);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets pad) {
            if (pad == null) {
                pad = new Insets(0, 0, 0, 0);
            }
            Insets newpad = new Insets(0, 0, 0, 0);
            newpad.bottom = 5;
            newpad.top = 5;
            newpad.right = 8;
            newpad.left = 8;
            if (this.sortIcon != null) {
                newpad.right += this.sortIcon.getIconWidth();
            }
            return newpad;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            g.setColor(this.BORDER_COLOR);
            if (this.showLeft) {
                g.drawLine(0, 5, 0, h - 6);
            }
            if (this.showRight) {
                g.drawLine(w - 1, 5, w - 1, h - 6);
            }
            g.drawLine(0, h - 1, w, h - 1);
            g.setColor(oldColor);
            if (this.sortIcon != null && this.sortIcon instanceof ImageIcon) {
                ImageIcon ic = (ImageIcon)this.sortIcon;
                int ix = w - this.sortIcon.getIconWidth();
                int iy = Math.max(h / 2 - this.sortIcon.getIconHeight() / 2, y);
                g.drawImage(ic.getImage(), ix, iy, null);
            }
        }
    }

    public static class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private ComponentSupport componentSupport;
        private boolean hideAll;

        public HeaderRenderer() {
            this(false);
        }

        public HeaderRenderer(boolean hideAll) {
            this.hideAll = hideAll;
        }

        private ComponentSupport getComponentSupport() {
            if (this.componentSupport == null) {
                this.componentSupport = new ComponentSupport();
            }
            return this.componentSupport;
        }

        private void init(Column col) {
            if (col == null) {
                return;
            }
            String alignment = CellRenderers.getPreferredAlignment(col);
            this.getComponentSupport().alignText(this, alignment);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
            boolean autoresizeoff;
            AbstractTableModel dtm;
            if (table == null) {
                return this;
            }
            this.setFont(table.getFont());
            this.setText(value + "");
            this.putClientProperty("Component.proxy", table);
            int sortType = 0;
            TableModel tm = table.getModel();
            if (tm instanceof DataTableModel) {
                dtm = (DataTableModel)tm;
                this.init(((DataTableModel)dtm).getColumn(colIndex));
                sortType = ((DataTableModel)dtm).getSortType();
            } else if (tm instanceof DataTableModelDesignTime) {
                dtm = (DataTableModelDesignTime)tm;
                this.init(((DataTableModelDesignTime)dtm).getColumn(colIndex));
            }
            HeaderBorder border = new HeaderBorder();
            border.setSortType(sortType);
            if (this.hideAll) {
                border.showRight = false;
                border.showLeft = false;
                return this;
            }
            boolean hasRowHeader = false;
            if (table instanceof DataTableComponent) {
                hasRowHeader = ((DataTableComponent)table).hasRowHeader();
            }
            border.showLeft = true;
            if (colIndex == 0 && !hasRowHeader) {
                border.showLeft = false;
            }
            boolean bl = autoresizeoff = table.getAutoResizeMode() == 0;
            border.showRight = autoresizeoff ? colIndex + 1 == tm.getColumnCount() : false;
            this.setBorder(border);
            return this;
        }

        protected Color getHighlightColor() {
            return this.getBackground().brighter();
        }

        protected Color getShadowColor() {
            return this.getBackground().darker();
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public static class Context {
        private JTable table;
        private Object value;
        private int rowIndex;
        private int columnIndex;
        private TableControl tableControl;
        private TableControlModel tableControlModel;

        Context(JTable table, Object value, int rowIndex, int columnIndex) {
            this.table = table;
            this.value = value;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
            this.tableControl = (TableControl)((Object)table);
            this.tableControlModel = (TableControlModel)((Object)this.tableControl.getModel());
        }

        public JTable getTable() {
            return this.table;
        }

        public Object getValue() {
            return this.value;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public TableControl getTableControl() {
            return this.tableControl;
        }

        public TableControlModel getTableControlModel() {
            return this.tableControlModel;
        }

        public AbstractListDataProvider getDataProvider() {
            return this.tableControl.getDataProvider();
        }

        public Object getItemData() {
            return this.getItemData(this.rowIndex);
        }

        public Object getItemData(int rowIndex) {
            return this.getDataProvider().getListItemData(rowIndex);
        }

        public Column getColumn() {
            return this.getColumn(this.columnIndex);
        }

        public Column getColumn(int index) {
            return this.getTableControlModel().getColumn(index);
        }

        public Object createExpressionBean() {
            return this.createExpressionBean(this.getItemData());
        }

        public Object createExpressionBean(Object bean) {
            return this.getTableControl().createExpressionBean(bean);
        }

        public boolean setValueAt(int rowIndex, int colIndex, Object value) {
            try {
                this.getTable().getModel().setValueAt(value, rowIndex, colIndex);
                return true;
            }
            catch (EditorListSupport.BeforeColumnUpdateException bcx) {
                if (bcx.getCause() != null) {
                    MsgBox.err(bcx.getCause());
                }
                return false;
            }
            catch (EditorListSupport.AfterColumnUpdateException acx) {
                if (acx.getCause() != null) {
                    MsgBox.err(acx.getCause());
                }
                return true;
            }
            catch (Exception ex) {
                MsgBox.err(ex);
                return false;
            }
        }

        public Object fetchValueAt(int rowIndex, int colIndex) {
            Object itemData = this.getItemData(rowIndex);
            if (itemData == null) {
                return null;
            }
            String name = this.getColumn(colIndex).getName();
            return UIControlUtil.getBeanValue(itemData, name);
        }
    }
}

