/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class YLayout
implements LayoutManager {
    private int spacing = 2;
    private boolean autoFill;

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public boolean isAutoFill() {
        return this.autoFill;
    }

    public void setAutoFill(boolean autoFill) {
        this.autoFill = autoFill;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            boolean has_visible_components = false;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!c.isVisible()) continue;
                if (has_visible_components) {
                    h += this.getSpacing();
                }
                Dimension dim = c.getPreferredSize();
                w = Math.max(dim.width, w);
                h += dim.height;
                has_visible_components = true;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim;
            Insets margin = parent.getInsets();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            int x = margin.left;
            int y = margin.top;
            int w = pw - (margin.left + margin.right);
            Component lastComponent = null;
            boolean has_visible_components = false;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!c.isVisible()) continue;
                if (has_visible_components) {
                    y += this.getSpacing();
                }
                dim = c.getPreferredSize();
                c.setBounds(x, y, w, dim.height);
                y += dim.height;
                has_visible_components = true;
                lastComponent = c;
            }
            if (this.isAutoFill() && lastComponent != null) {
                int bottomY = ph - margin.bottom;
                Rectangle rect = lastComponent.getBounds();
                if (rect.y + rect.height >= bottomY) {
                    return;
                }
                dim = lastComponent.getPreferredSize();
                int dh = bottomY - rect.y;
                if (dh < 0) {
                    dh = dim.height;
                }
                lastComponent.setBounds(rect.x, rect.y, rect.width, dh);
            }
        }
    }
}

