/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;

public class XLayout
implements LayoutManager {
    private int spacing = 2;
    private int alignment = 2;
    private boolean autoFill;

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public boolean isAutoFill() {
        return this.autoFill;
    }

    public void setAutoFill(boolean autoFill) {
        this.autoFill = autoFill;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            Component[] comps = this.getVisibleComponents(parent);
            for (int i = 0; i < comps.length; ++i) {
                if (i > 0) {
                    w += this.getSpacing();
                }
                Dimension dim = comps[i].getPreferredSize();
                h = Math.max(dim.height, h);
                w += dim.width;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            Component[] comps = this.getVisibleComponents(parent);
            for (int i = 0; i < comps.length; ++i) {
                if (i > 0) {
                    w += this.getSpacing();
                }
                Dimension dim = comps[i].getMinimumSize();
                h = Math.min(dim.height, h);
                w += dim.width;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }
    }

    private Component[] getVisibleComponents(Container parent) {
        ArrayList<Component> list = new ArrayList<Component>();
        Component[] comps = parent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].isVisible()) continue;
            list.add(comps[i]);
        }
        return list.toArray(new Component[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int alignment = this.getAlignment();
            if (alignment == 4) {
                this.layoutRight(parent);
            } else if (alignment == 0) {
                this.layoutCenter(parent);
            } else {
                this.layoutLeft(parent);
            }
        }
    }

    public void layoutLeft(Container parent) {
        Component[] comps = this.getVisibleComponents(parent);
        if (comps.length == 0) {
            return;
        }
        Insets margin = parent.getInsets();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int x = margin.left;
        int y = margin.top;
        int h = ph - (margin.top + margin.bottom);
        int spacing = this.getSpacing();
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0) {
                x += spacing;
            }
            Dimension dim = comps[i].getPreferredSize();
            comps[i].setBounds(x, y, dim.width, h);
            x += dim.width;
        }
    }

    public void layoutRight(Container parent) {
        Component[] comps = this.getVisibleComponents(parent);
        if (comps.length == 0) {
            return;
        }
        Insets margin = parent.getInsets();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int h = ph - (margin.top + margin.bottom);
        int x = pw - margin.right;
        int y = margin.top;
        int spacing = this.getSpacing();
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0 && spacing > 0) {
                x -= spacing;
            }
            int idx = comps.length - 1 - i;
            Dimension dim = comps[idx].getPreferredSize();
            comps[idx].setBounds(x - dim.width, y, dim.width, h);
            x -= dim.width;
        }
    }

    public void layoutCenter(Container parent) {
        Component[] comps = this.getVisibleComponents(parent);
        if (comps.length == 0) {
            return;
        }
        Insets margin = parent.getInsets();
        int pw = parent.getWidth();
        int ph = parent.getHeight();
        int h = ph - (margin.top + margin.bottom);
        int y = margin.top;
        int spacing = this.getSpacing();
        int totalWidth = this.getWidth(comps, spacing);
        if (totalWidth == 0) {
            return;
        }
        double dx = pw / 2 - totalWidth / 2;
        dx = dx - (double)Math.max(margin.right, 0) + (double)Math.max(margin.left, 0);
        int x = (int)dx;
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0 && spacing > 0) {
                x += spacing;
            }
            Dimension dim = comps[i].getPreferredSize();
            comps[i].setBounds(x, y, dim.width, h);
            x += dim.width;
        }
    }

    private int getWidth(Component[] comps, int spacing) {
        int width = 0;
        for (int i = 0; i < comps.length; ++i) {
            if (i > 0 && spacing > 0) {
                width += spacing;
            }
            Dimension dim = comps[i].getPreferredSize();
            width += dim.width;
        }
        return width;
    }
}

