/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SplitterLayout
implements LayoutManager {
    public static final String VW_SIDE = "sideview";
    public static final String VW_CONTENT = "contentview";
    private LayoutManager layout = new HorizontalLayout();
    private int dividerSize;
    private int dividerLocation;
    private int locationIndex;
    private Component vwside;
    private Component vwcontent;
    private Component divider;
    private Point sourcePoint;
    private Point targetPoint;
    private Rectangle viewRect;
    private HorizontalMouseSupport mouseSupport;

    public SplitterLayout() {
        this.setDividerLocation(100);
        this.setDividerSize(5);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        this.dividerSize = dividerSize;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.dividerLocation = dividerLocation;
        this.setLocationIndex(this.dividerLocation);
    }

    int getLocationIndex() {
        return this.locationIndex;
    }

    void setLocationIndex(int x) {
        this.locationIndex = x;
    }

    private Component getDivider() {
        if (this.divider == null) {
            JLabel lbl = new JLabel();
            lbl.setName("splitview.divider");
            lbl.setCursor(Cursor.getPredefinedCursor(10));
            this.mouseSupport = new HorizontalMouseSupport();
            this.mouseSupport.setDivider(lbl);
            this.divider = lbl;
        }
        return this.divider;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name != null && comp != null) {
            if (VW_SIDE.equals(name)) {
                this.vwside = comp;
            } else if (VW_CONTENT.equals(name)) {
                this.vwcontent = comp;
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp != null) {
            if (this.vwside != null && this.vwside.equals(comp)) {
                this.vwside = null;
            } else if (this.vwcontent != null && this.vwcontent.equals(comp)) {
                this.vwcontent = null;
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layout.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layout.minimumLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layout.layoutContainer(parent);
    }

    private class HorizontalLayout
    implements LayoutManager {
        SplitterLayout root;

        private HorizontalLayout() {
            this.root = SplitterLayout.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        public Dimension getLayoutSize(Container parent) {
            int w = SplitterLayout.this.getDividerSize();
            int h = SplitterLayout.this.getDividerSize();
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component divider = this.root.getDivider();
                parent.remove(divider);
                parent.add(divider);
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                SplitterLayout.this.viewRect = new Rectangle(x, y, w, h);
                int dividerSize = this.root.getDividerSize();
                int dividerMinPos = margin.left;
                int dividerMaxPos = pw - margin.right - dividerSize;
                int locationIndex = this.root.getLocationIndex();
                if (locationIndex <= dividerMinPos) {
                    locationIndex = dividerMinPos;
                } else if (locationIndex >= dividerMaxPos) {
                    locationIndex = dividerMaxPos;
                }
                int dw = locationIndex - x;
                if (dw > 0 && this.root.vwside != null) {
                    this.root.vwside.setBounds(x, y, dw, h);
                }
                divider.setBounds(locationIndex, y, dividerSize, h);
                dw = pw - margin.right - (locationIndex + dividerSize);
                if (dw > 0 && this.root.vwcontent != null) {
                    x = locationIndex + dividerSize;
                    this.root.vwcontent.setBounds(x, y, dw, h);
                }
            }
        }
    }

    private class HorizontalMouseSupport
    implements MouseListener,
    MouseMotionListener {
        SplitterLayout root;
        Component divider;
        private int prevLocationIndex;

        private HorizontalMouseSupport() {
            this.root = SplitterLayout.this;
        }

        void setDivider(Component divider) {
            this.divider = divider;
            divider.addMouseListener(this);
            divider.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HorizontalMouseSupport.this.toggleLeftView();
                    }
                });
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.root.sourcePoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Container parent;
            if (this.root.targetPoint != null) {
                Rectangle rect = this.divider.getBounds();
                int nx = rect.x + ((SplitterLayout)this.root).targetPoint.x;
                if (nx < 0) {
                    ((SplitterLayout)this.root).targetPoint.x = this.root.locationIndex * -1;
                }
                this.root.locationIndex = nx;
            }
            this.root.sourcePoint = null;
            this.root.targetPoint = null;
            if (e.getSource() instanceof Component && (parent = ((Component)e.getSource()).getParent()) instanceof Canvas) {
                Canvas canvas = (Canvas)((Object)parent);
                canvas.revalidate();
                canvas.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Container parent;
            this.root.targetPoint = e.getPoint();
            Rectangle divRect = this.divider.getBounds();
            int nx = divRect.x + ((SplitterLayout)this.root).targetPoint.x;
            if (nx < 10) {
                ((SplitterLayout)this.root).targetPoint.x = divRect.x * -1 + 10;
            } else {
                int w = ((SplitterLayout)this.root).viewRect.width - divRect.x;
                int limit = w - SplitterLayout.this.getDividerSize() - 10;
                if (((SplitterLayout)this.root).targetPoint.x > limit) {
                    ((SplitterLayout)this.root).targetPoint.x = limit;
                }
            }
            if (e.getSource() instanceof Component && (parent = ((Component)e.getSource()).getParent()) instanceof Canvas) {
                Canvas canvas = (Canvas)((Object)parent);
                canvas.paintDividerHandle(this.root.viewRect, divRect, this.root.targetPoint);
            }
        }

        private void toggleLeftView() {
        }
    }

    public static interface Canvas {
        public void paintDividerHandle(Rectangle var1, Rectangle var2, Point var3);

        public void revalidate();

        public void repaint();
    }
}

