/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.control.image.ThumbnailItem;
import com.rameses.rcp.control.image.ThumbnailListModel;
import com.rameses.rcp.control.layout.CenterLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThumbnailPanel
extends JPanel {
    private Dimension cellSize;
    private int cellSpacing;
    private int rowCount;
    private boolean singleRowOnly;
    private boolean singleColumnOnly;
    private JListImpl jlist;
    private JScrollPane jscroll;
    private Border cellBorder;
    private Color selectionBorderColor;
    private ThumbnailListModel model;
    private boolean updating_model;

    public ThumbnailPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.cellSpacing = 5;
        this.selectionBorderColor = Color.decode("#505050");
        this.jlist = new JListImpl();
        this.jlist.setSelectionMode(0);
        this.jlist.setCellRenderer(new ListCellRendererImpl());
        this.jlist.addListSelectionListener(new ListSelectionHandlerImpl());
        this.setCellSize(this.getDefaultCellSize());
        this.setRowCount(-1);
        this.jscroll = new JScrollPane(this.jlist);
        super.setLayout(new DefaultLayout());
        this.add(this.jscroll);
        if (Beans.isDesignTime()) {
            this.jlist.setModel(new DesignTimeListModel());
        }
    }

    @Override
    public void setLayout(LayoutManager layout) {
    }

    public ThumbnailListModel getModel() {
        return this.model;
    }

    public void setModel(ThumbnailListModel model) {
        this.model = model == null ? new ThumbnailListModel() : model;
        try {
            this.updating_model = true;
            this.jlist.setModel(this.model);
        }
        finally {
            this.updating_model = false;
        }
    }

    protected Dimension getDefaultCellSize() {
        return new Dimension(60, 60);
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
        this.adjustListComponent();
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
        this.adjustListComponent();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount < 0 ? -1 : rowCount;
        this.adjustListComponent();
    }

    public Color getSelectionBorderColor() {
        return this.selectionBorderColor;
    }

    public void setSelectionBorderColor(Color selectionBorderColor) {
        this.selectionBorderColor = selectionBorderColor;
    }

    public Border getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(Border cellBorder) {
        this.cellBorder = cellBorder;
    }

    public boolean isSingleRowOnly() {
        return this.singleRowOnly;
    }

    public void setSingleRowOnly(boolean singleRowOnly) {
        this.singleRowOnly = singleRowOnly;
        this.adjustListComponent();
    }

    public boolean isSingleColumnOnly() {
        return this.singleColumnOnly;
    }

    public void setSingleColumnOnly(boolean singleColumnOnly) {
        this.singleColumnOnly = singleColumnOnly;
        this.adjustListComponent();
    }

    public int getSelectedIndex() {
        return this.jlist.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        try {
            this.jlist.setSelectedIndex(index);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ThumbnailItem getSelectedItem() {
        Object o = this.jlist.getSelectedValue();
        if (o instanceof ThumbnailItem) {
            return (ThumbnailItem)o;
        }
        return null;
    }

    public void selectFirstItem() {
        try {
            this.jlist.setSelectedIndex(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void refresh() {
        this.jlist.revalidate();
        this.jlist.repaint();
    }

    public void moveNext() {
        int selindex = this.jlist.getSelectedIndex() + 1;
        if (selindex >= 0 && selindex < this.jlist.getModel().getSize()) {
            this.jlist.setSelectedIndex(selindex);
        }
    }

    public void movePrevious() {
        int selindex = this.jlist.getSelectedIndex() - 1;
        if (selindex >= 0 && selindex < this.jlist.getModel().getSize()) {
            this.jlist.setSelectedIndex(selindex);
        }
    }

    private Dimension getPreferredCellSize() {
        Dimension size = this.getCellSize();
        if (size == null) {
            size = this.getDefaultCellSize();
        }
        return new Dimension(size.width, size.height);
    }

    private void adjustListComponent() {
        int spacing = this.getCellSpacing();
        if (spacing <= 0) {
            spacing = 0;
        }
        Dimension dim = this.getPreferredCellSize();
        this.jlist.setFixedCellWidth(dim.width + spacing);
        this.jlist.setFixedCellHeight(dim.height + spacing);
        int rowcount = this.getRowCount();
        if (this.isSingleColumnOnly()) {
            this.jlist.setLayoutOrientation(0);
        } else if (this.isSingleRowOnly()) {
            this.jlist.setVisibleRowCount(1);
            this.jlist.setLayoutOrientation(2);
        } else if (rowcount <= 0) {
            this.jlist.setVisibleRowCount(-1);
            this.jlist.setLayoutOrientation(2);
        }
    }

    protected void selectionChanged() {
    }

    private class JListImpl
    extends JList {
        private JListImpl() {
        }
    }

    private class ItemLabel
    extends JLabel {
        ThumbnailPanel root;
        private ImageIcon icon;
        private boolean selected;
        private Border defaultBorder;
        private Border selectedBorder;

        ItemLabel() {
            this.root = ThumbnailPanel.this;
            this.defaultBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.selectedBorder = BorderFactory.createLineBorder(this.root.jlist.getSelectionBackground(), 1);
        }

        void setImage(ImageIcon icon) {
            this.icon = icon == null ? this.createEmptyImage() : icon;
        }

        private ImageIcon createEmptyImage() {
            Dimension dim = this.root.getPreferredCellSize();
            BufferedImage bi = new BufferedImage(dim.width, dim.height, 2);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.decode("#a0a0a0"));
            g.fillRect(0, 0, dim.width, dim.height);
            g.dispose();
            return new ImageIcon(bi);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.paintIconImpl(g);
            this.paintBorderImpl(g);
        }

        private void paintIconImpl(Graphics g) {
            if (this.icon != null) {
                Dimension resizedim = new Dimension(this.getWidth(), this.getHeight());
                Dimension origdim = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
                double scaleX = resizedim.getWidth() / origdim.getWidth();
                double scaleY = resizedim.getHeight() / origdim.getHeight();
                double scale = scaleY > scaleX ? scaleX : scaleY;
                int nw = (int)((double)origdim.width * scale);
                int nh = (int)((double)origdim.height * scale);
                int nx = (resizedim.width - nw) / 2;
                int ny = (resizedim.height - nh) / 2;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(this.icon.getImage(), nx, ny, nw, nh, null);
                g2.dispose();
            }
        }

        private void paintBorderImpl(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.selected) {
                this.selectedBorder.paintBorder(this, g2, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.defaultBorder.paintBorder(this, g2, 0, 0, this.getWidth(), this.getHeight());
            }
            g2.dispose();
        }
    }

    private class ListCellRendererImpl
    implements ListCellRenderer {
        ThumbnailPanel root;
        private JPanel panel;
        private ItemLabel label;
        private ImageIcon unknownIcon;

        ListCellRendererImpl() {
            this.root = ThumbnailPanel.this;
            this.label = new ItemLabel();
            this.panel = new JPanel();
            this.panel.setLayout(new CenterLayout());
            this.panel.setOpaque(false);
            this.panel.add(this.label);
            URL url = this.getClass().getResource("unknown.png");
            if (url != null) {
                this.unknownIcon = new ImageIcon(url);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ThumbnailItem item = null;
            item = value instanceof ThumbnailItem ? (ThumbnailItem)value : new ThumbnailItem();
            int spacing = this.root.getCellSpacing();
            if (spacing < 0) {
                spacing = 0;
            }
            this.panel.setBorder(BorderFactory.createEmptyBorder(spacing, spacing, 0, 0));
            ImageIcon icon = item.getIcon();
            if (icon == null) {
                icon = this.unknownIcon;
            }
            this.label.setOpaque(false);
            this.label.setPreferredSize(this.root.getPreferredCellSize());
            this.label.selected = isSelected;
            this.label.setImage(icon);
            return this.panel;
        }
    }

    private class ListSelectionHandlerImpl
    implements ListSelectionListener {
        ThumbnailPanel root;

        private ListSelectionHandlerImpl() {
            this.root = ThumbnailPanel.this;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.root.updating_model) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.root.selectionChanged();
        }
    }

    private class DesignTimeListModel
    extends ThumbnailListModel {
        DesignTimeListModel() {
            this.add(new HashMap());
            this.add(new HashMap());
            this.add(new HashMap());
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        ThumbnailPanel root;

        private DefaultLayout() {
            this.root = ThumbnailPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int w = margin.left + margin.right;
                int h = margin.top + margin.bottom;
                Dimension dim = this.root.getPreferredCellSize();
                return new Dimension(w + 100, h + 50);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                this.root.jscroll.setBounds(x, y, w, h);
            }
        }
    }
}

