/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.control.image.ImageView;
import com.rameses.rcp.control.image.ImageViewPanel;
import com.rameses.rcp.support.ImageIconSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageViewToolbar
extends JPanel
implements ImageView.Handler {
    private ImageViewPanel parent;
    private ImageView imageView;
    private JLabel label;
    private JSlider slider;
    private JButton btnFitWindow;
    private JButton btnFitActual;

    public ImageViewToolbar(ImageViewPanel parent) {
        this.parent = parent;
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.setOpaque(false);
        this.label = new JLabel("%");
        this.label.setForeground(Color.WHITE);
        this.add(this.label);
        this.add(Box.createHorizontalStrut(5));
        this.slider = new JSlider(6, 800);
        this.slider.setOpaque(false);
        this.slider.setToolTipText("Zoom");
        this.add(this.slider);
        this.btnFitWindow = new JButton();
        this.btnFitWindow.setOpaque(false);
        this.btnFitWindow.setBorderPainted(false);
        this.btnFitWindow.setMargin(new Insets(1, 3, 1, 3));
        this.btnFitWindow.setToolTipText("Fit to window");
        this.btnFitWindow.setIcon(this.getIcon("com/rameses/rcp/icons/fit-to-screen.png"));
        this.add(this.btnFitWindow);
        this.btnFitActual = new JButton("1:1");
        this.btnFitActual.setOpaque(false);
        this.btnFitActual.setBorderPainted(false);
        this.btnFitActual.setMargin(new Insets(1, 2, 1, 2));
        this.btnFitActual.setToolTipText("Actual size");
        this.add(this.btnFitActual);
        SliderHandler handler = new SliderHandler();
        this.slider.addMouseWheelListener(handler);
        this.slider.addMouseListener(handler);
        this.slider.addChangeListener(handler);
        this.btnFitWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewToolbar.this.fitToWindow();
            }
        });
        this.btnFitActual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewToolbar.this.fitToActualSize();
            }
        });
    }

    private ImageIcon getIcon(String name) {
        return ImageIconSupport.getInstance().getIcon(name);
    }

    public ImageView.Handler getImageViewHandler() {
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        AlphaComposite alpha = this.createAlphaComposite(0.2f);
        if (alpha == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(alpha);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
    }

    private AlphaComposite createAlphaComposite(float alpha) {
        try {
            return AlphaComposite.getInstance(3, alpha);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void fitToWindow() {
        if (this.imageView == null) {
            return;
        }
        this.imageView.fitToWindow();
    }

    private void fitToActualSize() {
        if (this.imageView == null) {
            return;
        }
        this.imageView.zoom(100);
    }

    @Override
    public void refresh(ImageView imageView) {
        this.imageView = imageView;
        double maxScale = this.slider.getMaximum();
        double newCurScale = imageView.getCurrentScale() * 100.0;
        double newMinScale = imageView.getMinScale() * 100.0;
        if (newMinScale < 0.0) {
            newMinScale = 0.0;
        }
        if (newCurScale < newMinScale) {
            newCurScale = newMinScale;
        }
        if (newCurScale > maxScale) {
            newCurScale = maxScale;
        }
        newMinScale = this.resolveValue(newMinScale);
        newCurScale = this.resolveValue(newCurScale);
        this.slider.setMinimum((int)this.resolveValue(newMinScale));
        this.slider.setValue((int)this.resolveValue(newCurScale));
    }

    private double resolveValue(double value) {
        return new BigDecimal(value).setScale(0, RoundingMode.HALF_UP).doubleValue();
    }

    private class SliderHandler
    implements ChangeListener,
    MouseListener,
    MouseWheelListener {
        ImageViewToolbar root;
        private boolean enableStateListener;

        private SliderHandler() {
            this.root = ImageViewToolbar.this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.enableStateListener = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.enableStateListener = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateDependencies();
            boolean allowed = this.enableStateListener;
            if (!allowed && this.root.slider.hasFocus()) {
                allowed = true;
            }
            if (!allowed || this.root.imageView == null) {
                return;
            }
            this.root.imageView.zoom(this.root.slider.getValue());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!this.enableStateListener) {
                return;
            }
            int value = this.root.slider.getValue();
            value = e.getWheelRotation() <= -1 ? (value += e.getScrollAmount()) : (value -= e.getScrollAmount());
            this.root.slider.setValue(value);
        }

        private void updateDependencies() {
            int value = this.root.slider.getValue();
            ImageIcon iicon = this.root.parent.getValue();
            StringBuffer sb = new StringBuffer();
            sb.append(" " + value + "%");
            if (iicon != null) {
                sb.append("  |  ");
                sb.append(iicon.getIconWidth());
                sb.append(" x ");
                sb.append(iicon.getIconHeight());
                sb.append(" px");
            }
            this.root.label.setText(sb.toString());
        }
    }

    private class DefaultLayout
    implements LayoutManager,
    LayoutManager2 {
        private DefaultLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int width = 0;
                int height = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    width += dim.width;
                    height = Math.max(dim.height, height);
                }
                Insets margin = parent.getInsets();
                return new Dimension(width += margin.left + margin.right, height += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width;
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }
}

