/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class XRoundBorder
extends AbstractBorder {
    private Color color;
    private int size;
    private boolean fill;

    public XRoundBorder() {
        this(Color.BLACK, 2);
    }

    public XRoundBorder(Color color, int size) {
        this(color, size, true);
    }

    public XRoundBorder(Color color, int size, boolean fill) {
        this.color = color;
        this.size = size;
        this.fill = fill;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color pcolor = this.getColor();
        int psize = this.getSize();
        if (pcolor == null || psize <= 0) {
            return;
        }
        boolean pfill = this.isFill();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(pcolor);
        if (pfill) {
            g2d.fillRoundRect(x, y, width - 1, height - 1, psize, psize);
        }
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int pad = this.size >= 0 ? this.size : 0;
        return this.getBorderInsets(c, new Insets(pad, pad, pad, pad));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int pad;
        int n = pad = this.size >= 0 ? this.size : 0;
        if (pad > 0) {
            insets.right = insets.bottom = pad / 2;
            insets.top = insets.bottom;
            insets.left = insets.bottom;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

