/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.WebBrowserModel;
import com.rameses.rcp.control.webbrowser.WebEditorKit;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class XWebBrowser
extends JEditorPane
implements UIControl,
ActiveControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean refreshed;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private WebBrowserModel model;
    private ControlProperty property;

    public XWebBrowser() {
        if (Beans.isDesignTime()) {
            this.setContentType("text/html");
        }
        super.setEditable(false);
        this.attachEventsListeners();
    }

    private void attachEventsListeners() {
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                XWebBrowser.this.processHyperlinkEvent(e);
            }
        });
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XWebBrowser.this.model != null) {
                    XWebBrowser.this.model.back();
                }
            }
        }, KeyStroke.getKeyStroke(8, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (XWebBrowser.this.model != null) {
                    XWebBrowser.this.model.forward();
                }
            }
        }, KeyStroke.getKeyStroke(8, 1), 0);
    }

    private void processHyperlinkEvent(HyperlinkEvent e) {
        HyperlinkEvent.EventType evt = e.getEventType();
        if (evt == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                String desc = e.getDescription();
                if (!ValueUtil.isEmpty((Object)desc)) {
                    if ((desc = desc.trim()).startsWith("#")) {
                        if (desc.length() > 1) {
                            this.model.setLocation(desc);
                        }
                    } else if (desc.startsWith("http") || desc.startsWith("www.")) {
                        this.model.setLocation(desc);
                    } else {
                        this.model.setRelativeLocation(desc);
                    }
                }
            }
            catch (Exception ex) {
                MsgBox.err(new IllegalStateException(ex));
            }
        }
    }

    @Override
    public void refresh() {
        if (!this.refreshed) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XWebBrowser.this.refreshContent();
                }
            });
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        this.model = (WebBrowserModel)UIControlUtil.getBeanValue(this);
        this.setEditorKit(new WebEditorKit(this.model.getCacheContext()));
        this.model.setListener(new WebBrowserModel.Listener(){

            @Override
            public void refresh() {
                XWebBrowser.this.refreshContent();
            }
        });
    }

    private void refreshContent() {
        try {
            if (ValueUtil.isEqual((Object)super.getPage(), (Object)this.model.getLocation())) {
                Document doc = this.getDocument();
                doc.putProperty("stream", null);
            }
            URL currentLoc = super.getPage();
            URL newLoc = this.model.getLocation();
            String extForm = newLoc.toExternalForm();
            int hashIdx = -1;
            hashIdx = extForm.indexOf("#");
            if (hashIdx != -1) {
                String[] ss = extForm.split("#");
                if (currentLoc != null && currentLoc.toExternalForm().split("#")[0].equals(ss[0])) {
                    super.scrollToReference(ss[1]);
                } else {
                    super.setPage(newLoc);
                }
            } else {
                super.setPage(newLoc);
            }
            this.binding.notifyDepends(this);
        }
        catch (Exception ex) {
            MsgBox.err(ex);
        }
        this.refreshed = true;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.setText(name);
        }
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }
}

