/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextPane;

public class XTextPane
extends JTextPane
implements UIInput,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean nullWhenEmpty;
    private boolean readonly;
    private ControlProperty property;
    private String fontStyle;
    private Font sourceFont;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public XTextPane() {
        this.initComponent();
    }

    private void initComponent() {
        this.setEditable(false);
        this.setNullWhenEmpty(true);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        try {
            this.setValue(UIControlUtil.getBeanValue(this.getBinding(), this.getName()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public Object getValue() {
        String text = this.getText();
        if (text == null) {
            return null;
        }
        if (text.length() == 0 && this.isNullWhenEmpty()) {
            return null;
        }
        return text;
    }

    @Override
    public void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        if (!this.isEnabled()) {
            return;
        }
        this.readonly = readonly;
        this.setEditable(!readonly);
        super.firePropertyChange("editable", readonly, !readonly);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        if (this.sourceFont == null) {
            this.sourceFont = super.getFont();
        } else {
            super.setFont(this.sourceFont);
        }
        new FontSupport().applyStyles((JComponent)this, fontStyle);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Comparable<Character>> map = new HashMap<String, Comparable<Character>>();
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("nullWhenEmpty", Boolean.valueOf(this.isNullWhenEmpty()));
        map.put("required", Boolean.valueOf(this.isRequired()));
        return map;
    }
}

