/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.TextDocumentModel;
import com.rameses.rcp.common.TextEditorModel;
import com.rameses.rcp.common.TextWriter;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.TextAreaImpl;
import com.rameses.rcp.framework.ActionHandler;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.UIControlInput;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.UITextComponent;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class XTextAreaPanel
extends UIControlInput
implements UITextComponent {
    private JScrollPane scrollpane;
    private TextAreaEditor editor;
    private ActionHandlerImpl actionHandler;
    private TextDocumentModel handlerObject;
    private TextEditorModel editorModel;
    private TextWriter textWriterObject;
    private String handler;
    private String itemExpression;
    private String varName = "item";
    private String actionCommand;
    private String focusKeyStroke;
    private KeyStroke focusKeyStrokeObject;

    @Override
    protected void initComponent() {
        super.initComponent();
        this.setPreferredSize(new Dimension(100, 30));
        this.actionHandler = new ActionHandlerImpl();
        this.editor = new TextAreaEditor();
        this.editor.putClientProperty(UIInput.class, this);
        this.scrollpane = new JScrollPane(this.editor);
        this.setView(this.scrollpane);
    }

    public boolean isLineWrap() {
        return this.editor.getLineWrap();
    }

    public void setLineWrap(boolean lineWrap) {
        this.editor.setLineWrap(lineWrap);
    }

    public boolean isWrapStyleWord() {
        return this.editor.getWrapStyleWord();
    }

    public void setWrapStyleWord(boolean wrapStyleWord) {
        this.editor.setWrapStyleWord(wrapStyleWord);
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    @Override
    public TrimSpaceOption getTrimSpaceOption() {
        return this.editor.getTrimSpaceOption();
    }

    @Override
    public void setTrimSpaceOption(TrimSpaceOption trimSpaceOption) {
        this.editor.setTrimSpaceOption(trimSpaceOption);
    }

    public boolean isAutoScrollDown() {
        return this.editor.isAutoScrollDown();
    }

    public void setAutoScrollDown(boolean autoScrollDown) {
        this.editor.setAutoScrollDown(autoScrollDown);
    }

    public boolean isExitOnTabKey() {
        return this.editor.isExitOnTabKey();
    }

    public void setExitOnTabKey(boolean exitOnTabKey) {
        this.editor.setExitOnTabKey(exitOnTabKey);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.editor.setText(name);
        }
    }

    @Override
    public TextCase getTextCase() {
        return this.editor.getTextCase();
    }

    @Override
    public void setTextCase(TextCase textCase) {
        this.editor.setTextCase(textCase);
    }

    @Override
    public String getHint() {
        return this.editor.getHint();
    }

    @Override
    public void setHint(String hint) {
        this.editor.setHint(hint);
    }

    public String getItemExpression() {
        return this.itemExpression;
    }

    public void setItemExpression(String itemExpression) {
        this.itemExpression = itemExpression;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Override
    public boolean isReadonly() {
        return this.editor.isReadonly();
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.editor.setReadonly(readonly);
    }

    @Override
    public void setBinding(Binding binding) {
        Binding old = this.getBinding();
        if (old != null) {
            old.getActionHandlerSupport().remove(this.actionHandler);
        }
        super.setBinding(binding);
        Binding newbind = this.getBinding();
        if (newbind != null) {
            newbind.getActionHandlerSupport().add(this.actionHandler);
        }
    }

    @Override
    public void load() {
        this.editor.load();
    }

    @Override
    public void refresh() {
        this.editor.refresh();
    }

    @Override
    public Object getValue() {
        String text;
        String string = text = this.textWriterObject == null ? this.editor.getText() : null;
        if (ValueUtil.isEmpty((Object)text) && this.isNullWhenEmpty()) {
            return null;
        }
        TrimSpaceOption opt = this.getTrimSpaceOption();
        if (opt != null) {
            text = opt.trim(text);
        }
        return text;
    }

    @Override
    public void setValue(Object value) {
        this.editor.setText(value == null ? "" : value.toString());
    }

    @Override
    protected void loadComponentInfo(Map info) {
        super.loadComponentInfo(info);
        info.put("handler", this.getHandler());
        info.put("itemExpression", this.getItemExpression());
        info.put("varName", this.getVarName());
        info.put("lineWrap", this.isLineWrap());
        info.put("wrapStyleWord", this.isWrapStyleWord());
    }

    @Override
    public void afterFontChanged() {
        super.afterFontChanged();
        if (this.editor != null) {
            Font font = this.getFont();
            this.editor.setFont(this.getFont());
        }
    }

    @Override
    public boolean isEditable() {
        return this.editor.isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editor.setEditable(editable);
    }

    @Override
    public Color getDisabledTextColor() {
        return this.editor.getDisabledTextColor();
    }

    @Override
    public void setDisabledTextColor(Color disabledTextColor) {
        this.editor.setDisabledTextColor(disabledTextColor);
    }

    @Override
    public Insets getMargin() {
        return this.editor.getMargin();
    }

    @Override
    public void setMargin(Insets margin) {
        this.editor.setMargin(margin);
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    @Override
    public char getFocusAccelerator() {
        return this.editor.getFocusAccelerator();
    }

    @Override
    public void setFocusAccelerator(char focusAccelerator) {
        this.editor.setFocusAccelerator(focusAccelerator);
    }

    @Override
    public String getFocusKeyStroke() {
        return this.focusKeyStroke;
    }

    @Override
    public void setFocusKeyStroke(String focusKeyStroke) {
        this.focusKeyStroke = focusKeyStroke;
        KeyStroke old = this.focusKeyStrokeObject;
        if (old != null) {
            this.unregisterKeyboardAction(old);
        }
        try {
            this.focusKeyStrokeObject = KeyStroke.getKeyStroke(this.focusKeyStroke);
        }
        catch (Throwable t) {
            this.focusKeyStrokeObject = null;
        }
        if (this.focusKeyStrokeObject != null) {
            this.registerKeyboardAction(new FocusKeyStrokeAction(), this.focusKeyStrokeObject, 2);
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return 2;
    }

    @Override
    public void setHorizontalAlignment(int horizontalAlignment) {
    }

    @Override
    public String getInputFormat() {
        return null;
    }

    @Override
    public void setInputFormat(String inputFormat) {
    }

    @Override
    public String getInputFormatErrorMsg() {
        return null;
    }

    @Override
    public void setInputFormatErrorMsg(String inputFormatErrorMsg) {
    }

    @Override
    public int getMaxLength() {
        return 0;
    }

    @Override
    public void setMaxLength(int length) {
    }

    @Override
    public char getSpaceChar() {
        return '\u0000';
    }

    @Override
    public void setSpaceChar(char spaceChar) {
    }

    private void _ui_load() {
        String shandler = this.getHandler();
        if (shandler != null) {
            Object obj = UIControlUtil.getBeanValue(this.getBinding(), shandler);
            this.editor.configureHandlerObject(obj);
            this.handlerObject = null;
            this.editorModel = null;
            this.textWriterObject = null;
            if (obj instanceof TextDocumentModel) {
                this.handlerObject = (TextDocumentModel)obj;
            }
            if (obj instanceof TextEditorModel) {
                this.editorModel = (TextEditorModel)obj;
            }
            if (obj instanceof TextWriter) {
                this.textWriterObject = (TextWriter)obj;
            }
        }
    }

    private void _ui_refresh() {
        int oldCaretPos;
        block9: {
            oldCaretPos = this.editor.getCaretPosition();
            try {
                this.editor.updateBackground();
                Object value = UIControlUtil.getBeanValue(this);
                if (this.textWriterObject != null) {
                    value = this.textWriterObject.getText();
                }
                this.setValue(value);
            }
            catch (Throwable e) {
                this.editor.setText("");
                if (!ClientContext.getCurrentContext().isDebugMode()) break block9;
                e.printStackTrace();
            }
        }
        try {
            this.editor.setCaretPosition(oldCaretPos);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.textWriterObject != null) {
            this.editor.setEditable(false);
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    private class FocusKeyStrokeAction
    implements ActionListener {
        final XTextAreaPanel root;

        private FocusKeyStrokeAction() {
            this.root = XTextAreaPanel.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.root.editor.isEnabled() && this.root.editor.isFocusable()) {
                this.root.editor.requestFocus();
            }
        }
    }

    private class ActionHandlerImpl
    implements ActionHandler {
        final XTextAreaPanel root;

        private ActionHandlerImpl() {
            this.root = XTextAreaPanel.this;
        }

        @Override
        public void onBeforeExecute() {
        }

        @Override
        public void onAfterExecute() {
            if (this.root.isReadonly() || !this.root.editor.isEnabled() || !this.root.editor.isEditable()) {
                return;
            }
            if (!this.root.editor.getTextDocument().isDirty()) {
                return;
            }
            UIInputUtil.updateBeanValue(this.root);
        }
    }

    private class TextAreaEditor
    extends TextAreaImpl {
        final XTextAreaPanel root;

        TextAreaEditor() {
            this.root = XTextAreaPanel.this;
            new MouseEventSupport(this, this.root).install();
            Insets old_margin = this.getMargin();
            if (old_margin == null) {
                old_margin = new Insets(0, 0, 0, 0);
            }
            this.setMargin(new Insets(5, 5, old_margin.bottom, old_margin.right));
        }

        @Override
        public void load() {
            super.load();
            this.root._ui_load();
        }

        @Override
        public void refresh() {
            super.refresh();
            this.root._ui_refresh();
        }

        @Override
        protected List fetchList(Map params) {
            return this.root.editorModel == null ? null : this.root.editorModel.fetchList(params);
        }

        Object createExpressionBean(Object item) {
            Object bean = this.root.getBindingBean();
            ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
            beanSupport.setItem(this.root.getVarName(), item);
            return beanSupport.createProxy();
        }

        @Override
        protected Object getFormattedText(Object item) {
            String expr = this.root.getItemExpression();
            if (expr == null || expr.length() == 0) {
                return item == null ? null : item.toString();
            }
            Object exprBean = this.createExpressionBean(item);
            return UIControlUtil.evaluateExpr(exprBean, expr);
        }

        @Override
        protected String getTemplate(Object item) {
            if (this.root.editorModel == null) {
                return null;
            }
            Object o = XTextAreaPanel.this.editorModel.getTemplate(item);
            return o == null ? null : o.toString();
        }
    }
}

