/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.constant.UIConstants;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.Beans;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class XSeparator
extends JComponent
implements UIControl,
ActiveControl,
UIConstants {
    private ControlProperty property = new ControlProperty();
    private String orientation = "HORIZONTAL";
    private String orientationHPosition = "CENTER";
    private String orientationVPosition = "CENTER";
    private Insets padding = new Insets(0, 0, 0, 0);
    private Color lineColor;
    private Color lineShadow;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public XSeparator() {
        this.setLayout(null);
        this.property.setShowCaption(false);
        this.lineColor = UIManager.getColor("Separator.foreground");
        this.lineShadow = UIManager.getColor("Separator.highlight");
        if (Beans.isDesignTime()) {
            this.setPreferredSize(new Dimension(20, 20));
        }
    }

    @Override
    public void setLayout(LayoutManager layout) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D g = (Graphics2D)graphics.create();
        Dimension d = this.getSize();
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int sx1 = 1;
        int sy1 = 1;
        int sx2 = 1;
        int sy2 = 1;
        if ("VERTICAL".equals(this.orientation)) {
            y1 = sy1 = this.padding.top;
            y2 = sy2 = d.height - 2 - this.padding.bottom;
            if ("RIGHT".equals(this.orientationVPosition)) {
                x1 = x2 = d.width - 2;
                sx1 = sx2 = d.width - 1;
            } else if ("CENTER".equals(this.orientationVPosition)) {
                x1 = x2 = (d.width - 2) / 2;
                sx1 = sx2 = x1 + 1;
            }
        } else {
            x1 = sx1 = this.padding.left;
            x2 = sx2 = d.width - 2 - this.padding.right;
            if ("BOTTOM".equals(this.orientationHPosition)) {
                y1 = y2 = d.height - 2;
                sy1 = sy2 = d.height - 1;
            } else if ("CENTER".equals(this.orientationHPosition)) {
                y1 = y2 = (d.height - 2) / 2;
                sy1 = sy2 = y1 + 1;
            }
        }
        g.setColor(this.lineColor);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(this.lineShadow);
        g.drawLine(sx1, sy1, sx2, sy2);
        g.dispose();
    }

    @Override
    public String[] getDepends() {
        return null;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void setBinding(Binding binding) {
    }

    @Override
    public Binding getBinding() {
        return null;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void load() {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getOrientationHPosition() {
        return this.orientationHPosition;
    }

    public void setOrientationHPosition(String orientationHPosition) {
        this.orientationHPosition = orientationHPosition;
    }

    public String getOrientationVPosition() {
        return this.orientationVPosition;
    }

    public void setOrientationVPosition(String orientationVPosition) {
        this.orientationVPosition = orientationVPosition;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding != null ? padding : new Insets(0, 0, 0, 0);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getLineShadow() {
        return this.lineShadow;
    }

    public void setLineShadow(Color lineShadow) {
        this.lineShadow = lineShadow;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }
}

