/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.platform.interfaces.Platform;
import com.rameses.rcp.common.DefaultCallbackHandler;
import com.rameses.rcp.common.LookupOpenerSupport;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.WindowUtil;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.DefaultTextField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.support.TextDocument;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.UIInputVerifier;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.PanelUI;
import javax.swing.text.Document;

public class XOpenerField
extends DefaultTextField
implements UIInput,
UIInputVerifier,
Validatable,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Dimension minimumSize = new Dimension(0, 0);
    private BorderImpl borderImpl;
    private ButtonImpl buttonImpl;
    private Insets margin;
    private boolean allowSelectAll;
    private ControlProperty property = new ControlProperty();
    private ActionMessage actionMessage = new ActionMessage();
    private Binding binding;
    private Object handlerObject;
    private String handler;
    private String expression;
    private String varName = "item";
    private String inputFormat;
    private String inputFormatErrorMsg;
    private String[] depends;
    private boolean nullWhenEmpty = true;
    private int index;
    private ApproveCallbackHandler callbackHandler = new ApproveCallbackHandler();
    private TrimSpaceOption trimSpaceOption;
    private TextDocument document;
    private Object oldValue;
    private Object value;
    private int stretchWidth;
    private int stretchHeight;

    public XOpenerField() {
        this.initComponents();
    }

    private void initComponents() {
        this.getButtonImpl();
        this.document = new TextDocument();
        super.setDocument(this.document);
        Dimension dim = this.getPreferredSize();
        this.minimumSize = new Dimension(50, dim.height);
        this.setPreferredSize(new Dimension(Math.max(dim.width, 100), dim.height));
        this.document.setTextCase(TextCase.UPPER);
        this.trimSpaceOption = TrimSpaceOption.NORMAL;
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XOpenerField.this.refresh();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
        new KeyboardAction().install();
    }

    private BorderImpl getBorderImpl() {
        if (this.borderImpl == null) {
            this.borderImpl = new BorderImpl();
        }
        return this.borderImpl;
    }

    private ButtonImpl getButtonImpl() {
        if (this.buttonImpl == null) {
            this.buttonImpl = new ButtonImpl();
            this.buttonImpl.setText("...");
            this.buttonImpl.setMargin(new Insets(0, 0, 0, 0));
            this.buttonImpl.setFocusable(false);
            this.add(this.buttonImpl);
        }
        return this.buttonImpl;
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    @Override
    public final void setDocument(Document document) {
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public final void setMargin(Insets margin) {
        if (margin == null) {
            margin = new Insets(0, 0, 0, 0);
        }
        this.margin = margin;
        int width = this.getButtonImpl().getPreferredSize().width + 2;
        Insets newMargin = new Insets(margin.top, margin.left, margin.bottom, margin.right);
        newMargin.right = Math.max(newMargin.right, width);
        super.setMargin(newMargin);
    }

    @Override
    public final void setBorder(Border border) {
        this.getButtonImpl();
        if (border == null) {
            border = BorderFactory.createEmptyBorder();
        }
        CompoundBorder compound = BorderFactory.createCompoundBorder(border, this.getBorderImpl());
        this.getBorderImpl().setSource(border);
        super.setBorder(compound);
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getInputFormatErrorMsg() {
        return this.inputFormatErrorMsg;
    }

    public void setInputFormatErrorMsg(String inputFormatErrorMsg) {
        this.inputFormatErrorMsg = inputFormatErrorMsg;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean readonly = this.isReadonly();
        this.setEditable(!readonly);
        this.getButtonImpl().setEnabled(!readonly);
    }

    public TextCase getTextCase() {
        return this.document.getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        this.document.setTextCase(textCase);
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption trimSpaceOption) {
        this.trimSpaceOption = trimSpaceOption;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.setText(name);
        }
    }

    public void setUI(PanelUI ui) {
        super.setUI(ui);
        if ("true".equals(this.getClientProperty(JTable.class) + "")) {
            this.setBorder(null);
        }
    }

    @Override
    protected InputVerifier getChildInputVerifier() {
        return UIInputUtil.VERIFIER;
    }

    @Override
    protected void onfocusGained(FocusEvent e) {
        if (!"false".equals(this.getClientProperty("allowSelectAll") + "") && this.allowSelectAll && this.callbackHandler.isReady()) {
            this.selectAll();
        }
        this.allowSelectAll = true;
    }

    @Override
    protected void onpropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if ("Window.close".equals(propertyName)) {
            this.callbackHandler.onPopupClosed();
        }
    }

    private void fireButtonClicked(ActionEvent e) {
        try {
            this.getInputVerifierProxy().setEnabled(false);
            this.allowSelectAll = false;
            this.onButtonClicked(e);
        }
        catch (Exception ex) {
            MsgBox.err(ex);
        }
        finally {
            this.getInputVerifierProxy().setEnabled(true);
        }
    }

    public void onButtonClicked(ActionEvent e) {
        this.processHandler();
    }

    protected Opener getOpener() {
        Object result = null;
        String handler = this.getHandler();
        if (!ValueUtil.isEmpty((Object)handler)) {
            if (handler.matches(".+:.+")) {
                result = LookupOpenerSupport.lookupOpener(handler, new HashMap());
            } else {
                Binding oBinding = (Binding)this.getClientProperty(Binding.class);
                if (oBinding == null) {
                    oBinding = this.getBinding();
                }
                result = UIControlUtil.getBeanValue(oBinding, handler);
            }
        } else if (this.handlerObject != null) {
            result = this.handlerObject;
        }
        return (Opener)result;
    }

    private void processHandler() {
        Platform platform;
        if (Beans.isDesignTime()) {
            return;
        }
        if (this.isReadonly()) {
            return;
        }
        Opener opener = this.getOpener();
        if (opener == null) {
            MsgBox.alert("No available opener handler specified");
            return;
        }
        UIController uic = (opener = ControlSupport.initOpener(opener, this.getBinding().getController())).getController();
        if (uic == null) {
            throw new IllegalStateException("'" + opener.getName() + "' opener must have a controller");
        }
        try {
            UIControlUtil.setBeanValue(uic.getCodeBean(), "handler", (Object)this.callbackHandler);
        }
        catch (Exception ex) {
            System.out.println("Unable to set value for 'handler' property in " + uic.getCodeBean());
        }
        try {
            UIControlUtil.setBeanValue(uic.getCodeBean(), "value", this.getValue());
        }
        catch (Exception ex) {
            System.out.println("Unable to set value for 'value' property in " + uic.getCodeBean());
        }
        uic.setId(opener.getId());
        uic.setName(opener.getName());
        uic.setTitle(opener.getCaption());
        UIControllerContext uicontext = new UIControllerContext(uic);
        String ctxId = uicontext.getId();
        if (ctxId == null) {
            ctxId = this.getName() + this.handler;
        }
        if ((platform = ClientContext.getCurrentContext().getPlatform()).isWindowExists(ctxId)) {
            return;
        }
        UIControllerPanel uipanel = new UIControllerPanel(uicontext);
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            Map openerProps = opener.getProperties();
            props.putAll(WindowUtil.extractWindowAttrs(openerProps));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        props.put("id", ctxId);
        props.put("title", uicontext.getTitle());
        this.callbackHandler.setStatus(this.callbackHandler.READY);
        platform.showPopup(this, uipanel, props);
    }

    private void fireValueChanged() {
        Object newValue;
        block6: {
            newValue = null;
            try {
                this.updateBackground();
                String expr = this.getExpression();
                if (expr == null || this.value instanceof String) {
                    newValue = this.value;
                } else {
                    try {
                        newValue = UIControlUtil.evaluateExpr(this.createExpressionBean(), expr);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block6;
                ex.printStackTrace();
            }
        }
        this.document.loadValue(newValue);
    }

    private Object createExpressionBean() {
        ExprBeanSupport beanSupport = new ExprBeanSupport(this.getBinding().getBean());
        Object itemBean = this.value == null ? new HashMap() : this.value;
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    @Override
    public void registerKeyboardAction(ActionListener anAction, KeyStroke aKeyStroke, int aCondition) {
        super.registerKeyboardAction(anAction, aKeyStroke, aCondition);
        new KeyboardAction().install();
    }

    private void installKeyboardAction(ActionListener anAction, KeyStroke aKeyStroke, int aCondition) {
        super.registerKeyboardAction(anAction, aKeyStroke, aCondition);
    }

    @Override
    public Object getValue() {
        if (this.document.isDirty()) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                return this.isNullWhenEmpty() ? null : "";
            }
            return text;
        }
        if (this.value == null) {
            return this.isNullWhenEmpty() ? null : "";
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.callbackHandler.setStatus(this.callbackHandler.READY);
        if (value instanceof EventObject) {
            if (value instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)value;
                this.setText(ke.getKeyChar() + "");
                this.allowSelectAll = false;
            }
        } else {
            this.setText(value == null ? "" : value.toString());
        }
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.getButtonImpl().setEnabled(!readonly);
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        this.updateBackground();
        try {
            this.value = UIControlUtil.getBeanValue(this);
        }
        catch (Exception e) {
            this.value = null;
        }
        this.oldValue = this.value;
        this.fireValueChanged();
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
        if (info == null) {
            return;
        }
        PropertyInfoWrapper pi = new PropertyInfoWrapper(info);
        this.setExpression(pi.getExpression());
        Object handler = pi.getHandler();
        if (handler instanceof String) {
            this.setHandler(handler.toString());
            this.setHandlerObject(null);
        } else {
            this.setHandler(null);
            this.setHandlerObject(handler);
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handler", this.getHandler());
        map.put("handlerObject", this.getHandlerObject());
        map.put("expression", this.getExpression());
        map.put("varName", this.getVarName());
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("nullWhenEmpty", this.isNullWhenEmpty());
        map.put("required", this.isRequired());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public boolean verify(JComponent input) {
        if (this.callbackHandler.isCancelled()) {
            this.callbackHandler.setStatus(this.callbackHandler.READY);
        }
        this.updateStatus();
        return true;
    }

    private void updateStatus() {
        if (this.callbackHandler.isApproved() || this.document.isDirty()) {
            this.putClientProperty("updateBeanValue", true);
        } else {
            this.putClientProperty("updateBeanValue", false);
        }
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.property.setRequired(required);
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public void validateInput() {
        this.validateInput(this.getActionMessage());
    }

    public void validateInput(ActionMessage am) {
        String text;
        am.clearMessages();
        this.property.setErrorMessage(null);
        Object value = this.getValue();
        String string = text = value == null ? null : value.toString();
        if (ValueUtil.isEmpty((Object)text)) {
            if (this.isRequired()) {
                am.addMessage("1001", "{0} is required.", new Object[]{this.getCaption()});
            }
        } else if (!ValueUtil.isEmpty((Object)this.getInputFormat()) && !text.matches(this.getInputFormat())) {
            String msg = null;
            msg = this.inputFormatErrorMsg != null ? this.inputFormatErrorMsg : "Invalid input format for {0}";
            am.addMessage(null, msg, new Object[]{this.getCaption()});
        }
        if (am.hasMessages()) {
            this.property.setErrorMessage(am.toString());
        }
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char captionMnemonic) {
        this.property.setCaptionMnemonic(captionMnemonic);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int captionWidth) {
        this.property.setCaptionWidth(captionWidth);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    private class PropertyInfoWrapper {
        private PropertySupport.OpenerPropertyInfo property;
        private Map map = new HashMap();

        PropertyInfoWrapper(PropertySupport.PropertyInfo info) {
            if (info instanceof Map) {
                this.map = (Map)((Object)info);
            }
            if (info instanceof PropertySupport.OpenerPropertyInfo) {
                this.property = (PropertySupport.OpenerPropertyInfo)info;
            }
        }

        public String getExpression() {
            Object value = this.map.get("expression");
            if (value == null && this.property != null) {
                value = this.property.getExpression();
            }
            return value == null ? null : value.toString();
        }

        public Object getHandler() {
            Object value = this.map.get("handler");
            if (value == null && this.property != null) {
                value = this.property.getHandler();
            }
            return value;
        }
    }

    private class KeyboardAction
    implements ActionListener {
        XOpenerField root;
        private JComponent component;

        private KeyboardAction() {
            this.root = XOpenerField.this;
        }

        void install() {
            KeyStroke ks = KeyStroke.getKeyStroke(10, 0, false);
            this.root.unregisterKeyboardAction(ks);
            this.root.installKeyboardAction(this, ks, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XOpenerField.this.fireButtonClicked(e);
        }
    }

    private class ApproveCallbackHandler
    extends DefaultCallbackHandler {
        int READY = 1;
        int APPROVED = 2;
        int CANCELLED = 3;
        XOpenerField root = XOpenerField.this;
        private int status = this.READY;

        private ApproveCallbackHandler() {
        }

        boolean isReady() {
            return this.status == this.READY;
        }

        boolean isApproved() {
            return this.status == this.APPROVED;
        }

        boolean isCancelled() {
            return this.status == this.CANCELLED;
        }

        void setStatus(int status) {
            this.status = status;
        }

        void onPopupClosed() {
            if (!this.isApproved()) {
                this.setStatus(this.CANCELLED);
            }
        }

        @Override
        public Object call(Object[] args) {
            if (args == null || args.length == 0) {
                return null;
            }
            this.setStatus(this.APPROVED);
            this.root.value = args[0];
            this.root.fireValueChanged();
            return null;
        }
    }

    private class ButtonImpl
    extends JButton {
        XOpenerField root;

        private ButtonImpl() {
            this.root = XOpenerField.this;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            this.setCursor(Cursor.getDefaultCursor());
            if (!this.isEnabled()) {
                return;
            }
            if (e.getID() == 501) {
                this.root.getInputVerifierProxy().setEnabled(false);
            } else if (e.getID() == 502) {
                this.root.getInputVerifierProxy().setEnabled(true);
            }
            super.processMouseEvent(e);
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            this.root.fireButtonClicked(e);
            super.fireActionPerformed(e);
        }
    }

    private class BorderImpl
    extends AbstractBorder {
        XOpenerField root;
        private Border source;
        private Insets sourceMargin;

        private BorderImpl() {
            this.root = XOpenerField.this;
        }

        void setSource(Border source) {
            this.source = source;
            this.sourceMargin = null;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.sourceMargin == null && this.source != null) {
                this.sourceMargin = this.source.getBorderInsets(c);
            }
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (XOpenerField.this.buttonImpl.getParent() == null) {
                this.root.add(XOpenerField.this.buttonImpl);
            }
            Dimension dim = XOpenerField.this.buttonImpl.getPreferredSize();
            int nX = this.root.getWidth() - dim.width - 1;
            XOpenerField.this.buttonImpl.setBounds(nX, 1, dim.width, this.root.getHeight() - 2);
        }
    }
}

