/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.control.XTextField;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Beans;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class XNumberField
extends XTextField {
    private Class fieldType;
    private String pattern;
    private DecimalFormat formatter;
    private boolean immediate;
    NumberFieldSupport fieldSupport = new NumberFieldSupport();
    private static String NON_NUMBER = "[^\\-\\+\\d.eE]";

    public XNumberField() {
        this.setHorizontalAlignment(4);
        this.addKeyListener(this.fieldSupport);
        this.addFocusListener(this.fieldSupport);
    }

    @Override
    public void refresh() {
        block2: {
            try {
                this.updateBackground();
                this.showFormattedValue(true);
            }
            catch (Exception e) {
                this.setText("");
                if (!ClientContext.getCurrentContext().isDebugMode()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void load() {
        if (!this.immediate) {
            this.setInputVerifier(UIInputUtil.VERIFIER);
        } else {
            this.fieldSupport.setUpdateOnKeyRelease(true);
        }
        this.getFieldType();
    }

    private Object convertValue() {
        Class fType = this.getFieldType();
        String fieldText = this.getText().replaceAll(NON_NUMBER, "");
        if (fieldText.trim().length() == 0) {
            return fType != null && fType.isPrimitive() ? Integer.valueOf(0) : null;
        }
        try {
            if (fType == BigDecimal.class) {
                BigDecimal dc = new BigDecimal(fieldText);
                if (this.formatter != null) {
                    String txt = this.formatter.format(dc);
                    return new BigDecimal(txt.replaceAll(NON_NUMBER, ""));
                }
                return dc;
            }
            if (fType == Integer.class || fType == Integer.TYPE) {
                Integer in = new Integer(fieldText);
                if (this.formatter != null) {
                    String txt = this.formatter.format(in);
                    return new Integer(txt.replaceAll(NON_NUMBER, ""));
                }
                return in;
            }
            if (fType == Double.class || fType == Double.TYPE) {
                Double d = new Double(fieldText);
                if (this.formatter != null) {
                    String txt = this.formatter.format(d);
                    return new Double(txt.replaceAll(NON_NUMBER, ""));
                }
                return d;
            }
            if (fType == Long.class || fType == Long.TYPE) {
                Long l = new Long(fieldText);
                if (this.formatter != null) {
                    String txt = this.formatter.format(l);
                    return new Long(txt.replaceAll(NON_NUMBER, ""));
                }
                return l;
            }
        }
        catch (NumberFormatException nfe) {
            return fType != null && fType.isPrimitive() ? Integer.valueOf(0) : null;
        }
        return null;
    }

    private final void showFormattedValue(boolean formatted) {
        Object value = UIControlUtil.getBeanValue(this);
        if (formatted && this.formatter != null && value != null) {
            this.setValue(this.formatter.format(value));
        } else if (value == null) {
            this.setValue("");
        } else {
            this.setValue(value + "");
        }
    }

    @Override
    public Object getValue() {
        if (Beans.isDesignTime()) {
            return "";
        }
        return this.convertValue();
    }

    @Override
    public void setValue(Object value) {
        String text;
        if (value instanceof KeyEvent && (text = ((KeyEvent)value).getKeyChar() + "").matches("[^\\d|\\.]")) {
            return;
        }
        super.setValue(value);
    }

    private Class getFieldType() {
        if (this.fieldType == null) {
            Object value;
            this.fieldType = UIControlUtil.getValueType(this, this.getName());
            if (this.fieldType == null && (value = UIControlUtil.getBeanValue(this)) != null) {
                this.fieldType = value.getClass();
            }
            if (this.pattern == null || this.pattern.trim().length() == 0) {
                if (this.fieldType == BigDecimal.class || this.fieldType == Double.class || this.fieldType == Double.TYPE) {
                    this.setPattern("#,##0.00");
                } else {
                    this.setPattern("#,##0");
                }
            }
        }
        return this.fieldType;
    }

    public void setFieldType(Class fieldType) {
        this.fieldType = fieldType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.formatter = pattern != null && pattern.trim().length() > 0 ? new DecimalFormat(pattern) : null;
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    private class NumberFieldSupport
    implements KeyListener,
    FocusListener {
        private boolean updateOnKeyRelease;

        private NumberFieldSupport() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char k = e.getKeyChar();
            boolean acceptable = false;
            switch (k) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    acceptable = true;
                }
            }
            if (!acceptable) {
                e.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.updateOnKeyRelease) {
                UIInputUtil.updateBeanValue(XNumberField.this);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            XNumberField.this.showFormattedValue(false);
            XNumberField.this.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            XNumberField.this.showFormattedValue(true);
        }

        public void setUpdateOnKeyRelease(boolean updateOnKeyRelease) {
            this.updateOnKeyRelease = updateOnKeyRelease;
        }
    }
}

