/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.text.AbstractNumberDocument;
import com.rameses.rcp.control.text.AbstractNumberField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import javax.swing.InputVerifier;

public class XIntegerField
extends AbstractNumberField
implements UIInput,
Validatable,
ActiveControl,
MouseEventSupport.ComponentInfo {
    protected ControlProperty property = new ControlProperty();
    protected ActionMessage actionMessage = new ActionMessage();
    private Binding binding;
    private IntegerDocument model = new IntegerDocument();
    private boolean nullWhenEmpty;
    private String[] depends;
    private String pattern;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private ActionCommandInvoker actionCommandInvoker;

    public XIntegerField() {
        this.initComponent();
    }

    private void initComponent() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.actionCommandInvoker = new ActionCommandInvoker();
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XIntegerField.this.refresh();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
    }

    @Override
    protected AbstractNumberDocument createDocument() {
        if (this.model == null) {
            this.model = new IntegerDocument();
        }
        return this.model;
    }

    @Override
    protected void oncancelEditing() {
        try {
            this.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            super.setText(name);
        }
    }

    @Override
    public Object getValue() {
        Number num = this.getModel().getValue();
        if (num == null) {
            return this.isUsePrimitiveValue() ? Double.valueOf(0.0) : null;
        }
        return this.isUsePrimitiveValue() ? (Number)num.intValue() : (Number)num;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof KeyEvent) {
            KeyEvent e = (KeyEvent)value;
            char c = e.getKeyChar();
            if (Character.isDigit(c) || c == '.' || c == '-') {
                this.getModel().setValue(c + "");
            } else {
                this.setText("");
            }
        } else if (value instanceof Integer) {
            this.getModel().setValue((Integer)value);
        } else {
            this.getModel().setValue(value == null ? "" : value.toString());
        }
        this.revalidate();
        this.repaint();
    }

    public String getPattern() {
        return this.model.getFormat();
    }

    public void setPattern(String pattern) {
        this.model.setFormat(pattern);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
        if (info == null) {
            return;
        }
        PropertyInfoWrapper pi = new PropertyInfoWrapper(info);
        this.setPattern(pi.getFormat());
        this.setMinValue(pi.getMinValue());
        this.setMaxValue(pi.getMaxValue());
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void refresh() {
        block13: {
            try {
                this.updateBackground();
                String whenExpr = this.getVisibleWhen();
                if (whenExpr != null && whenExpr.length() > 0) {
                    boolean result = false;
                    try {
                        result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setVisible(result);
                }
                if ((whenExpr = this.getDisableWhen()) != null && whenExpr.length() > 0) {
                    boolean disabled = false;
                    try {
                        disabled = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setEnabled(!disabled);
                }
                Object value = UIControlUtil.getBeanValue(this);
                Number number = null;
                if (value != null) {
                    if (value instanceof Integer) {
                        number = (Integer)value;
                    } else {
                        try {
                            number = this.getModel().decode(value.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.getModel().setValue(number);
                this.getModel().refresh();
            }
            catch (Exception e) {
                this.setText("");
                if (!ClientContext.getCurrentContext().isDebugMode()) break block13;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected InputVerifier getChildInputVerifier() {
        return UIInputUtil.VERIFIER;
    }

    @Override
    public void load() {
        String cmd = this.getActionCommand();
        if (cmd != null && cmd.length() > 0) {
            this.removeActionMapping("ACTION_MAPPING_KEY_ENTER", this.actionCommandInvoker);
            this.addActionMapping("ACTION_MAPPING_KEY_ENTER", this.actionCommandInvoker);
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionCommand", this.getActionCommand());
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("minValue", this.getMinValue());
        map.put("maxValue", this.getMaxValue());
        map.put("pattern", this.getPattern());
        map.put("usePrimitiveValue", this.isUsePrimitiveValue());
        map.put("required", this.isRequired());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.property.setRequired(required);
    }

    @Override
    public void validateInput() {
        this.validateInput(this.actionMessage);
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        this.property.setErrorMessage(null);
        if (ValueUtil.isEmpty((Object)this.getText()) && this.isRequired()) {
            am.addMessage("1001", "{0} is required.", new Object[]{this.getCaption()});
        }
        if (am.hasMessages()) {
            this.property.setErrorMessage(am.toString());
        }
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    private class ActionCommandInvoker
    implements ActionListener {
        XIntegerField root;

        private ActionCommandInvoker() {
            this.root = XIntegerField.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String cmd = this.root.getActionCommand();
                if (cmd == null || cmd.length() == 0) {
                    return;
                }
                UIInputUtil.updateBeanValue(this.root);
                Object bean = this.root.getBinding().getBean();
                Object outcome = MethodResolver.getInstance().invoke(bean, cmd, new Object[0]);
                if (outcome instanceof Opener) {
                    this.root.getBinding().fireNavigation(outcome);
                }
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }

    private class PropertyInfoWrapper {
        private PropertySupport.IntegerPropertyInfo property;
        private Map map = new HashMap();

        PropertyInfoWrapper(PropertySupport.PropertyInfo info) {
            if (info instanceof Map) {
                this.map = (Map)((Object)info);
            }
            if (info instanceof PropertySupport.IntegerPropertyInfo) {
                this.property = (PropertySupport.IntegerPropertyInfo)info;
            }
        }

        public String getFormat() {
            Object value = this.map.get("format");
            if (value == null && this.property != null) {
                value = this.property.getFormat();
            }
            return value == null ? null : value.toString();
        }

        public int getMinValue() {
            Number num;
            Object value = this.map.get("minValue");
            if (value == null && this.property != null) {
                value = this.property.getMinValue();
            }
            return (num = this.convertNumber(value)) == null ? -1 : num.intValue();
        }

        public int getMaxValue() {
            Number num;
            Object value = this.map.get("maxValue");
            if (value == null && this.property != null) {
                value = this.property.getMaxValue();
            }
            return (num = this.convertNumber(value)) == null ? -1 : num.intValue();
        }

        private Number convertNumber(Object value) {
            if (value instanceof Number) {
                return (Number)value;
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class IntegerDocument
    extends AbstractNumberDocument {
        IntegerDocument() {
            this.setFormat(null);
        }

        @Override
        public Number decode(String value) {
            try {
                return new Integer(value);
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public Number convertValue(Number value) {
            return value;
        }

        @Override
        protected Number getPrimitiveValue(Number value) {
            return value;
        }

        @Override
        public void refresh() {
            XIntegerField.this.revalidate();
            XIntegerField.this.repaint();
        }
    }
}

