/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.border.CSSBorder;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class XImage
extends JLabel
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean dynamic;
    private Border sourceBorder;
    private Insets padding;
    private String iconResource;
    private String borderCSS;
    private boolean hideWhenNoIcon;
    private ImageIcon iconResourceObj;
    private ImageIcon imageIcon;
    private Dimension scaleSize;
    private int stretchWidth;
    private int stretchHeight;
    private boolean shrinkToFit;
    private String visibleWhen;
    private ControlProperty property;

    public XImage() {
        this.setPadding(null);
        this.setBorder((Border)null);
        new MouseEventSupport(this).install();
    }

    public boolean isShrinkToFit() {
        return this.shrinkToFit;
    }

    public void setShrinkToFit(boolean shrinkToFit) {
        this.shrinkToFit = shrinkToFit;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            super.setText(name == null ? "" : name);
        }
    }

    @Override
    public void setBorder(Border border) {
        BorderWrapper wrapper = new BorderWrapper(border, this.getPadding());
        super.setBorder(wrapper);
        this.sourceBorder = wrapper.getBorder();
    }

    public void setBorder(String uiresource) {
        try {
            Border border = UIManager.getLookAndFeelDefaults().getBorder(uiresource);
            if (border != null) {
                this.setBorder(border);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBorderCSS() {
        return this.borderCSS;
    }

    public void setBorderCSS(String borderCSS) {
        this.borderCSS = borderCSS;
        this.setBorder(CSSBorder.parse(borderCSS));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding == null ? new Insets(1, 3, 1, 1) : padding;
        this.setBorder(this.sourceBorder);
    }

    @Override
    public void setText(String text) {
        if (Beans.isDesignTime()) {
            super.setText(text);
        }
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
        this.iconResourceObj = this.getImageIcon();
        this.setIcon(this.scaleIcon(this.iconResourceObj));
        this.repaint();
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    private ImageIcon getImageIcon() {
        String iconRes = this.getIconResource();
        if (iconRes == null) {
            return null;
        }
        ImageIconSupport iis = ImageIconSupport.getInstance();
        if (this.isDynamic()) {
            iis.removeIcon(iconRes);
        }
        return iis.getIcon(iconRes);
    }

    public Dimension getScaleSize() {
        return this.scaleSize;
    }

    public void setScaleSize(Dimension scaleSize) {
        this.scaleSize = scaleSize;
        ImageIcon iicon = this.imageIcon == null ? this.iconResourceObj : this.imageIcon;
        this.setIcon(iicon);
        this.repaint();
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public boolean isHideWhenNoIcon() {
        return this.hideWhenNoIcon;
    }

    public void setHideWhenNoIcon(boolean hideWhenNoIcon) {
        this.hideWhenNoIcon = hideWhenNoIcon;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        try {
            ImageIcon iicon = null;
            String name = this.getName();
            if (name != null && name.length() > 0) {
                Object value = UIControlUtil.getBeanValue(this.getBinding(), name);
                if (value instanceof byte[]) {
                    iicon = new ImageIcon((byte[])value);
                } else if (value != null) {
                    iicon = ImageIconSupport.getInstance().getIcon(value.toString());
                }
            }
            this.imageIcon = iicon;
            this.setIcon(this.scaleIcon(this.imageIcon));
        }
        catch (Throwable t) {
            this.imageIcon = null;
        }
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
        if (this.isHideWhenNoIcon() && this.getIcon() == null) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
        this.repaint();
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("dynamic", this.isDynamic());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private ImageIcon scaleIcon(ImageIcon iicon) {
        double scaleX;
        if (iicon == null) {
            return null;
        }
        Dimension scaledim = null;
        scaledim = this.isShrinkToFit() ? new Dimension(this.getWidth(), this.getHeight()) : this.getScaleSize();
        if (scaledim == null) {
            scaledim = new Dimension(0, 0);
        }
        if (scaledim.width == 0 && scaledim.height == 0) {
            return iicon;
        }
        int iw = iicon.getIconWidth();
        int ih = iicon.getIconHeight();
        double scaleY = (double)scaledim.height / (double)ih;
        double scale = scaleY > (scaleX = (double)scaledim.width / (double)iw) ? scaleX : scaleY;
        int nw = (int)((double)iw * scale);
        int nh = (int)((double)ih * scale);
        BufferedImage bi = new BufferedImage(nw, nh, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(iicon.getImage(), 0, 0, nw, nh, null);
        g2.dispose();
        return new ImageIcon(bi);
    }

    private class BorderWrapper
    extends AbstractBorder {
        XImage root;
        private Border border;
        private Insets padding;

        BorderWrapper(Border border, Insets padding) {
            this.root = XImage.this;
            this.border = border instanceof BorderWrapper ? ((BorderWrapper)border).getBorder() : border;
            this.padding = this.copy(padding);
        }

        public Border getBorder() {
            return this.border;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets ins) {
            if (ins == null) {
                new Insets(0, 0, 0, 0);
            }
            ins.right = 0;
            ins.bottom = 0;
            ins.left = 0;
            ins.top = 0;
            if (this.border != null) {
                Insets ins0 = this.border.getBorderInsets(c);
                ins.top += ins0.top;
                ins.left += ins0.left;
                ins.bottom += ins0.bottom;
                ins.right += ins0.right;
            }
            ins.top += this.padding.top;
            ins.left += this.padding.left;
            ins.bottom += this.padding.bottom;
            ins.right += this.padding.right;
            return ins;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (this.border != null) {
                this.border.paintBorder(c, g, x, y, w, h);
            }
        }

        private Insets copy(Insets padding) {
            if (padding == null) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(padding.top, padding.left, padding.bottom, padding.right);
        }
    }
}

