/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.beans.Beans;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class XEditorPane
extends JEditorPane
implements UIInput,
ActiveControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean nullWhenEmpty = true;
    private boolean readonly;
    private String linkAction;
    private String baseUrl;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property = new ControlProperty();

    public XEditorPane() {
        this.setContentType("text/html");
        this.setReadonly(true);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                XEditorPane.this.processHyperlinkEvent(e);
            }
        });
        this.setMargin(new Insets(5, 5, 5, 5));
    }

    private void processHyperlinkEvent(HyperlinkEvent e) {
        HyperlinkEvent.EventType evt = e.getEventType();
        if (evt == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                String desc = e.getDescription();
                if (!ValueUtil.isEmpty((Object)desc)) {
                    String method = null;
                    Object[] param = null;
                    if (!ValueUtil.isEmpty((Object)this.linkAction)) {
                        method = this.linkAction;
                        param = new Object[]{desc};
                    } else {
                        String[] aa = desc.split("\\?");
                        method = aa[0];
                        if (aa.length > 1) {
                            param = new Object[]{aa[1]};
                        }
                    }
                    final Object outcome = ControlSupport.invoke(this.binding.getBean(), method, param);
                    if (outcome != null) {
                        if (outcome instanceof Boolean && !((Boolean)outcome).booleanValue()) {
                            return;
                        }
                        if (outcome.getClass() == Boolean.TYPE && !((Boolean)outcome).booleanValue()) {
                            return;
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ControlSupport.fireNavigation(XEditorPane.this, outcome);
                        }
                    });
                }
            }
            catch (Exception ex) {
                MsgBox.err(new IllegalStateException(ex));
            }
        }
    }

    @Override
    public void refresh() {
        block10: {
            try {
                Object value = UIControlUtil.getBeanValue(this);
                if (!ValueUtil.isEmpty((Object)this.baseUrl) && this.getDocument() instanceof HTMLDocument) {
                    try {
                        Object url = UIControlUtil.getBeanValue(this, this.baseUrl);
                        if (url instanceof URL) {
                            ((HTMLDocument)this.getDocument()).setBase((URL)url);
                        } else {
                            ((HTMLDocument)this.getDocument()).setBase(new URL(url.toString()));
                        }
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                }
                this.setValue(value);
                this.setCaretPosition(0);
            }
            catch (Throwable e) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block10;
                e.printStackTrace();
            }
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        this.setInputVerifier(UIInputUtil.VERIFIER);
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.setText(name);
        }
    }

    @Override
    public Object getValue() {
        String txtValue = this.getText();
        if (ValueUtil.isEmpty((Object)txtValue) && this.nullWhenEmpty) {
            return null;
        }
        return txtValue;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public void setEditable(boolean editable) {
        this.setReadonly(!editable);
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        super.setEditable(!readonly);
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    public String getLinkAction() {
        return this.linkAction;
    }

    public void setLinkAction(String linkAction) {
        this.linkAction = linkAction;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }
}

