/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.DataListModel;
import com.rameses.rcp.common.EditorListModel;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.ListItemStatus;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.PropertyChangeHandler;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TableModelHandler;
import com.rameses.rcp.control.table.CellRenderers;
import com.rameses.rcp.control.table.DataTableComponent;
import com.rameses.rcp.control.table.DataTableModel;
import com.rameses.rcp.control.table.ListScrollBar;
import com.rameses.rcp.control.table.RowHeaderView;
import com.rameses.rcp.control.table.SelectionHandler;
import com.rameses.rcp.control.table.TableBorders;
import com.rameses.rcp.control.table.TableUtil;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIComplex;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;

public class XDataTable
extends JPanel
implements UIInput,
UIComplex,
Validatable,
FocusListener,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private DataTableComponentImpl table;
    private ListScrollBar scrollBar;
    private RowHeaderView rowHeaderView;
    private JScrollPane scrollPane;
    private PropertyChangeHandlerImpl propertyHandler;
    private AbstractListDataProvider dataProvider;
    private TableModelHandler tableModelHandler;
    private ActionMessage actionMessage = new ActionMessage();
    private Binding binding;
    private Column[] columns;
    private String[] depends;
    private String items;
    private String handler;
    private String id;
    private String readonlyWhen;
    private int index;
    private boolean dynamic;
    private boolean showRowHeader;
    private boolean showColumnHeader;
    private boolean immediate;
    private boolean editable;
    private ListItem currentItem;
    private RowChangeNotifier rowChangeNotifier;
    private ListModelLoader loader;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private Color borderColor;
    private String multiSelectFieldName;
    private ControlProperty property = new ControlProperty();
    private boolean _user_set_showrowheader;
    private boolean refreshed;
    private boolean hasLoaded;
    private FontSupport fontSupport;
    private Font sourceFont;
    private String fontStyle;

    public XDataTable() {
        this.init();
        if (!Beans.isDesignTime()) {
            this.rowChangeNotifier = new RowChangeNotifier();
            this.loader = new ListModelLoader();
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.table.addMouseListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.table.removeMouseListener(l);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.table.addKeyListener(l);
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.table.removeKeyListener(l);
    }

    private void init() {
        Color fg;
        Color bg;
        this.property = new ControlProperty();
        this.propertyHandler = new PropertyChangeHandlerImpl();
        this.tableModelHandler = new TableModelHandlerImpl();
        this.showColumnHeader = true;
        this.table = new DataTableComponentImpl();
        this.scrollBar = new ListScrollBar();
        this.borderColor = TableBorders.BORDER_COLOR;
        this.scrollPane = new JScrollPane(this.table);
        TableUtil.customize(this.scrollPane, this.table);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewport(new ViewportImpl(this.table));
        this.table.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (XDataTable.this.dataProvider.isProcessing()) {
                    return;
                }
                if (XDataTable.this.table.isProcessingRequest()) {
                    return;
                }
                int rotation = e.getWheelRotation();
                if (rotation == 0) {
                    return;
                }
                if (rotation < 0) {
                    XDataTable.this.dataProvider.moveBackRecord();
                } else {
                    XDataTable.this.dataProvider.moveNextRecord(true);
                }
                int scrollPolicy = XDataTable.this.scrollPane.getVerticalScrollBarPolicy();
                try {
                    int selRow = XDataTable.this.table.getSelectedRow();
                    int selCol = XDataTable.this.table.getSelectedColumn();
                    Rectangle rect = XDataTable.this.table.getCellRect(selRow, selCol, true);
                    if (scrollPolicy == 20) {
                        XDataTable.this.table.scrollRectToVisible(rect);
                    } else {
                        XDataTable.this.scrollBar.adjustValues();
                        XDataTable.this.table.scrollRectToVisible(rect);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        super.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)new ScrollBarPanel(this.scrollBar), "East");
        this.setBorder(new TableBorders.DefaultBorder());
        this.setCellSpacing(new Dimension(0, 0));
        this.setGridColor(new Color(235, 240, 244));
        this.setOddBackground(new Color(235, 240, 244));
        this.setEvenBackground(new Color(251, 251, 251));
        this.setShowRowHeaderImpl(true);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setAutoResize(true);
        this.setRowMargin(0);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int prefRowHeight = ((Number)((double)fm.getHeight() * 1.4)).intValue();
        this.setRowHeight(prefRowHeight);
        this.setRowHeaderHeight(this.getRowHeight() + 2);
        if (this.table.getEvenBackground() == null) {
            bg = (Color)UIManager.get("Table.evenBackground");
            if (bg == null) {
                bg = this.table.getBackground();
            }
            this.table.setEvenBackground(bg);
        }
        if (this.table.getEvenForeground() == null && (fg = (Color)UIManager.get("Table.evenForeground")) != null) {
            this.table.setEvenForeground(fg);
        }
        if (this.table.getOddBackground() == null) {
            bg = (Color)UIManager.get("Table.oddBackground");
            if (bg == null) {
                bg = new Color(225, 232, 246);
            }
            this.table.setOddBackground(bg);
        }
        if (this.table.getOddForeground() == null && (fg = (Color)UIManager.get("Table.oddForeground")) != null) {
            this.table.setOddForeground(fg);
        }
        new MouseEventSupport(this).install();
        if (Beans.isDesignTime()) {
            if (this.rowHeaderView != null) {
                this.rowHeaderView.setRowCount(1);
            }
            this.setPreferredSize(new Dimension(200, 80));
            this.table.setDataProvider(new DesignTimeListModel());
        }
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    @Override
    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.getControlProperty().setIndex(index);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void refresh() {
        if (this.isEnabled()) {
            this.setReadonly(this.isReadonly());
        }
        this.applyExpressions();
        if (this.dataProvider != null) {
            boolean empty;
            boolean bl = empty = this.dataProvider.getDataListSize() == 0;
            if (!this.refreshed && !empty) {
                EventQueue.invokeLater(this.loader.refresh());
            } else if (!this.refreshed || this.dynamic) {
                EventQueue.invokeLater(this.loader.load());
            } else {
                EventQueue.invokeLater(this.loader.refresh());
            }
        }
        this.refreshed = true;
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        if (this.hasLoaded) {
            return;
        }
        this.applyExpressions();
        this.refreshed = false;
        AbstractListDataProvider newProvider = null;
        if (this.handler != null) {
            Object oHandler = UIControlUtil.getBeanValue(this, this.handler);
            if (oHandler instanceof AbstractListDataProvider) {
                newProvider = (AbstractListDataProvider)oHandler;
            } else {
                System.out.println("[WARN] '" + this.handler + "' list model is null");
                newProvider = new ReadonlyListModel(null);
            }
        }
        if (newProvider == null && this.getItems() != null) {
            newProvider = this.isEditable() ? new EditableListModel(this.getItems()) : new ReadonlyListModel(this.getItems());
        }
        if (newProvider != null) {
            if (this.getColumns() != null) {
                newProvider.setColumns(this.getColumns());
            }
            if (!this._user_set_showrowheader) {
                if (newProvider instanceof EditorListModel) {
                    this.setShowRowHeader(true);
                } else {
                    this.setShowRowHeader(false);
                }
            }
            this.dataProvider = newProvider;
            this.table.setBinding(this.binding);
            this.table.setDataProvider(this.dataProvider);
            this.scrollBar.setDataProvider(this.dataProvider);
            if (this.rowHeaderView != null) {
                this.table.getModel().removeTableModelListener(this.rowHeaderView);
                this.rowHeaderView.setRowCount(this.dataProvider.getRows());
                this.table.getModel().addTableModelListener(this.rowHeaderView);
            }
        }
        this.hasLoaded = true;
    }

    @Override
    public Object getValue() {
        if (Beans.isDesignTime()) {
            return null;
        }
        if (this.dataProvider == null || this.dataProvider.getSelectedItem() == null) {
            return null;
        }
        return this.dataProvider.getSelectedItem().getItem();
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public boolean isNullWhenEmpty() {
        return true;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("handler", this.getHandler());
        map.put("immediate", this.isImmediate());
        map.put("items", this.getItems());
        map.put("id", this.getId());
        map.put("varName", this.getVarName());
        map.put("varStatus", this.getVarStatus());
        map.put("multiSelectName", this.getMultiSelectName());
        map.put("readonlyWhen", this.getReadonlyWhen());
        map.put("required", this.isRequired());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    private void applyExpressions() {
        String expr = this.getReadonlyWhen();
        if (expr != null && expr.length() > 0) {
            try {
                boolean b = UIControlUtil.evaluateExprBoolean(this.getBinding().getBean(), expr);
                this.setReadonly(b);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.table.setId(id);
    }

    public void cancelRowEdit() {
        if (this.rowHeaderView != null) {
            this.rowHeaderView.clearEditing();
        }
    }

    protected void log(String msg) {
        String name = this.getClass().getSimpleName();
        System.out.println("[" + name + "] " + msg);
    }

    public String getVarName() {
        return this.table == null ? null : this.table.getVarName();
    }

    public void setVarName(String varName) {
        this.table.setVarName(varName);
    }

    public String getVarStatus() {
        return this.table == null ? null : this.table.getVarStatus();
    }

    public void setVarStatus(String varStatus) {
        this.table.setVarStatus(varStatus);
    }

    public String getMultiSelectName() {
        return this.table == null ? null : this.table.getMultiSelectName();
    }

    public void setMultiSelectName(String multiSelectName) {
        this.table.setMultiSelectName(multiSelectName);
    }

    @Override
    public boolean isRequired() {
        return this.table.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
    }

    @Override
    public void validateInput() {
        this.validateInput(this.actionMessage);
    }

    public void validateInput(ActionMessage am) {
        if (this.dataProvider == null) {
            return;
        }
        am.clearMessages();
        String errmsg = this.dataProvider.getMessageSupport().getErrorMessages();
        if (errmsg == null) {
            ListItem li = this.dataProvider.getSelectedItem();
            if (li == null) {
                return;
            }
            int state = li.getState();
            if (state == 2 || state == 3) {
                errmsg = "There are changes on your data table. Please commit or revert it first.";
                this.dataProvider.getMessageSupport().addErrorMessage(li.getIndex(), errmsg);
                am.addMessage(null, errmsg, null);
                this.dataProvider.refreshSelectedItem();
            }
        } else {
            StringBuffer buffer = new StringBuffer(errmsg);
            String caption = this.getCaption();
            if (!ValueUtil.isEmpty((Object)caption)) {
                buffer.insert(0, caption + " (\n").append("\n)");
            }
            am.addMessage(null, buffer.toString(), null);
        }
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public boolean isReadonly() {
        return this.table.isReadonly();
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.table.setReadonly(readonly);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.table != null) {
            this.table.setName(name);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
        if (Beans.isDesignTime()) {
            try {
                ReadonlyListModel lm = new ReadonlyListModel(null);
                lm.setColumns(columns);
                this.table.setDataProvider(lm);
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
        if (this.getId() == null) {
            this.setId(this.items);
        }
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
        if (this.getId() == null) {
            this.setId(this.handler);
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isShowHorizontalLines() {
        return this.table.getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean show) {
        this.table.setShowHorizontalLines(show);
    }

    public boolean isShowVerticalLines() {
        return this.table.getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean show) {
        this.table.setShowVerticalLines(show);
    }

    public boolean isAutoResize() {
        return this.table.isAutoResize();
    }

    public void setAutoResize(boolean autoResize) {
        this.table.setAutoResize(autoResize);
    }

    public Dimension getCellSpacing() {
        return this.table.getIntercellSpacing();
    }

    public void setCellSpacing(Dimension cellSpacing) {
        this.table.setIntercellSpacing(cellSpacing);
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.table.requestFocus();
        }
    }

    @Override
    public void requestFocus() {
        this.table.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.table.grabFocus();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public Color getEvenBackground() {
        return this.table.getEvenBackground();
    }

    public void setEvenBackground(Color evenBackground) {
        this.table.setEvenBackground(evenBackground);
    }

    public Color getOddBackground() {
        return this.table.getOddBackground();
    }

    public void setOddBackground(Color oddBackground) {
        this.table.setOddBackground(oddBackground);
    }

    public Color getErrorBackground() {
        return this.table.getErrorBackground();
    }

    public void setErrorBackground(Color errorBackground) {
        this.table.setErrorBackground(errorBackground);
    }

    public Color getEvenForeground() {
        return this.table.getEvenForeground();
    }

    public void setEvenForeground(Color evenForeground) {
        this.table.setEvenForeground(evenForeground);
    }

    public Color getOddForeground() {
        return this.table.getOddForeground();
    }

    public void setOddForeground(Color oddForeground) {
        this.table.setOddForeground(oddForeground);
    }

    public Color getErrorForeground() {
        return this.table.getErrorForeground();
    }

    public void setErrorForeground(Color errorForeground) {
        this.table.setErrorForeground(errorForeground);
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public boolean isShowColumnHeader() {
        return this.showColumnHeader;
    }

    public void setShowColumnHeader(boolean showColumnHeader) {
        if (this.table == null) {
            return;
        }
        this.showColumnHeader = showColumnHeader;
        if (this.showColumnHeader) {
            this.table.attachTableHeader();
        } else {
            this.table.setTableHeader(null);
        }
    }

    public boolean isShowRowHeader() {
        return this.showRowHeader;
    }

    public void setShowRowHeader(boolean showRowHeader) {
        this.setShowRowHeaderImpl(showRowHeader);
        this._user_set_showrowheader = true;
    }

    private void setShowRowHeaderImpl(boolean show) {
        this.showRowHeader = show;
        if (show) {
            CellRenderers.HeaderRenderer corner = new CellRenderers.HeaderRenderer(true);
            corner.putClientProperty("Component.proxy", this.table);
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", corner);
            this.rowHeaderView = new RowHeaderView(this.table);
            this.scrollPane.setRowHeaderView(this.rowHeaderView);
            this.rowHeaderView.setRowCount(this.table.getRowCount());
        } else {
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", null);
            this.rowHeaderView = null;
            this.scrollPane.setRowHeaderView(null);
        }
    }

    public int getColumnMargin() {
        return this.table.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int margin) {
        this.table.getColumnModel().setColumnMargin(margin);
    }

    public int getRowMargin() {
        return this.table.getRowMargin();
    }

    public void setRowMargin(int margin) {
        this.table.setRowMargin(margin);
    }

    public Color getGridColor() {
        return this.table.getGridColor();
    }

    public void setGridColor(Color color) {
        this.table.setGridColor(color);
    }

    @Override
    public boolean isEnabled() {
        return this.table.isEnabled();
    }

    @Override
    public void setEnabled(boolean e) {
        this.table.setEnabled(e);
        this.scrollBar.setEnabled(e);
        this.scrollPane.setEnabled(e);
    }

    public int getRowHeight() {
        return this.table.getRowHeight();
    }

    public void setRowHeight(int h) {
        this.table.setRowHeight(h);
    }

    public int getRowHeaderHeight() {
        return this.table.getRowHeaderHeight();
    }

    public void setRowHeaderHeight(int h) {
        this.table.setRowHeaderHeight(h);
    }

    public boolean isScrollbarAlwaysVisible() {
        return this.scrollBar.isVisibleAlways();
    }

    public void setScrollbarAlwaysVisible(boolean scrollbarAlwaysVisible) {
        this.scrollBar.setVisibleAlways(scrollbarAlwaysVisible);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getReadonlyWhen() {
        return this.readonlyWhen;
    }

    public void setReadonlyWhen(String readonlyWhen) {
        this.readonlyWhen = readonlyWhen;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.putClientProperty("Border.color", borderColor);
        if (this.table != null) {
            this.table.putClientProperty("Border.color", borderColor);
        }
        this.repaint();
    }

    public String getMultiSelectFieldName() {
        return this.multiSelectFieldName;
    }

    public void setMultiSelectFieldName(String multiSelectFieldName) {
        this.multiSelectFieldName = multiSelectFieldName;
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        if (this.sourceFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            this.sourceFont = this.getFontSupport().applyStyles(this.sourceFont, attrs);
        }
        super.setFont(this.sourceFont);
        if (this.table != null) {
            this.table.setFont(font);
        }
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        Font font;
        this.fontStyle = fontStyle;
        if (this.sourceFont == null) {
            this.sourceFont = super.getFont();
        }
        if ((font = this.sourceFont) == null) {
            return;
        }
        Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
        font = this.getFontSupport().applyStyles(font, attrs);
        super.setFont(font);
        if (this.table != null) {
            this.table.setFont(font);
        }
    }

    private SelectionHandler getSelectionHandler() {
        Object o = this.getClientProperty(SelectionHandler.class);
        if (o instanceof SelectionHandler) {
            return (SelectionHandler)o;
        }
        return null;
    }

    private class ViewportImpl
    extends JViewport {
        XDataTable root;
        private Color defaultBgcolor;
        private Color bgcolor;
        private Rectangle oldBounds;

        ViewportImpl(Component view) {
            this.root = XDataTable.this;
            this.defaultBgcolor = SystemColor.control;
            this.bgcolor = Color.WHITE;
            this.oldBounds = new Rectangle();
            super.setBackground(this.bgcolor);
            super.setOpaque(true);
            super.setView(view);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    Rectangle rect = ViewportImpl.this.getBounds();
                    if (rect.height == ((ViewportImpl)ViewportImpl.this).oldBounds.height) {
                        return;
                    }
                    ViewportImpl.this.oldBounds = rect;
                    boolean dynamic = ViewportImpl.this.root.scrollBar.isDynamicallyVisible();
                    if (rect.height < ((XDataTable)ViewportImpl.this.root).table.getBounds().height && !dynamic) {
                        XDataTable.this.scrollPane.setVerticalScrollBarPolicy(20);
                    } else {
                        XDataTable.this.scrollPane.setVerticalScrollBarPolicy(21);
                    }
                }
            });
        }

        @Override
        public void setBackground(Color bg) {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color newColor = ColorUtil.brighter(this.defaultBgcolor.darker(), 20);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(newColor);
            g2.drawLine(0, 0, 0, this.getHeight());
            g2.dispose();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets margin = this.getInsets();
            if (margin == null) {
                margin = new Insets(0, 0, 0, 0);
            }
            int pw = this.getWidth();
            int ph = this.getHeight();
            int x = margin.left;
            int w = pw - (margin.left + margin.right);
            int h = ph - (margin.top + margin.bottom);
            int maxy = ph - margin.bottom;
            int rowh = this.root.table.getRowHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            int rownum = 0;
            for (int y = margin.top; y < maxy; y += rowh) {
                int test = rownum % 2;
                if (test == 0) {
                    g2.setColor(this.root.getOddBackground());
                } else {
                    g2.setColor(this.root.getEvenBackground());
                }
                g2.fillRect(x, y, w, rowh);
                ++rownum;
            }
            g2.dispose();
        }
    }

    private class TableModelHandlerImpl
    implements TableModelHandler {
        XDataTable root;

        private TableModelHandlerImpl() {
            this.root = XDataTable.this;
        }

        @Override
        public void fireTableDataChanged() {
            this.root.scrollBar.adjustValues();
        }

        @Override
        public void fireTableDataProviderChanged() {
            this.root.table.setDataProvider(this.root.dataProvider);
        }

        @Override
        public void fireTableStructureChanged() {
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }

        @Override
        public void fireTableRowsDeleted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsInserted(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableRowSelected(int row, boolean focusOnItemDataOnly) {
        }
    }

    private class PropertyChangeHandlerImpl
    implements PropertyChangeHandler {
        XDataTable root;

        private PropertyChangeHandlerImpl() {
            this.root = XDataTable.this;
        }

        @Override
        public void firePropertyChange(String name, int value) {
        }

        @Override
        public void firePropertyChange(String name, boolean value) {
            if ("loading".equals(name)) {
                this.root.scrollBar.setEnabled(!value);
            }
        }

        @Override
        public void firePropertyChange(String name, String value) {
        }

        @Override
        public void firePropertyChange(String name, Object value) {
            if ("selectedItemChanged".equals(name)) {
                this.root.table.onrowChanged();
            }
        }
    }

    private class DataTableComponentImpl
    extends DataTableComponent {
        XDataTable root;
        PropertyChangeListener propertyHandler;

        private DataTableComponentImpl() {
            this.root = XDataTable.this;
            this.propertyHandler = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    DataTableComponentImpl.this.onPropertyChange(e);
                }
            };
        }

        protected void onPropertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if ("checkedItemsChanged".equals(propName)) {
                if (!XDataTable.this.dataProvider.isMultiSelect()) {
                    return;
                }
                String multiName = this.getMultiSelectName();
                if (multiName == null) {
                    XDataTable.this.table.getDataTableModel();
                    multiName = "listHandler.checkedItems";
                }
                XDataTable.this.rowChangeNotifier.notifyDependsCheckedItems(multiName);
            }
        }

        @Override
        protected void uninstall(AbstractListDataProvider dataProvider) {
            dataProvider.removeHandler(this.root.propertyHandler);
            dataProvider.removeHandler(this.root.tableModelHandler);
        }

        @Override
        protected void install(AbstractListDataProvider dataProvider) {
            dataProvider.addHandler(this.root.propertyHandler);
            dataProvider.addHandler(this.root.tableModelHandler);
        }

        @Override
        protected void onTableModelChanged(DataTableModel tableModel) {
            tableModel.addHandler(this.propertyHandler);
        }

        @Override
        protected void onrowChanged() {
            if (XDataTable.this.dataProvider == null) {
                return;
            }
            ListItem selectedItem = XDataTable.this.dataProvider.getSelectedItem();
            Object oldValue = XDataTable.this.currentItem == null ? null : XDataTable.this.currentItem.getItem();
            Object newValue = selectedItem == null ? null : selectedItem.getItem();
            XDataTable.this.currentItem = null;
            if (selectedItem != null) {
                XDataTable.this.currentItem = selectedItem.clone();
            }
            if (oldValue != newValue && XDataTable.this.rowChangeNotifier != null) {
                XDataTable.this.rowChangeNotifier.execute();
            }
            if (XDataTable.this.rowHeaderView != null) {
                XDataTable.this.rowHeaderView.clearEditing();
            }
            try {
                this.root.scrollBar.adjustValues();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected void onopenItem() {
            try {
                ListItem selectedItem = XDataTable.this.dataProvider.getSelectedItem();
                if (selectedItem != null && selectedItem.getItem() != null) {
                    Object outcome = XDataTable.this.dataProvider.openSelectedItem();
                    if (outcome == null) {
                        return;
                    }
                    if (outcome instanceof PopupMenuOpener && (outcome = ((PopupMenuOpener)outcome).getFirst()) == null) {
                        return;
                    }
                    XDataTable.this.binding.fireNavigation(outcome);
                }
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        @Override
        protected void onchangedItem(ListItem li) {
            XDataTable.this.currentItem = null;
            if (li != null) {
                XDataTable.this.currentItem = li.clone();
            }
            if (XDataTable.this.rowChangeNotifier != null) {
                XDataTable.this.rowChangeNotifier.execute();
            }
        }

        @Override
        protected void oneditCellAt(int rowIndex, int colIndex) {
            if (this.root.rowHeaderView != null) {
                this.root.rowHeaderView.editRow(rowIndex);
            }
        }

        @Override
        public boolean hasRowHeader() {
            return this.root.isShowRowHeader();
        }
    }

    private class ListModelLoader
    implements Runnable {
        private Object LOCK = new Object();
        private boolean refreshOnly;
        private boolean processing;

        private ListModelLoader() {
        }

        Runnable load() {
            this.refreshOnly = false;
            return this;
        }

        Runnable refresh() {
            this.refreshOnly = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    if (this.refreshOnly) {
                        XDataTable.this.dataProvider.refresh();
                    } else {
                        XDataTable.this.dataProvider.load();
                        XDataTable.this.table.onrowChanged();
                    }
                }
                catch (Exception ex) {
                    this.showError(ex);
                }
            }
        }

        void showError(final Exception error) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MsgBox.err(error);
                }
            });
        }
    }

    private class RowChangeNotifier {
        private RowChangeNotifier() {
        }

        void execute() {
            int rowIndex = 0;
            if (XDataTable.this.dataProvider.getSelectedItem() != null) {
                rowIndex = XDataTable.this.dataProvider.getSelectedItem().getIndex();
            }
            this.updateBean(rowIndex);
            this.notifyDepends(rowIndex);
        }

        void updateBean(int rowIndex) {
            block6: {
                try {
                    String statName;
                    SelectionHandler selhandler = XDataTable.this.getSelectionHandler();
                    String name = XDataTable.this.getName();
                    ListItem oListItem = XDataTable.this.dataProvider.getListItem(rowIndex);
                    if (!ValueUtil.isEmpty((Object)name)) {
                        Object value = oListItem == null ? null : oListItem.getItem();
                        UIControlUtil.setBeanValue(XDataTable.this.binding, name, value);
                        if (selhandler != null) {
                            selhandler.setBeanValue(name, value);
                        }
                    }
                    if (!ValueUtil.isEmpty((Object)(statName = XDataTable.this.getVarStatus()))) {
                        ListItemStatus statValue = XDataTable.this.dataProvider.createListItemStatus(oListItem);
                        UIControlUtil.setBeanValue(XDataTable.this.binding, statName, (Object)statValue);
                        if (selhandler != null) {
                            selhandler.setStatusValue(statName, statValue);
                        }
                    }
                }
                catch (Throwable ex) {
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block6;
                    ex.printStackTrace();
                }
            }
        }

        void notifyDepends(final int rowIndex) {
            String sname = XDataTable.this.getName();
            if (!ValueUtil.isEmpty((Object)sname)) {
                if (XDataTable.this.immediate) {
                    XDataTable.this.binding.notifyDepends(XDataTable.this);
                    SelectionHandler selhandler = XDataTable.this.getSelectionHandler();
                    if (selhandler != null) {
                        selhandler.notifyDepends(sname);
                    }
                } else {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            RowChangeNotifier.this.notifyDependsAsync(rowIndex);
                        }
                    });
                    thread.start();
                }
            }
        }

        void notifyDependsCheckedItems(final String name) {
            if (!XDataTable.this.dataProvider.isMultiSelect()) {
                return;
            }
            if (XDataTable.this.immediate) {
                XDataTable.this.binding.notifyDepends(XDataTable.this, name);
                SelectionHandler selhandler = XDataTable.this.getSelectionHandler();
                if (selhandler != null) {
                    selhandler.notifyDepends(name);
                }
            } else {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        RowChangeNotifier.this.notifyDependsCheckedItemsAsync(name);
                    }
                });
                thread.start();
            }
        }

        private synchronized void notifyDependsAsync(int selectedRow) {
            try {
                Thread.sleep(200L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (selectedRow == XDataTable.this.table.getSelectedRow()) {
                    XDataTable.this.binding.notifyDepends(XDataTable.this);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private synchronized void notifyDependsCheckedItemsAsync(String name) {
            try {
                XDataTable.this.binding.notifyDepends(XDataTable.this, name);
                SelectionHandler selhandler = XDataTable.this.getSelectionHandler();
                if (selhandler != null) {
                    selhandler.notifyDepends(name);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class DesignTimeListModel
    extends DataListModel {
        private DesignTimeListModel() {
        }

        @Override
        public Column[] getColumns() {
            return new Column[]{new Column(null, "Column 1"), new Column(null, "Column 2")};
        }

        @Override
        public List fetchList(Map params) {
            return null;
        }
    }

    private class EditableListModel
    extends EditorListModel {
        XDataTable root;
        private List userDefinedList;
        private String name;

        EditableListModel(String name) {
            this.root = XDataTable.this;
            this.name = name;
        }

        @Override
        public List fetchList(Map params) {
            if (Beans.isDesignTime()) {
                return null;
            }
            if (this.userDefinedList == null && this.name != null || this.root.isDynamic()) {
                this.userDefinedList = (List)UIControlUtil.getBeanValue(XDataTable.this.binding, this.name);
            }
            if (this.userDefinedList == null) {
                return new ArrayList();
            }
            return this.userDefinedList;
        }
    }

    private class ReadonlyListModel
    extends DataListModel {
        XDataTable root;
        private List userDefinedList;
        private String name;

        ReadonlyListModel(String name) {
            this.root = XDataTable.this;
            this.name = name;
        }

        @Override
        public List fetchList(Map params) {
            if (Beans.isDesignTime()) {
                return null;
            }
            if (this.userDefinedList == null && this.name != null || this.root.isDynamic()) {
                this.userDefinedList = (List)UIControlUtil.getBeanValue(XDataTable.this.binding, this.name);
            }
            if (this.userDefinedList == null) {
                return new ArrayList();
            }
            return this.userDefinedList;
        }
    }

    private class ScrollBarPanel
    extends JPanel {
        ScrollBarPanel(JScrollBar scrollBar) {
            Dimension ps = scrollBar.getPreferredSize();
            this.setPreferredSize(ps);
            this.setLayout(new BorderLayout());
            scrollBar.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("visible".equals(propName)) {
                        Boolean visible = (Boolean)evt.getNewValue();
                        ScrollBarPanel.this.setVisible(visible);
                    }
                }
            });
            this.setVisible(scrollBar.isVisible());
            this.add((Component)scrollBar, "Center");
        }
    }
}

