/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.ActionBarModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.control.border.BorderProxy;
import com.rameses.rcp.control.border.XToolbarBorder;
import com.rameses.rcp.control.layout.ToolbarLayout;
import com.rameses.rcp.framework.ActionProvider;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.support.ActionButtonSupport;
import com.rameses.rcp.support.ComponentSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIComposite;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class XActionBar
extends JPanel
implements UIComposite,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private boolean useToolBar;
    private boolean dynamic;
    private int spacing = 0;
    private int index;
    private Insets padding = new Insets(0, 0, 0, 0);
    private BorderProxy borderProxy = new BorderProxy();
    private ToolbarLayout toolbarLayout = new ToolbarLayout();
    private ContainerLayout containerLayout = new ContainerLayout();
    private ComponentSupport componentSupport = new ComponentSupport();
    private String orientation = "HORIZONTAL";
    private String orientationHAlignment = "LEFT";
    private String orientationVAlignment = "TOP";
    private String target;
    private String formName;
    private List<UIControl> buttons = new ArrayList<UIControl>();
    private JComponent toolbarComponent;
    private boolean dirty;
    private boolean hideOnEmpty;
    private boolean mergeActions = true;
    private XButton buttonTpl = new XButton();
    private String textAlignment = "CENTER_LEFT";
    private String textPosition = "CENTER_TRAILING";
    private int buttonCaptionOrientation = 0;
    private boolean buttonTextInHtml;
    private boolean buttonAsHyperlink;
    private boolean showCaptions = true;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private String handler;
    private ActionBarModel model;
    private ControlProperty property;

    public XActionBar() {
        this.borderProxy.setBorder(new XToolbarBorder());
        super.setBorder(this.borderProxy);
        super.setLayout(new ContainerLayout());
        this.setUseToolBar(true);
        this.setMergeActions(true);
        new MouseEventSupport(this).install();
        if (Beans.isDesignTime()) {
            this.buttonTpl.setText(this.getClass().getSimpleName());
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public Border getBorder() {
        return this.borderProxy == null ? null : this.borderProxy.getBorder();
    }

    @Override
    public void setBorder(Border border) {
        if (!(border instanceof BorderProxy) && this.borderProxy != null) {
            this.borderProxy.setBorder(border);
        }
    }

    @Override
    public void refresh() {
        this.buildToolbar();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        ActionBarModel newModel = new ActionBarModel();
        try {
            Object ohandler = UIControlUtil.getBeanValue(this.getBinding(), this.getHandler());
            if (ohandler instanceof ActionBarModel) {
                newModel = (ActionBarModel)ohandler;
            }
        }
        catch (Throwable ohandler) {
            // empty catch block
        }
        ActionBarModel old = this.model;
        if (old != null) {
            old.setProvider(null);
        }
        this.model = newModel;
        this.buildButtons();
    }

    @Override
    public void reload() {
        this.buildButtons();
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("formName", this.getFormName());
        map.put("handler", this.getHandler());
        map.put("mergeActions", this.isMergeActions());
        map.put("showButtonCaptions", this.isShowCaptions());
        map.put("target", this.getTarget());
        return map;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private void buildButtons() {
        String _formname;
        UIController controller;
        List<Action> list;
        this.buttons.clear();
        ArrayList<Action> actions = new ArrayList<Action>();
        Object value = null;
        try {
            value = UIControlUtil.getBeanValue(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                for (Action aa : (Action[])value) {
                    actions.add(aa);
                }
            } else if (value instanceof Collection) {
                actions.addAll((Collection)value);
            }
        }
        String _name = this.getName();
        ActionProvider actionProvider = ClientContext.getCurrentContext().getActionProvider();
        if (actionProvider != null && _name != null && (list = actionProvider.getActionsByType(_name, controller = this.binding.getController(), false)) != null && !list.isEmpty() && (actions.isEmpty() || this.isMergeActions())) {
            Collections.sort(list);
            actions.addAll(list);
        }
        if ((_formname = this.getFormName()) != null && actionProvider != null) {
            List<Action> list2;
            Object retval = null;
            try {
                retval = UIControlUtil.getBeanValue(this.getBinding(), _formname);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (retval != null) {
                _formname = retval.toString();
            }
            String string = _name == null ? "formActions" : _name;
            StringBuilder invtype = new StringBuilder();
            if (_formname.length() > 0) {
                invtype.append(_formname);
            }
            if (string.length() > 0) {
                if (invtype.length() > 0) {
                    invtype.append(":");
                }
                invtype.append(string);
            }
            if (invtype.length() > 0 && (list2 = actionProvider.lookupActions(invtype.toString())) != null && !list2.isEmpty()) {
                actions.addAll(list2);
                Collections.sort(list2);
            }
        }
        if (actions.size() > 0) {
            for (Action action : actions) {
                boolean useLabelRenderer = (action.getPropertyString("renderer") == null ? "" : action.getPropertyString("renderer")).equalsIgnoreCase("label");
                if (useLabelRenderer) {
                    XLabel label = this.createLabel(action);
                    label.putClientProperty("Action.domain", action.getDomain());
                    label.putClientProperty("Action.role", action.getRole());
                    label.putClientProperty("Action.permission", action.getPermission());
                    label.putClientProperty("Component.parent", this);
                    this.buttons.add(label);
                    continue;
                }
                XButton btn = this.createButton(action);
                btn.putClientProperty("Action.domain", action.getDomain());
                btn.putClientProperty("Action.role", action.getRole());
                btn.putClientProperty("Action.permission", action.getPermission());
                btn.putClientProperty("Component.parent", this);
                if (!this.buttonTpl.isContentAreaFilled()) {
                    btn.setBorder(null);
                    btn.setOpaque(false);
                    btn.setCursor(Cursor.getPredefinedCursor(12));
                }
                btn.setContentAreaFilled(this.buttonTpl.isContentAreaFilled());
                btn.setBorderPainted(this.buttonTpl.isBorderPainted());
                Object actionInvoker = action.getProperties().get("Action.Invoker");
                btn.putClientProperty("Action.Invoker", actionInvoker);
                btn.putClientProperty(Action.class, action);
                btn.putClientProperty("Action.Bean", action.getProperties().get("Action.Bean"));
                this.buttons.add(btn);
            }
        }
        this.dirty = true;
        ArrayList<String> deplist = new ArrayList<String>();
        for (UIControl btn : this.buttons) {
            this.buildDepends(deplist, btn.getDepends());
        }
        this.buildDepends(deplist, this.getDepends());
        if (!deplist.isEmpty()) {
            String[] stringArray = deplist.toArray(new String[0]);
            this.getBinding().updateDepends(this, stringArray);
        }
    }

    private void buildDepends(List<String> deplist, String[] vals) {
        if (vals == null || vals.length == 0) {
            return;
        }
        for (String str : vals) {
            if (str == null || str.trim().length() == 0) continue;
            deplist.add(str);
        }
    }

    private Insets createPadding(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        Insets pad = new Insets(0, 0, 0, 0);
        int[] arr = new int[]{0, 0, 0, 0};
        String[] vals = str.split(",");
        for (int i = 0; i < arr.length; ++i) {
            int idx = i;
            if (idx >= vals.length) {
                idx = vals.length - 1;
            }
            try {
                arr[i] = new Integer(vals[idx]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        pad.top = arr[0];
        pad.left = arr[1];
        pad.bottom = arr[2];
        pad.right = arr[3];
        return pad;
    }

    private XLabel createLabel(Action action) {
        String[] styleNames;
        Insets pad;
        String spad;
        String sicon;
        Object depends;
        XLabel label = new XLabel();
        label.setText("");
        String caption = action.getCaption();
        if (caption != null) {
            label.setText(caption);
            if (caption.trim().startsWith("#{") && caption.trim().endsWith("}")) {
                label.setExpression(caption);
            }
        }
        if ((depends = action.getProperties().get("depends")) != null) {
            if (depends instanceof Object[]) {
                Object[] objarr = (Object[])depends;
                String[] arr = new String[objarr.length];
                for (int i = 0; i < arr.length; ++i) {
                    if (objarr[i] != null && objarr[i].toString().trim().length() > 0) {
                        arr[i] = objarr[i].toString();
                    }
                    label.setDepends(arr);
                }
            } else if (depends.toString().trim().length() > 0) {
                label.setDepends(new String[]{depends.toString()});
            }
        }
        if ((sicon = action.getIcon()) != null && sicon.trim().length() > 0) {
            ImageIcon icon = ImageIconSupport.getInstance().getIcon(sicon);
            label.setIcon(icon);
        }
        if ((spad = action.getPropertyString("margin")) == null || spad.trim().length() == 0) {
            spad = action.getPropertyString("padding");
        }
        if (spad != null && spad.trim().length() > 0 && (pad = this.createPadding(spad)) != null) {
            label.setBorder(BorderFactory.createEmptyBorder(pad.top, pad.left, pad.bottom, pad.right));
        }
        HashMap<String, String> styles = new HashMap<String, String>();
        for (String sname : styleNames = new String[]{"background", "background-color", "opacity", "foreground", "color"}) {
            String svalue = action.getPropertyString(sname);
            if (svalue == null || svalue.trim().length() <= 0) continue;
            styles.put(sname, svalue);
        }
        if (styles.containsKey("background") || styles.containsKey("background-color")) {
            label.setOpaque(true);
        } else {
            label.setOpaque(false);
        }
        ControlSupport.setStyles(styles, label);
        String fontStyle = action.getPropertyString("fontStyle");
        if (fontStyle != null && fontStyle.trim().length() > 0) {
            label.setFontStyle(fontStyle);
        }
        label.putClientProperty("visibleWhen", action.getVisibleWhen());
        label.setBinding(this.binding);
        return label;
    }

    private XButton createButton(Action action) {
        boolean b;
        Map params;
        String dfb;
        ImageIcon icon;
        String caption = action.getCaption();
        if (caption == null || caption.length() == 0) {
            caption = null;
        } else if ("[no caption]".equalsIgnoreCase(caption + "")) {
            caption = null;
        }
        XButton btn = new XButton();
        btn.setMnemonic(action.getMnemonic());
        ActionButtonSupport.getInstance().loadDefaults(btn, action.getName(), caption, btn);
        btn.setFocusable(false);
        btn.setMargin(new Insets(2, 2, 2, 2));
        if (!this.isUseToolBar()) {
            btn.setMargin(new Insets(2, 7, 2, 7));
        }
        btn.setName(action.getName());
        btn.setFont(this.buttonTpl.getFont());
        btn.setForeground(this.buttonTpl.getForeground());
        if (!ValueUtil.isEmpty((Object)caption)) {
            if (this.isButtonAsHyperlink()) {
                btn.setContentAreaFilled(false);
                btn.setBorderPainted(false);
                btn.setText("<html><a href='#'>" + caption + "</a></html>");
            } else if (this.isButtonTextInHtml()) {
                if ((this.getTextAlignment() + "").toUpperCase().indexOf("CENTER") >= 0) {
                    btn.setText("<html><center>" + caption + "</center></html>");
                } else {
                    btn.setText("<html>" + caption + "</html>");
                }
            } else {
                btn.setText(caption);
            }
        }
        this.componentSupport.alignText(btn, this.getTextAlignment());
        this.componentSupport.alignTextPosition(btn, this.getTextPosition());
        btn.setIndex(action.getIndex());
        btn.setUpdate(action.isUpdate());
        btn.setImmediate(action.isImmediate());
        String sicon = action.getIcon();
        if (sicon != null && sicon.length() > 0) {
            icon = ImageIconSupport.getInstance().getIcon(sicon);
            btn.setIcon(icon);
        }
        if (btn.getIcon() == null && this.toolbarComponent instanceof JToolBar) {
            icon = ImageIconSupport.getInstance().getIcon("com/rameses/rcp/icons/button-separator.png");
            btn.setIcon(icon);
        }
        btn.putClientProperty("visibleWhen", action.getVisibleWhen());
        btn.setBinding(this.binding);
        HashMap<String, String[]> props = new HashMap<String, String[]>(action.getProperties());
        btn.putClientProperty("disableWhen", props.get("disableWhen"));
        Object depends = props.get("depends");
        if (depends != null && !(depends instanceof Object[])) {
            props.put("depends", new String[]{depends.toString()});
        }
        if (props.get("shortcut") != null) {
            btn.setAccelerator(props.remove("shortcut") + "");
        }
        if (props.get("target") != null) {
            btn.setTarget(props.remove("target") + "");
        }
        if (props.get("default") != null && (dfb = props.remove("default") + "").equals("true")) {
            btn.putClientProperty("default.button", true);
        }
        if (!props.isEmpty()) {
            PropertyResolver res = PropertyResolver.getInstance();
            for (Map.Entry entry : props.entrySet()) {
                Map.Entry me = entry;
                if ("action".equals(me.getKey()) || "type".equals(me.getKey()) || "target".equals(me.getKey())) continue;
                try {
                    res.setProperty((Object)btn, (String)me.getKey(), me.getValue());
                }
                catch (Throwable throwable) {}
            }
        }
        if ((params = action.getParams()) != null && params.size() > 0) {
            btn.getParams().putAll(params);
        }
        if (!action.getClass().getName().equals(Action.class.getName())) {
            btn.putClientProperty(Action.class.getName(), action);
        }
        if (!(b = this.isShowCaptions()) && btn.getIcon() == null) {
            b = true;
        }
        if (btn.getIcon() == null || b && caption != null) {
            String s = btn.getText();
            if (s == null) {
                s = "";
            }
            if (!s.trim().startsWith("<html>")) {
                btn.setText("<html>" + s + "</html>");
            }
        } else {
            btn.setText("");
        }
        if (action.getTooltip() != null) {
            btn.setToolTipText(action.getTooltip());
        } else if (caption != null) {
            btn.setToolTipText(caption);
        }
        return btn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildToolbar() {
        if (this.dirty) {
            this.toolbarComponent.removeAll();
        }
        if (this.isDynamic()) {
            this.buildButtons();
        }
        String module_domain = null;
        if (this.getBinding() != null && this.getBinding().getOwner() != null) {
            Object obj = this.getBinding().getOwner().getClientProperty("Module.domain");
            module_domain = obj == null ? null : obj.toString();
        }
        boolean found = false;
        for (UIControl btn : this.buttons) {
            boolean result;
            boolean allowed;
            String domain = (String)btn.getClientProperty("Action.domain");
            String role = (String)btn.getClientProperty("Action.role");
            String permission = (String)btn.getClientProperty("Action.permission");
            if (role != null && domain == null) {
                domain = module_domain;
            }
            if (!(allowed = ControlSupport.isPermitted(domain, role, permission))) continue;
            XLabel xlabel = btn instanceof XLabel ? (XLabel)btn : null;
            XButton xbutton = btn instanceof XButton ? (XButton)btn : null;
            String expression = (String)btn.getClientProperty("visibleWhen");
            if (expression != null && expression.trim().length() > 0) {
                result = false;
                try {
                    result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), expression);
                }
                catch (Throwable t) {
                    result = false;
                }
                finally {
                    if (xlabel != null) {
                        xlabel.setVisible(result);
                    } else if (xbutton != null) {
                        xbutton.setVisible(result);
                    }
                }
            }
            if ((expression = (String)btn.getClientProperty("disableWhen")) != null && expression.trim().length() > 0) {
                result = false;
                try {
                    result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), expression);
                    if (xbutton != null) {
                        xbutton.setEnabled(!result);
                    }
                }
                catch (Throwable t) {
                    try {
                        result = false;
                        if (xbutton != null) {
                            xbutton.setEnabled(!result);
                        }
                    }
                    catch (Throwable throwable) {
                        if (xbutton != null) {
                            xbutton.setEnabled(!result);
                        }
                        throw throwable;
                    }
                }
            }
            if (btn.getClientProperty("default.button") != null) {
                if (this.getRootPane() != null) {
                    this.getRootPane().setDefaultButton(xbutton);
                } else {
                    this.binding.setDefaultButton(xbutton);
                }
            }
            if (!this.dirty) continue;
            this.toolbarComponent.add((JComponent)((Object)btn));
        }
        this.revalidate();
        this.repaint();
        this.dirty = false;
    }

    public boolean isMergeActions() {
        return this.mergeActions;
    }

    public void setMergeActions(boolean mergeActions) {
        this.mergeActions = mergeActions;
    }

    public boolean isHideOnEmpty() {
        return this.hideOnEmpty;
    }

    public void setHideOnEmpty(boolean hideOnEmpty) {
        this.hideOnEmpty = hideOnEmpty;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(String textAlignment) {
        this.textAlignment = textAlignment;
    }

    public String getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(String textPosition) {
        this.textPosition = textPosition;
    }

    public boolean isShowCaptions() {
        return this.showCaptions;
    }

    public void setShowCaptions(boolean showCaptions) {
        this.showCaptions = showCaptions;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public List<? extends UIControl> getControls() {
        return this.buttons;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public boolean isUseToolBar() {
        return this.useToolBar;
    }

    public void setUseToolBar(boolean useToolBar) {
        this.useToolBar = useToolBar;
        super.removeAll();
        if (useToolBar) {
            JToolBar tlb = new JToolBar();
            tlb.setFocusable(false);
            tlb.setFloatable(false);
            tlb.setRollover(true);
            this.toolbarComponent = tlb;
        } else {
            this.toolbarComponent = new JPanel();
        }
        this.toolbarComponent.setLayout(this.toolbarLayout);
        this.toolbarComponent.setName("toolbar");
        this.toolbarComponent.setOpaque(false);
        this.add(this.toolbarComponent);
        if (Beans.isDesignTime()) {
            this.toolbarComponent.add(this.buttonTpl);
        }
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public int getHorizontalAlignment() {
        return 0;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation != null ? orientation.toUpperCase() : "HORIZONTAL";
        this.toolbarLayout.setOrientation(this.orientation);
    }

    public String getOrientationHAlignment() {
        return this.orientationHAlignment;
    }

    public void setOrientationHAlignment(String alignment) {
        this.orientationHAlignment = alignment != null ? alignment.toUpperCase() : "LEFT";
        this.toolbarLayout.setAlignment(this.orientationHAlignment);
    }

    public String getOrientationVAlignment() {
        return this.orientationVAlignment;
    }

    public void setOrientationVAlignment(String alignment) {
        this.orientationVAlignment = alignment != null ? alignment.toUpperCase() : "TOP";
        this.toolbarLayout.setAlignment(this.orientationVAlignment);
    }

    @Override
    public boolean focusFirstInput() {
        return false;
    }

    private XButton getButtonTemplate() {
        if (this.buttonTpl == null) {
            this.buttonTpl = new XButton();
        }
        return this.buttonTpl;
    }

    public Font getButtonFont() {
        return this.getButtonTemplate().getFont();
    }

    public void setButtonFont(Font font) {
        this.getButtonTemplate().setFont(font);
    }

    public boolean getButtonBorderPainted() {
        return this.getButtonTemplate().isBorderPainted();
    }

    public void setButtonBorderPainted(boolean borderPainted) {
        this.getButtonTemplate().setBorderPainted(borderPainted);
    }

    public boolean getButtonContentAreaFilled() {
        return this.getButtonTemplate().isContentAreaFilled();
    }

    public void setButtonContentAreaFilled(boolean contentAreaFilled) {
        this.getButtonTemplate().setContentAreaFilled(contentAreaFilled);
    }

    public Dimension getButtonPreferredSize() {
        return this.getButtonTemplate().getPreferredSize();
    }

    public void setButtonPreferredSize(Dimension preferredSize) {
        this.getButtonTemplate().setPreferredSize(preferredSize);
    }

    public int getButtonCaptionOrientation() {
        return this.buttonCaptionOrientation;
    }

    public void setButtonCaptionOrientation(int orientation) {
        this.buttonCaptionOrientation = orientation;
        if (orientation == 1 || orientation == 3) {
            this.getButtonTemplate().setVerticalTextPosition(orientation);
            this.getButtonTemplate().setHorizontalTextPosition(0);
        } else {
            this.getButtonTemplate().setVerticalTextPosition(0);
            this.getButtonTemplate().setHorizontalTextPosition(orientation);
        }
    }

    public boolean isButtonTextInHtml() {
        return this.buttonTextInHtml;
    }

    public void setButtonTextInHtml(boolean buttonTextInHtml) {
        this.buttonTextInHtml = buttonTextInHtml;
    }

    public Color getButtonForeground() {
        return this.getButtonTemplate().getForeground();
    }

    public void setButtonForeground(Color foreground) {
        this.getButtonTemplate().setForeground(foreground);
    }

    public boolean isButtonAsHyperlink() {
        return this.buttonAsHyperlink;
    }

    public void setButtonAsHyperlink(boolean buttonAsHyperlink) {
        this.buttonAsHyperlink = buttonAsHyperlink;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    @Override
    public boolean isVisible() {
        boolean b = super.isVisible();
        if (Beans.isDesignTime()) {
            return b;
        }
        if (!this.isHideOnEmpty()) {
            return b;
        }
        if (!b) {
            return false;
        }
        Component[] comps = this.toolbarComponent.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    private class ContainerLayout
    implements LayoutManager {
        private ContainerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                if (XActionBar.this.toolbarComponent != null && XActionBar.this.toolbarComponent.getComponents().length > 0) {
                    Insets margin = parent.getInsets();
                    Dimension dim = XActionBar.this.toolbarComponent.getPreferredSize();
                    w = margin.left + dim.width + margin.right;
                    h = margin.top + dim.height + margin.bottom;
                    Insets pads = XActionBar.this.getPadding();
                    if (pads != null) {
                        w += pads.left + pads.right;
                        h += pads.top + pads.bottom;
                    }
                }
                return new Dimension(w, h);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                if (XActionBar.this.toolbarComponent != null) {
                    Insets margin = parent.getInsets();
                    int x = margin.left;
                    int y = margin.top;
                    int w = parent.getWidth() - (margin.left + margin.right);
                    int h = parent.getHeight() - (margin.top + margin.bottom);
                    Insets pads = XActionBar.this.getPadding();
                    if (pads != null) {
                        x += pads.left;
                        y += pads.top;
                        w -= pads.left + pads.right;
                        h -= pads.top + pads.bottom;
                    }
                    XActionBar.this.toolbarComponent.setBounds(x, y, w, h);
                }
            }
        }
    }
}

