/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.framework.Binding;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSubControlModel {
    private static final long serialVersionUID = 1L;
    private Binding controlBinding;
    private String beanName;
    private String fieldName;
    private Map properties = new HashMap();

    public void onInit() {
    }

    public void onRefresh() {
    }

    public Object createContext() {
        return null;
    }

    final void init(Binding controlBinding, String name) {
        this.controlBinding = controlBinding;
        if (name == null) {
            return;
        }
        if (name.contains(".")) {
            this.beanName = name.substring(0, name.lastIndexOf("."));
            this.fieldName = name.substring(name.lastIndexOf(".") + 1);
        } else {
            this.beanName = name;
        }
    }

    public final Binding getControlBinding() {
        return this.controlBinding;
    }

    public final String getBeanName() {
        return this.beanName;
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public final Object getContext() {
        if (this.beanName == null) {
            return null;
        }
        try {
            PropertyResolver res = PropertyResolver.getInstance();
            Object context = res.getProperty(this.controlBinding.getBean(), this.beanName);
            if (this.fieldName != null) {
                context = res.getProperty(context, this.fieldName);
            }
            if (context == null && (context = this.createContext()) != null) {
                this.setContext(context);
            }
            return context;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setContext(Object value) {
        if (this.beanName == null) {
            return;
        }
        PropertyResolver res = PropertyResolver.getInstance();
        if (this.fieldName != null) {
            Object bean = res.getProperty(this.controlBinding.getBean(), this.beanName);
            res.setProperty(bean, this.fieldName, value);
        } else {
            res.setProperty(this.controlBinding.getBean(), this.beanName, value);
        }
    }

    public final Map getProperties() {
        return this.properties;
    }
}

