/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValidatorEvent {
    private ActionMessage globalMessages = new ActionMessage();
    private Map<String, ActionMessage> messages = new LinkedHashMap<String, ActionMessage>();
    private Component source;
    private Binding binding;

    public ValidatorEvent(Binding binding) {
        this.binding = binding;
    }

    public void add(ValidatorEvent evt) {
        this.globalMessages.addMessage(evt.globalMessages);
        if (evt.messages.size() > 0) {
            this.messages.putAll(evt.messages);
        }
        if (this.source == null && evt.source != null) {
            this.source = evt.source;
        }
    }

    public void addMessage(String entity, Object message) {
        if (this.source == null && !ValueUtil.isEmpty((Object)entity)) {
            this.source = (Component)((Object)this.binding.find(entity));
        }
        this.addMessage(entity, message, null);
    }

    public void addMessage(String entity, Object message, Object[] args) {
        if (message == null) {
            return;
        }
        if (entity != null) {
            this.getMessagesFor(entity).addMessage(null, message.toString(), args);
        } else {
            this.globalMessages.addMessage(null, message.toString(), args);
        }
    }

    private ActionMessage getMessagesFor(String entity) {
        if (this.messages.get(entity) == null) {
            this.messages.put(entity, new ActionMessage());
        }
        return this.messages.get(entity);
    }

    public Map<String, ActionMessage> getMessagesMap() {
        return this.messages;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty() || this.globalMessages.hasMessages();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.globalMessages.hasMessages()) {
            sb.append(this.globalMessages.toString());
        }
        boolean first = sb.length() == 0;
        for (ActionMessage msg : this.messages.values()) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(msg.toString());
            first = false;
        }
        return sb.toString();
    }

    public Component getSource() {
        return this.source;
    }
}

