/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

public class TextWriter {
    private StringBuilder buffer = new StringBuilder();
    private Handler handler;

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public String getText() {
        return this.buffer.toString();
    }

    public void write(char[] cbuf) {
        this.writeObject(new String(cbuf));
    }

    public void write(char[] cbuf, int off, int len) {
        this.writeObject(new String(cbuf, off, len));
    }

    public void write(int c) {
        this.writeObject(c + "");
    }

    public void write(String str) {
        this.writeObject(str);
    }

    public void write(String str, int off, int len) {
        this.writeObject(new String(str.getBytes(), off, len));
    }

    public void write(Object o) {
        this.writeObject(o);
    }

    public void writeln(Object o) {
        this.writeObject(o);
        this.writeObject("\n");
    }

    private void writeObject(Object o) {
        this.buffer.append(o);
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.write(o == null ? "null" : o.toString());
        }
    }

    public void clear() {
        int len = this.buffer.length();
        if (len == 0) {
            return;
        }
        this.buffer.delete(0, len);
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.clear();
        }
    }

    public static interface Handler {
        public void write(String var1);

        public void clear();
    }
}

