/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.ListItemStatus;
import com.rameses.rcp.common.ListPageModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ScrollListModel
extends AbstractListDataProvider
implements ListPageModel {
    public static final int PAGE_FIRST = 0;
    public static final int PAGE_BACK = 1;
    public static final int PAGE_NEXT = 2;
    public static final int PAGE_LAST = 3;
    public static final int PAGE_BACK_RECORD = 4;
    public static final int PAGE_NEXT_RECORD = 5;
    protected int pageIndex = 1;
    protected int pageCount = 1;
    protected int toprow;
    protected int maxRows = -1;
    protected int minlimit = 0;
    protected int maxlimit = 0;
    protected String searchtext;
    private Map query = new HashMap();
    private boolean hasMoreRecords;
    private int preferredRows;
    private int fetchedRows;
    private int pageMode = 0;
    private int maxRecordCount;
    private int maxPageCount;
    private Boolean allocNewRow;

    public Map getQuery() {
        return this.query;
    }

    public void setQuery(Map map) {
        this.query.clear();
        if (map != null) {
            this.query.putAll(map);
        }
    }

    public String getSearchtext() {
        return this.searchtext;
    }

    public void setSearchtext(String searchtext) {
        this.searchtext = searchtext;
        this.getQuery().put("searchtext", searchtext);
    }

    public Object createItem() {
        return new HashMap();
    }

    @Override
    public ListItemStatus createListItemStatus(ListItem oListItem) {
        ListItemStatus stat = super.createListItemStatus(oListItem);
        stat.setPageIndex(this.pageIndex);
        stat.setPageCount(this.maxPageCount);
        stat.setIsLastPage(this.isLastPage());
        stat.setHasNextPage(this.fetchedRows > this.preferredRows);
        return stat;
    }

    @Override
    public void load() {
        this.toprow = 0;
        this.minlimit = 0;
        this.maxlimit = 0;
        this.maxRows = -1;
        this.pageIndex = 1;
        this.pageCount = 1;
        this.maxRecordCount = 0;
        this.maxPageCount = 0;
        this.fetchedRows = 0;
        this.preferredRows = 0;
        super.load();
    }

    @Override
    public int getRows() {
        return 10;
    }

    @Override
    protected void onbeforeFetchList(Map params) {
        Map qry = this.getQuery();
        if (qry != null) {
            params.putAll(qry);
        }
    }

    @Override
    protected void fetch(boolean forceLoad) {
        int selRownum;
        ListItem selItem = this.getSelectedItem();
        int selIndex = selItem == null ? 0 : selItem.getIndex();
        int n = selRownum = selItem == null ? 0 : selItem.getRownum();
        if (this.getDataList() == null || forceLoad) {
            int _preferredRows = this.getRows() * 3;
            int _minlimit = this.toprow - this.getRows();
            if (_minlimit < 0) {
                _minlimit = 0;
            }
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            this.onbeforeFetchList(params);
            params.put("_toprow", this.toprow);
            params.put("_start", _minlimit);
            params.put("_rowsize", _preferredRows + 1);
            params.put("_limit", _preferredRows + 1);
            ArrayList resultList = this.fetchList(params);
            if (resultList == null) {
                resultList = new ArrayList();
            }
            this.onafterFetchList(resultList);
            this.fetchedRows = resultList.size();
            this.preferredRows = _preferredRows;
            this.minlimit = _minlimit;
            this.hasMoreRecords = false;
            if (resultList.size() > this.preferredRows) {
                this.hasMoreRecords = true;
                resultList.remove(resultList.size() - 1);
            }
            this.setDataList(resultList);
            int tmpMaxRows = this.minlimit + resultList.size() - 1;
            if (this.isAllocNewRow()) {
                ++tmpMaxRows;
            }
            if (tmpMaxRows > this.maxRows) {
                this.maxRows = tmpMaxRows;
            }
            this.maxlimit = this.toprow + this.getRows() * 2 - 1;
            if (this.maxlimit > this.maxRows) {
                this.maxlimit = this.maxRows;
            }
            this.pageCount = (this.maxRows + 1) / this.getRows() + ((this.maxRows + 1) % this.getRows() > 0 ? 1 : 0);
        }
        int tmpTotalRows = this.minlimit + Math.min(this.fetchedRows, this.preferredRows);
        this.maxRecordCount = Math.max(this.maxRecordCount, tmpTotalRows);
        this.maxPageCount = Math.max(this.maxPageCount, tmpTotalRows / this.getRows() + 1);
        this.pageIndex = this.toprow / this.getRows() + 1;
        if (this.toprow == 0 && this.minlimit == 0) {
            this.fillListItems(this.getDataList(), this.minlimit);
        } else {
            int baseIndex = this.toprow - this.minlimit - this.getRows() + 1;
            if (selIndex == 0) {
                baseIndex = this.toprow - this.minlimit;
            }
            if ((baseIndex = this.toprow - Math.max(selIndex, 0) - this.minlimit) < 0) {
                baseIndex = 0;
            }
            List sublist = this.subList(this.getDataList(), baseIndex, this.getRows());
            this.fillListItems(sublist, this.minlimit + baseIndex);
        }
        if (selItem != null) {
            this.setSelectedItem(selIndex);
        }
        if (selItem == null) {
            this.setSelectedItem(0);
        }
    }

    private List subList(List source, int start, int length) {
        ArrayList list = new ArrayList();
        if (source == null || source.isEmpty()) {
            return list;
        }
        int len = start + length;
        for (int i = start; i < len; ++i) {
            try {
                list.add(source.get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void moveNextRecord() {
        this.moveNextRecord(true);
    }

    @Override
    public void moveNextRecord(boolean includesEmptyItem) {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (this.getSelectedItem() == null) {
            return;
        }
        int newToprow = this.getSelectedItem().getRownum() + 1;
        if (this.isTopRowVisible(newToprow)) {
            ListItem li = this.getListItemByRownum(newToprow);
            this.setSelectedItem(li.getIndex());
            this.fireFocusSelectedItem();
        } else {
            this.moveTopRowUp(newToprow);
        }
    }

    @Override
    public void moveBackRecord() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (this.getSelectedItem() == null) {
            return;
        }
        int newToprow = this.getSelectedItem().getRownum() - 1;
        if (this.isTopRowVisible(newToprow)) {
            ListItem li = this.getListItemByRownum(newToprow);
            this.setSelectedItem(li.getIndex());
            this.fireFocusSelectedItem();
        } else {
            this.moveTopRowDown(newToprow);
        }
    }

    @Override
    public void moveNextPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (this.getSelectedItem() == null) {
            return;
        }
        if (this.isLastPage()) {
            return;
        }
        int newToprow = this.toprow + this.getRows();
        if (newToprow >= this.minlimit + this.preferredRows && this.fetchedRows > this.preferredRows) {
            this.toprow = newToprow;
            this.refresh(true);
        } else {
            this.toprow = newToprow;
            this.refresh();
        }
    }

    @Override
    public void moveBackPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (this.getSelectedItem() == null) {
            return;
        }
        int newToprow = this.toprow - this.getRows();
        if (newToprow < 0) {
            newToprow = 0;
            this.setSelectedItem(0);
        }
        this.toprow = newToprow;
        if (newToprow < this.minlimit && this.minlimit > 0) {
            this.refresh(true);
        } else {
            this.refresh();
        }
    }

    @Override
    public void moveFirstPage() {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        this.toprow = 0;
        this.refresh();
    }

    @Override
    public void moveLastPage() {
    }

    @Override
    public int getTopRow() {
        return this.toprow;
    }

    @Override
    public void setTopRow(int toprow) {
        if (this.getMessageSupport().hasErrorMessages()) {
            return;
        }
        if (this.toprow == toprow) {
            return;
        }
        if (this.isTopRowVisible(toprow)) {
            ListItem li = this.getListItemByRownum(toprow);
            this.setSelectedItem(li.getIndex());
            this.fireFocusSelectedItem();
        } else if (toprow > this.toprow) {
            this.moveTopRowUp(toprow);
        } else if (toprow < this.toprow) {
            this.moveTopRowDown(toprow);
        }
    }

    private void moveTopRowUp(int newToprow) {
        int xlimit = this.minlimit + this.preferredRows;
        if (newToprow >= xlimit && this.fetchedRows > this.preferredRows) {
            this.toprow = newToprow;
            this.refresh(true);
        } else if (newToprow <= this.minlimit + this.fetchedRows) {
            this.toprow = newToprow;
            this.refresh();
        }
    }

    private void moveTopRowDown(int newToprow) {
        this.toprow = Math.max(newToprow, 0);
        if (newToprow < this.minlimit && this.minlimit > 0) {
            this.refresh(true);
        } else {
            this.refresh();
        }
    }

    private int getPageViewIndex(int toprow) {
        int index = toprow / this.getRows();
        int rem = toprow % this.getRows();
        return rem > 0 ? index + 1 : index;
    }

    @Override
    protected void onselectedItemChanged(ListItem li) {
        this.toprow = li == null ? 0 : li.getRownum();
    }

    public final void doSearch() {
        this.load();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public int getRowCount() {
        if (this.isAllocNewRow()) {
            return this.maxRows - 1;
        }
        return this.maxRows;
    }

    public boolean isLastPage() {
        if (this.pageIndex < this.pageCount) {
            return false;
        }
        if (this.fetchedRows <= this.preferredRows) {
            return true;
        }
        return this.pageIndex > this.pageCount;
    }

    protected boolean isAllocNewRow() {
        if (this.allocNewRow == null) {
            this.allocNewRow = this.createItem() != null ? new Boolean(true) : new Boolean(false);
        }
        return this.allocNewRow;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private boolean isTopRowVisible(int toprow) {
        ListItem firstLI = this.getFirstItem();
        if (firstLI == null) {
            return false;
        }
        ListItem lastLI = this.getLastItem();
        if (lastLI == null) {
            return false;
        }
        return toprow >= firstLI.getRownum() && toprow <= lastLI.getRownum();
    }
}

