/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.PropertySupport;

public class IntegerColumnHandler
extends Column.TypeHandler
implements PropertySupport.IntegerPropertyInfo {
    private static final long serialVersionUID = 1L;
    private String format;
    private int minValue;
    private int maxValue;

    public IntegerColumnHandler() {
        this((String)null);
    }

    public IntegerColumnHandler(String format) {
        this(format, -1, -1);
    }

    public IntegerColumnHandler(String format, int minValue, int maxValue) {
        this.format = format;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public String getType() {
        return "integer";
    }

    @Override
    public String getFormat() {
        Object value = super.get("format");
        if (value == null) {
            value = this.format;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public int getMinValue() {
        Number num;
        Object value = super.get("minValue");
        if (value == null) {
            value = this.minValue;
        }
        return (num = this.convertInteger(value)) == null ? -1 : num.intValue();
    }

    @Override
    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    @Override
    public int getMaxValue() {
        Number num;
        Object value = super.get("maxValue");
        if (value == null) {
            value = this.maxValue;
        }
        return (num = this.convertInteger(value)) == null ? -1 : num.intValue();
    }

    @Override
    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    protected Number convertInteger(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

