/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.TableModelSupport;
import java.util.HashMap;

public final class EditorListSupport {
    private AbstractListDataProvider dataProvider;
    private TableEditor tableEditor;
    private TableEditorHandler handler;
    private TableEditorProvider editorProvider;

    public static EditorListSupport create(AbstractListDataProvider dataProvider) {
        if (dataProvider == null) {
            return null;
        }
        if (dataProvider instanceof TableEditor) {
            EditorListSupport els = new EditorListSupport(dataProvider);
            return els.handler == null ? null : els;
        }
        return null;
    }

    private EditorListSupport(AbstractListDataProvider dataProvider) {
        this.tableEditor = (TableEditor)((Object)dataProvider);
        this.handler = this.tableEditor.getTableEditorHandler();
        this.dataProvider = dataProvider;
        this.tableEditor.setEditorListSupport(this);
    }

    public final AbstractListDataProvider getSource() {
        return this.dataProvider;
    }

    public boolean isTemporaryItem(ListItem li) {
        return li.getState() == 2;
    }

    public void flushTemporaryItem(ListItem li) {
        if (!this.isTemporaryItem(li)) {
            return;
        }
        this.validate(li);
        this.onAddItem(li.getItem());
        li.setState(1);
    }

    public void removeTemporaryItem(ListItem li) {
        if (!this.isTemporaryItem(li)) {
            return;
        }
        li.loadItem(null, 0);
        this.dataProvider.removeListItem(li.getIndex() + 1);
    }

    public Object loadTemporaryItem(ListItem li, String columnName) {
        HashMap item = this.handler.createItem(columnName);
        if (item == null) {
            item = new HashMap();
        }
        li.loadItem(item, 2);
        return item;
    }

    public boolean isAllowedForEditing(ListItem li) {
        int size;
        if (li == null) {
            return false;
        }
        int index = li.getIndex();
        if (index == (size = this.dataProvider.getListItems().size())) {
            return true;
        }
        return index >= 0 && index < size;
    }

    public boolean isColumnEditable(Object item, String columnName) {
        return this.handler.isColumnEditable(item, columnName);
    }

    public boolean isLastItem(ListItem li) {
        int index = li.getIndex();
        return index + 1 == this.dataProvider.getListItems().size();
    }

    public boolean isAllowAdd() {
        return this.handler.isAllowAdd();
    }

    public final void addEmptyItem() {
        this.dataProvider.addEmptyItem();
    }

    public void fireUpdateItem(ListItem li) {
        if (li == null) {
            return;
        }
        this.onUpdateItem(li.getItem());
    }

    public void fireValidateItem(ListItem li) {
        if (li != null) {
            this.validate(li);
        }
    }

    public void fireCommitItem(ListItem li) {
        if (li == null) {
            return;
        }
        this.onCommitItem(li.getItem());
        li.setState(1);
    }

    public void fireRemoveItem(ListItem li) {
        if (li == null) {
            return;
        }
        if (li.getState() == 0) {
            return;
        }
        int index = li.getIndex();
        this.dataProvider.getMessageSupport().removeErrorMessage(index);
        TableModelSupport tms = this.tableEditor.getTableModelSupport();
        if (li.getState() == 2) {
            if (this.dataProvider.getListItem(index + 1) == null) {
                li.loadItem(null, 0);
                tms.fireTableRowsUpdated(index, index);
            } else {
                this.dataProvider.getDataList().remove(index);
                this.dataProvider.getListItems().remove(index);
                tms.fireTableRowsDeleted(index, index);
            }
        } else {
            if (!this.onRemoveItem(li.getItem())) {
                return;
            }
            int itemIndex = this.dataProvider.getListItems().indexOf(li);
            int dataIndex = this.dataProvider.getDataList().indexOf(li.getItem());
            if (dataIndex < 0 && itemIndex == index) {
                this.dataProvider.refresh(false);
            }
        }
    }

    public final void fireBeforeColumnUpdate(ListItem li, Object newValue) {
        if (li == null) {
            return;
        }
        try {
            String columnName = this.dataProvider.getSelectedColumn();
            boolean success = this.handler.beforeColumnUpdate(li.getItem(), columnName, newValue);
            if (success) {
                return;
            }
        }
        catch (Throwable t) {
            throw new BeforeColumnUpdateException(t);
        }
        throw new BeforeColumnUpdateException();
    }

    public final void fireColumnUpdate(ListItem li) {
        if (li == null) {
            return;
        }
        try {
            String columnName = this.dataProvider.getSelectedColumn();
            this.handler.onColumnUpdate(li.getItem(), columnName);
        }
        catch (Throwable t) {
            throw new AfterColumnUpdateException(t);
        }
    }

    protected void validate(ListItem li) {
        this.handler.validate(li);
    }

    protected void onAddItem(Object item) {
        this.handler.onAddItem(item);
    }

    protected void onUpdateItem(Object item) {
        this.handler.onUpdateItem(item);
    }

    protected void onCommitItem(Object item) {
        this.handler.onCommitItem(item);
    }

    protected boolean onRemoveItem(Object item) {
        return this.handler.onRemoveItem(item);
    }

    public void setTableEditorProvider(TableEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    public final void refreshCurrentEditor() {
        if (this.editorProvider == null) {
            return;
        }
        ListItem li = this.dataProvider.getSelectedItem();
        if (li != null) {
            this.editorProvider.refreshCurrentEditor(li);
        }
    }

    public final boolean hasUncommittedData() {
        return this.editorProvider == null ? false : this.editorProvider.hasUncommittedData();
    }

    public static interface TableEditorHandler {
        public boolean isAllowAdd();

        public Object createItem(String var1);

        public void validate(ListItem var1);

        public void onAddItem(Object var1);

        public void onUpdateItem(Object var1);

        public void onCommitItem(Object var1);

        public boolean onRemoveItem(Object var1);

        public boolean isColumnEditable(Object var1, String var2);

        public boolean beforeColumnUpdate(Object var1, String var2, Object var3);

        public void onColumnUpdate(Object var1, String var2);
    }

    public static interface TableEditorProvider {
        public void refreshCurrentEditor(ListItem var1);

        public boolean hasUncommittedData();
    }

    public static interface TableEditor {
        public TableEditorHandler getTableEditorHandler();

        public TableModelSupport getTableModelSupport();

        public void setEditorListSupport(EditorListSupport var1);
    }

    public static class AfterColumnUpdateException
    extends RuntimeException {
        AfterColumnUpdateException() {
        }

        AfterColumnUpdateException(Throwable caused) {
            super(caused);
        }
    }

    public static class BeforeColumnUpdateException
    extends RuntimeException {
        BeforeColumnUpdateException() {
        }

        BeforeColumnUpdateException(Throwable caused) {
            super(caused);
        }
    }
}

