/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;

public class Action
implements Comparable<Action> {
    private String name;
    private String caption;
    private String icon;
    private char mnemonic;
    private String permission;
    private String tooltip;
    private String visibleWhen;
    private String category;
    private int index;
    private boolean immediate;
    private boolean update;
    private String role;
    private String domain;
    private boolean showCaption;
    private Action parent;
    private ActionDelegator actionDelegator;
    private Map properties = new Hashtable();
    private Map parameters = new HashMap();
    private Object handler;

    public Action() {
    }

    public Action(String name) {
        this.name = name;
    }

    public Action(String name, String caption, String icon) {
        this.name = name;
        this.caption = caption;
        this.icon = icon;
    }

    public Action(String name, String caption, String icon, char mnemonic) {
        this.name = name;
        this.caption = caption;
        this.icon = icon;
        if (mnemonic != ' ') {
            this.mnemonic = mnemonic;
        }
    }

    public Action(String name, String caption, String icon, char mnemonic, String perm) {
        this.name = name;
        this.caption = caption;
        this.icon = icon;
        this.mnemonic = mnemonic;
        this.permission = perm;
    }

    @Override
    public int compareTo(Action a) {
        return this.index - a.index;
    }

    public Object execute() {
        ActionDelegator ad = this.getActionDelegator();
        if (ad != null) {
            return ad.execute(this);
        }
        if (this.handler instanceof Runnable) {
            ((Runnable)this.handler).run();
        } else {
            if (this.handler instanceof Callable) {
                try {
                    return ((Callable)this.handler).call();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (this.handler instanceof ActionDelegator) {
                return ((ActionDelegator)this.handler).execute(this);
            }
        }
        return null;
    }

    public String getCaption() {
        String sval = this.caption;
        if (sval == null || sval.length() == 0) {
            sval = this.getPropertyString("caption");
        }
        if (sval == null || sval.length() == 0) {
            return this.caption;
        }
        return sval;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getIcon() {
        String sval = this.icon;
        if (sval == null || sval.length() == 0) {
            sval = this.getPropertyString("icon");
        }
        if (sval == null || sval.length() == 0) {
            return this.icon;
        }
        return sval;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Action getParent() {
        return this.parent;
    }

    public void setParent(Action parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getPath() {
        return this.category + "/" + this.name;
    }

    public Map getProperties() {
        return this.properties;
    }

    public char getMnemonic() {
        char sval = this.mnemonic;
        if (this.mnemonic == '\u0000') {
            sval = this.getPropertyChar("mnemonic");
        }
        if (this.mnemonic == '\u0000') {
            return this.mnemonic;
        }
        return sval;
    }

    public void setMnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Deprecated
    public Map getParameters() {
        return this.parameters;
    }

    @Deprecated
    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public Map getParams() {
        return this.parameters;
    }

    public void setParams(Map parameters) {
        this.parameters = parameters;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getTooltip() {
        String sval = this.tooltip;
        if (sval == null || sval.length() == 0) {
            sval = this.getPropertyString("tooltip");
        }
        if (sval == null || sval.length() == 0) {
            sval = this.getCaption();
        }
        if (sval == null || sval.length() == 0) {
            return this.tooltip;
        }
        return sval;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getVisibleWhen() {
        String sval = this.visibleWhen;
        if (sval == null || sval.length() == 0) {
            sval = this.getPropertyString("visibleWhen");
        }
        if (sval == null || sval.length() == 0) {
            return this.visibleWhen;
        }
        return sval;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isShowCaption() {
        Boolean bool = this.getPropertyBoolean("showCaption");
        if (bool != null) {
            return bool;
        }
        if (this.showCaption) {
            return true;
        }
        if (this.getIcon() == null) {
            return true;
        }
        return this.showCaption;
    }

    public void setShowCaption(boolean showCaption) {
        this.showCaption = showCaption;
    }

    public ActionDelegator getActionDelegator() {
        return this.actionDelegator;
    }

    public void setActionDelegator(ActionDelegator actionDelegator) {
        this.actionDelegator = actionDelegator;
    }

    public final String getPropertyString(String name) {
        Object o = this.properties.get(name);
        return o == null ? null : o.toString();
    }

    public final char getPropertyChar(String name) {
        Object o = this.properties.get(name);
        return o == null ? (char)'\u0000' : o.toString().charAt(0);
    }

    public final Boolean getPropertyBoolean(String name) {
        Object o = this.properties.get(name);
        if (o == null) {
            return null;
        }
        return "true".equalsIgnoreCase(o.toString());
    }

    public Object getHandler() {
        return this.handler;
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    public Action clone() {
        Action newAction = new Action();
        newAction.setName(this.getName());
        newAction.setCaption(this.getCaption());
        newAction.setIcon(this.getIcon());
        newAction.setMnemonic(this.getMnemonic());
        newAction.setPermission(this.getPermission());
        newAction.setTooltip(this.getTooltip());
        newAction.setVisibleWhen(this.getVisibleWhen());
        newAction.setCategory(this.getCategory());
        newAction.setIndex(this.getIndex());
        newAction.setImmediate(this.isImmediate());
        newAction.setUpdate(this.isUpdate());
        newAction.setRole(this.getRole());
        newAction.setDomain(this.getDomain());
        newAction.setShowCaption(this.isShowCaption());
        newAction.setParent(this.getParent());
        newAction.getProperties().putAll(this.getProperties());
        newAction.getParams().putAll(this.getParams());
        return newAction;
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.getProperties());
        map.put("name", this.getName());
        map.put("caption", this.getCaption());
        map.put("icon", this.getIcon());
        map.put("mnemonic", Character.valueOf(this.getMnemonic()));
        map.put("permission", this.getPermission());
        map.put("tooltip", this.getTooltip());
        map.put("visibleWhen", this.getVisibleWhen());
        map.put("category", this.getCategory());
        map.put("index", this.getIndex());
        map.put("immediate", this.isImmediate());
        map.put("update", this.isUpdate());
        map.put("role", this.getRole());
        map.put("domain", this.getDomain());
        map.put("showCaption", this.isShowCaption());
        map.put("parent", this.getParent());
        return map;
    }

    public static interface ActionDelegator {
        public Object execute(Action var1);
    }
}

