/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.io.IOStream;
import com.rameses.util.Base64Cipher;
import com.rameses.util.Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class SharedPreferences {
    private static final ConfImpl defaultConf = new ConfImpl("default-conf-impl");

    public static Conf getDefault() {
        return defaultConf;
    }

    private static class ConfImpl
    extends Conf {
        private String prefname;

        ConfImpl(String prefname) {
            this.prefname = prefname;
        }

        @Override
        public String getName() {
            return this.prefname;
        }
    }

    public static class Editor {
        private Conf conf;
        private Map setprops;
        private Map delprops;

        Editor(Conf conf) {
            this.conf = conf;
            this.setprops = new HashMap();
            this.delprops = new HashMap();
        }

        public Editor put(String key, Object value) {
            if (key != null) {
                if (value == null) {
                    this.delprops.put(key, null);
                } else {
                    this.setprops.put(key, value);
                }
            }
            return this;
        }

        public Editor remove(String key) {
            if (key != null) {
                this.delprops.put(key, null);
            }
            return this;
        }

        public void save() {
            this.conf.update(this.setprops, this.delprops);
            this.setprops.clear();
            this.delprops.clear();
        }
    }

    public static abstract class Conf {
        private Properties props = new Properties();
        private boolean has_loaded = false;

        public abstract String getName();

        synchronized void load() {
            if (!this.has_loaded) {
                this.props.clear();
                this.props = this.read();
            }
            this.has_loaded = true;
        }

        File getFile() {
            String sharedkey = SharedPreferences.class.getName() + "#" + this.getName();
            String enckey = "prefs" + Encoder.MD5.encode(sharedkey);
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File basedir = new File(tmpdir, "rameses/preferences");
            if (!basedir.exists()) {
                basedir.mkdirs();
            }
            return new File(basedir, enckey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Properties read() {
            Properties properties;
            Properties newprops = new Properties();
            FileInputStream fis = null;
            try {
                byte[] bytes = IOStream.toByteArray(this.getFile());
                String encstr = new String(bytes, "UTF-8");
                Object obj = new Base64Cipher().decode(encstr);
                if (obj instanceof Map) {
                    newprops.putAll((Map<?, ?>)((Map)obj));
                }
                properties = newprops;
            }
            catch (Throwable t) {
                try {
                    Properties properties2 = newprops;
                    return properties2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                fis.close();
                return properties;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return properties;
        }

        void update(Map setprops, Map delprops) {
            Properties oldprops = this.read();
            oldprops.putAll((Map<?, ?>)setprops);
            Iterator itr = delprops.keySet().iterator();
            while (itr.hasNext()) {
                oldprops.remove(itr.next());
            }
            if (this.write(oldprops)) {
                this.props.clear();
                this.props = oldprops;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean write(Object obj) {
            String encstr = new Base64Cipher().encode(obj);
            boolean success = true;
            OutputStreamWriter writer = null;
            try {
                writer = new FileWriter(this.getFile());
                writer.write(encstr);
                writer.flush();
            }
            catch (Throwable t) {
                success = false;
            }
            finally {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
            return success;
        }

        public Editor getEditor() {
            return new Editor(this);
        }

        public Object get(String name) {
            this.load();
            return this.props.get(name);
        }

        public String getString(String name) {
            Object value = this.get(name);
            return value == null ? null : value.toString();
        }

        public Number getNumber(String name) {
            Object value = this.get(name);
            if (value instanceof Number) {
                return (Number)value;
            }
            return null;
        }

        public Integer getInteger(String name) {
            Number num = this.getNumber(name);
            if (num == null) {
                return null;
            }
            return new Integer(num.intValue());
        }

        public Boolean getBoolean(String name) {
            Object value = this.get(name);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return null;
        }

        public synchronized void clear() {
            if (this.write(new HashMap())) {
                this.props.clear();
            }
        }
    }
}

