/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ObjectDeserializer {
    private static ObjectDeserializer instance;

    public static ObjectDeserializer getInstance() {
        if (instance == null) {
            instance = new ObjectDeserializer();
        }
        return instance;
    }

    public Object read(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        return this.doRead(new StringReader(text));
    }

    public Object read(Reader reader) {
        return this.doRead(reader);
    }

    private Object doRead(Reader reader) {
        GroovyMapTextParser parser = new GroovyMapTextParser();
        return parser.parse(reader);
    }

    private class EmptyValue {
        private EmptyValue() {
        }
    }

    private class ObjectNode {
        public String currentFldKey;
        private boolean initialized;
        private Object obj;

        ObjectNode() {
        }

        public void addEntry(Object key, Object value) {
            if (!(this.obj instanceof Map)) {
                System.out.println("ObjectNode [ERROR] " + value);
                throw new RuntimeException("Object is not a map.");
            }
            ((Map)this.obj).put(key, value);
        }

        public void addEntry(Object value) {
            if (!(this.obj instanceof List)) {
                System.out.println("ObjectNode [ERROR] " + value);
                throw new RuntimeException("Object is not a list.");
            }
            ((List)this.obj).add(value);
        }

        public Object getObject() {
            return this.obj;
        }

        public void init(Object value) {
            this.obj = value;
            this.initialized = true;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    private class GroovyMapTextParser {
        private GroovyMapTextParser() {
        }

        public Object parse(Reader reader) {
            try {
                StringBuffer buffer = new StringBuffer();
                Stack<ObjectNode> nodes = new Stack<ObjectNode>();
                ObjectNode root = null;
                StreamTokenizer tokenizer = new StreamTokenizer(reader);
                tokenizer.ordinaryChar(46);
                tokenizer.ordinaryChars(48, 57);
                int type = 0;
                while (tokenizer.nextToken() != -1) {
                    type = tokenizer.ttype;
                    if (type == 91) {
                        nodes.push(new ObjectNode());
                        if (root != null) continue;
                        root = (ObjectNode)nodes.peek();
                        continue;
                    }
                    if (type == 58) {
                        if (nodes.isEmpty()) {
                            throw new Exception("character ':' is not expected at line " + tokenizer.lineno() + ".");
                        }
                        ((ObjectNode)nodes.peek()).currentFldKey = buffer.toString();
                        buffer.delete(0, buffer.length());
                        continue;
                    }
                    if (type == 44) {
                        if (nodes.isEmpty()) {
                            throw new Exception("character ',' is not expected at line " + tokenizer.lineno() + ".");
                        }
                        this.processValue((ObjectNode)nodes.peek(), buffer);
                        continue;
                    }
                    if (type == 93) {
                        if (nodes.isEmpty()) {
                            throw new Exception("character ']' is not expected at line " + tokenizer.lineno() + ".");
                        }
                        ObjectNode n = (ObjectNode)nodes.pop();
                        this.processValue(n, buffer);
                        if (nodes.isEmpty()) continue;
                        this.processObjectValue((ObjectNode)nodes.peek(), n.getObject());
                        continue;
                    }
                    if (type == -3) {
                        buffer.append(tokenizer.sval);
                        continue;
                    }
                    if (type == 34 || type == 39) {
                        buffer.append("\"" + tokenizer.sval + "\"");
                        continue;
                    }
                    if (type == -2) {
                        buffer.append(tokenizer.nval);
                        continue;
                    }
                    buffer.append((char)type);
                }
                return root.getObject();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        private void processValue(ObjectNode n, StringBuffer buffer) {
            if (n.currentFldKey != null) {
                if (!n.isInitialized()) {
                    n.init(new LinkedHashMap());
                }
                Object value = this.getValue(buffer.toString());
                Object key = this.correctKey(n.currentFldKey);
                if (!(key instanceof EmptyValue) || !(value instanceof EmptyValue)) {
                    if (value instanceof EmptyValue) {
                        value = null;
                    }
                    if (key instanceof EmptyValue) {
                        key = null;
                    }
                    n.addEntry(key, value);
                }
                n.currentFldKey = null;
            } else {
                Object value;
                if (!n.isInitialized()) {
                    n.init(new ArrayList());
                }
                if (!((value = this.getValue(buffer.toString())) instanceof EmptyValue)) {
                    n.addEntry(value);
                }
            }
            buffer.delete(0, buffer.length());
        }

        private void processObjectValue(ObjectNode n, Object value) {
            if (n.currentFldKey != null) {
                Object key;
                if (!n.isInitialized()) {
                    n.init(new LinkedHashMap());
                }
                if ((key = this.correctKey(n.currentFldKey)) instanceof EmptyValue) {
                    key = null;
                }
                n.addEntry(key, value);
                n.currentFldKey = null;
            } else {
                if (!n.isInitialized()) {
                    n.init(new ArrayList());
                }
                n.addEntry(value);
            }
        }

        private Object correctKey(String text) {
            if (text.startsWith("\"") && text.endsWith("\"")) {
                return text.substring(1, text.length() - 1);
            }
            if (text.trim().length() == 0) {
                return new EmptyValue();
            }
            return text;
        }

        private Object getValue(String text) {
            if (text.startsWith("\"") && text.endsWith("\"")) {
                return text.substring(1, text.length() - 1);
            }
            if (text.matches("-?\\d+")) {
                try {
                    return new Integer(text);
                }
                catch (Exception e) {
                    return new Long(text);
                }
            }
            if (text.matches("-?\\d+\\.\\d+.*") || text.matches("-?\\d+\\.?E.*")) {
                return new BigDecimal(text);
            }
            if (text.matches("true|false")) {
                return new Boolean(text);
            }
            if (text.endsWith(".class")) {
                if ("int".equals(text = text.replaceAll("\\.class$", ""))) {
                    return Integer.TYPE;
                }
                if ("long".equals(text)) {
                    return Long.TYPE;
                }
                if ("short".equals(text)) {
                    return Short.TYPE;
                }
                if ("float".equals(text)) {
                    return Float.TYPE;
                }
                if ("double".equals(text)) {
                    return Double.TYPE;
                }
                if ("boolean".equals(text)) {
                    return Boolean.TYPE;
                }
                try {
                    return this.getClass().getClassLoader().loadClass(text);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if ("null".equals(text)) {
                return null;
            }
            return new EmptyValue();
        }
    }
}

