/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.File;

public final class ContentTypes {
    public static synchronized String get(File file) {
        return new ContentTypes().getFromFile(file);
    }

    public static synchronized String get(String name) {
        return new ContentTypes().getFromString(name);
    }

    private ContentTypes() {
    }

    String getFromFile(File file) {
        return this.getFromString(file.getName());
    }

    String getFromString(String name) {
        int idx = name.lastIndexOf(46);
        String type = name.substring(idx + 1).toLowerCase();
        if (type.matches("pdf|xml|json|zip")) {
            return "application/" + type;
        }
        if (type.matches("rar")) {
            return "application/x-rar-compressed";
        }
        if (type.matches("jpeg|jpg")) {
            return "image/jpeg";
        }
        if (type.matches("png|gif|bmp")) {
            return "image/" + type;
        }
        if (type.matches("csv")) {
            return "text/" + type;
        }
        if (type.matches("txt|conf")) {
            return "text/plain";
        }
        if (type.matches("doc")) {
            return "application/msword";
        }
        if (type.matches("docx")) {
            return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        }
        if (type.matches("xls")) {
            return "application/vnd.ms-excel";
        }
        if (type.matches("xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (type.matches("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (type.matches("pptx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        }
        if (type.matches("mp3")) {
            return "audio/mpeg";
        }
        if (type.matches("mp4")) {
            return "video/mp4";
        }
        return null;
    }
}

