/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class Conf {
    public static final ConfResolver Resolver = new ConfResolver();
    public static final ConfLoader Loader = new ConfLoader();
    private DataProvider provider;

    public Conf() {
    }

    public Conf(DataProvider provider) {
        this.provider = provider;
    }

    public void setDataProvider(DataProvider provider) {
        this.provider = provider;
    }

    public Map load(InputStream inp) {
        return new ConfReader().read(inp);
    }

    private static class ConfReader
    extends Properties {
        private Map conf = new LinkedHashMap();
        private DataProvider provider = new MapDataProvider(this.conf);

        ConfReader() {
        }

        public Map read(InputStream inp) {
            try {
                this.conf.clear();
                super.load(inp);
                return this.conf;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public Object put(Object key, Object value) {
            Object newvalue = new ConfResolver().parse(value, this.provider);
            return this.conf.put(key, newvalue);
        }
    }

    public static class MapDataProvider
    implements DataProvider {
        private Map data;

        public MapDataProvider(Map data) {
            this.data = data;
        }

        @Override
        public Object getValue(String name) {
            return this.data == null ? null : this.data.get(name);
        }
    }

    public static class ConfResolver {
        private DataProvider source;

        public ConfResolver() {
        }

        public ConfResolver(Map source) {
            this.source = new MapDataProvider(source);
        }

        public Object parse(Object value) {
            return this.parse(value, this.source);
        }

        public Object parse(Object value, Map source) {
            return this.parse(value, new MapDataProvider(source));
        }

        public Object parse(Object value, DataProvider source) {
            int idx1;
            int idx0;
            if (value == null) {
                return value;
            }
            int startidx = 0;
            boolean has_expression = false;
            String str = value.toString();
            StringBuilder builder = new StringBuilder();
            while ((idx0 = str.indexOf("${", startidx)) >= 0 && (idx1 = str.indexOf("}", idx0)) >= 0) {
                Object objval;
                has_expression = true;
                String skey = str.substring(idx0 + 2, idx1);
                builder.append(str.substring(startidx, idx0));
                Object object = objval = source == null ? null : source.getValue(skey);
                if (objval == null) {
                    objval = System.getProperty(skey);
                }
                if (objval == null) {
                    builder.append(str.substring(idx0, idx1 + 1));
                } else {
                    builder.append(objval);
                }
                startidx = idx1 + 1;
            }
            if (has_expression) {
                builder.append(str.substring(startidx));
                return builder.toString();
            }
            return value;
        }
    }

    public static class ConfLoader {
        public Map load(InputStream inp) {
            return new Conf().load(inp);
        }
    }

    public static interface DataProvider {
        public Object getValue(String var1);
    }
}

