/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

public final class CipherUtil {
    private static String ENC_MODE = "AES";
    private static CipherUtil instance = new CipherUtil();

    public static Object encode(Serializable obj) throws Exception {
        return CipherUtil.encode(obj, ENC_MODE);
    }

    public static Object encode(Serializable obj, String encmode) throws Exception {
        return instance.encodeObject(obj, encmode);
    }

    public static Object decode(Serializable obj) throws Exception {
        return CipherUtil.decode(obj, ENC_MODE);
    }

    public static Object decode(Serializable obj, String encmode) throws Exception {
        return instance.decodeObject(obj, encmode);
    }

    public Object encodeObject(Serializable obj) {
        return this.encodeObject(obj, ENC_MODE);
    }

    public Object encodeObject(Serializable obj, String encmode) {
        try {
            SecretKey sk = KeyGenerator.getInstance(encmode).generateKey();
            Cipher enc = Cipher.getInstance(encmode);
            enc.init(1, sk);
            SealedObject so = new SealedObject(obj, enc);
            return new Object[]{sk, so};
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Object decodeObject(Serializable obj) {
        return this.decodeObject(obj, ENC_MODE);
    }

    public Object decodeObject(Serializable obj, String encmode) {
        try {
            Object[] o = (Object[])obj;
            if (o.length != 2) {
                throw new Exception("Error secured parameter count");
            }
            SecretKey sk = (SecretKey)o[0];
            SealedObject so = (SealedObject)o[1];
            Cipher dec = Cipher.getInstance(encmode);
            dec.init(2, sk);
            return so.getObject(dec);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

