/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChangeQueue
implements Runnable,
Serializable {
    private LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private AtomicBoolean updating = new AtomicBoolean(false);
    private ExecutorService thread = Executors.newFixedThreadPool(1);
    private Handler handler;

    public ChangeQueue(Handler h) {
        this.handler = h;
    }

    public void push(Object info) {
        this.queue.add(info);
    }

    public void applyChanges() {
        if (this.updating.compareAndSet(false, true)) {
            this.thread.submit(this);
        }
    }

    public boolean isUpdating() {
        return this.updating.get();
    }

    @Override
    public void run() {
        Object v = null;
        try {
            while (true) {
                Object e = this.queue.poll(1L, TimeUnit.SECONDS);
                v = e;
                if (e != null) {
                    this.handler.update(v);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.handler.onAfterUpdate();
        this.updating.set(false);
    }

    public static interface Handler {
        public void update(Object var1);

        public void onAfterUpdate();
    }
}

