/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.net.util.Base64;

public final class Base64Cipher {
    private static final String REG_EXP = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    private static final String systemLineSeparator;
    private static final char[] map1;
    private static final byte[] map2;

    public boolean isEncoded(char[] value) {
        return this.isEncoded(new String(value));
    }

    public boolean isEncoded(String value) {
        return value.matches(REG_EXP);
    }

    public String encode(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return this.encode((byte[])value);
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            byte[] bytes = baos.toByteArray();
            String string = this.encode(bytes);
            return string;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
            try {
                oos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String encode(String value) {
        return this.encodeString(value);
    }

    public String encodeString(String value) {
        if (value == null) {
            return null;
        }
        if (this.isEncoded(value)) {
            return value;
        }
        try {
            return new Base64().encodeToString(value.getBytes());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String encode(byte[] bytes) {
        char[] chars = this.encode(bytes, 0, bytes.length);
        return new String(chars);
    }

    public String encodeLines(byte[] in) {
        return this.encodeLines(in, 0, in.length, 76, systemLineSeparator);
    }

    public String encodeLines(byte[] in, int iOff, int iLen, int lineLen, String lineSeparator) {
        int l;
        int blockLen = lineLen * 3 / 4;
        if (blockLen <= 0) {
            throw new IllegalArgumentException();
        }
        int lines = (iLen + blockLen - 1) / blockLen;
        int bufLen = (iLen + 2) / 3 * 4 + lines * lineSeparator.length();
        StringBuilder buf = new StringBuilder(bufLen);
        for (int ip = 0; ip < iLen; ip += l) {
            l = Math.min(iLen - ip, blockLen);
            buf.append(this.encode(in, iOff + ip, l));
            buf.append(lineSeparator);
        }
        return buf.toString();
    }

    public Object decode(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            return this.decode(value.toString());
        }
        if (value instanceof byte[]) {
            return this.decode((byte[])value);
        }
        if (value instanceof char[]) {
            return this.decode((char[])value);
        }
        return value;
    }

    public Object decode(String value) {
        return this.decode(value, true);
    }

    public Object decode(String value, boolean readObject) {
        if (value == null) {
            return null;
        }
        if (this.isEncoded(value)) {
            try {
                char[] chars = value.toCharArray();
                if (readObject) {
                    return this.decode(chars);
                }
                return this.decode(chars, 0, chars.length);
            }
            catch (Throwable chars) {
                // empty catch block
            }
        }
        byte[] bytes = new Base64().decode(value);
        return new String(bytes);
    }

    public Object decode(char[] chars) {
        if (!this.isEncoded(chars)) {
            return chars;
        }
        byte[] bytes = this.decode(chars, 0, chars.length);
        return this.decode(bytes);
    }

    public Object decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Throwable throwable) {}
            try {
                bais.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public byte[] decodeLines(String s) {
        char[] buf = new char[s.length()];
        int p = 0;
        for (int ip = 0; ip < s.length(); ++ip) {
            char c = s.charAt(ip);
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t') continue;
            buf[p++] = c;
        }
        return this.decode(buf, 0, p);
    }

    public char[] encode(byte[] in, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public byte[] decode(char[] in, int iOff, int iLen) {
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iOff + iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iEnd ? in[ip++] : 65;
            int n = i3 = ip < iEnd ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = map2[i0];
            byte b1 = map2[i1];
            byte b2 = map2[i2];
            byte b3 = map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    static {
        int c;
        systemLineSeparator = System.getProperty("line.separator");
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Cipher.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Cipher.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Cipher.map1[i++] = c;
        }
        Base64Cipher.map1[i++] = 43;
        Base64Cipher.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            Base64Cipher.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64Cipher.map2[Base64Cipher.map1[i]] = (byte)i;
        }
    }
}

