/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service;

import com.rameses.service.DefaultScriptServiceProxy;
import com.rameses.service.ScriptServiceProxyProvider;
import com.rameses.service.ServiceContext;
import com.rameses.service.ServiceProxy;
import com.rameses.service.ServiceProxyInvocationHandler;
import com.rameses.util.Service;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ScriptServiceContext
extends ServiceContext {
    public ScriptServiceContext(Map map) {
        super(map);
    }

    private ServiceProxy findScriptProxy(String serviceName, Map env) {
        if (this.getMap().containsKey(ServiceContext.USE_DEFAULT)) {
            return new DefaultScriptServiceProxy(serviceName, this.getMap(), env);
        }
        Iterator iter = Service.providers(ScriptServiceProxyProvider.class, ServiceContext.class.getClassLoader());
        while (iter.hasNext()) {
            ScriptServiceProxyProvider p = (ScriptServiceProxyProvider)iter.next();
            if (!p.accept(this.getMap())) continue;
            return p.create(serviceName, env, this.getMap());
        }
        return new DefaultScriptServiceProxy(serviceName, this.getMap(), env);
    }

    public <T> T create(String serviceName) {
        return (T)this.create(serviceName, new HashMap(), ServiceProxy.class);
    }

    public <T> T create(String serviceName, Map env) {
        return (T)this.create(serviceName, env, ServiceProxy.class);
    }

    public <T> T create(String serviceName, Class<T> clz) {
        return this.create(serviceName, new HashMap(), clz);
    }

    public <T> T create(String serviceName, Map env, Class<T> clz) {
        return this.create(serviceName, env, clz, ServiceProxy.class.getClassLoader());
    }

    public <T> T create(String serviceName, Map env, Class<T> clz, ClassLoader loader) {
        ServiceProxy proxy = this.findScriptProxy(serviceName, env);
        if (clz.equals(ServiceProxy.class)) {
            return (T)proxy;
        }
        ServiceProxyInvocationHandler handler = new ServiceProxyInvocationHandler(proxy);
        return (T)Proxy.newProxyInstance(loader, new Class[]{clz}, (InvocationHandler)handler);
    }
}

