/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.service;

import com.rameses.common.AsyncToken;
import com.rameses.http.HttpClient;
import java.util.HashMap;
import java.util.Map;

public class AsyncPoller {
    private AsyncToken token;
    private HttpClient client;
    private Map conf;

    public AsyncPoller(Map conf, AsyncToken token) {
        this.conf = conf;
        this.token = token;
        String host = (String)conf.get("app.host");
        this.client = new HttpClient(host, true);
    }

    public Object poll() throws Exception {
        String path = "async/poll";
        String appcontext = (String)this.conf.get("app.context");
        String cluster = (String)this.conf.get("app.cluster");
        if (cluster != null) {
            path = cluster + "/" + path;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", this.token.getId());
        params.put("connection", this.token.getConnection());
        params.put("context", appcontext);
        return this.client.post(path, new Object[]{params});
    }

    public void close() {
        new Thread(new CloseSessionProcess()).start();
    }

    private class CloseSessionProcess
    implements Runnable {
        private CloseSessionProcess() {
        }

        @Override
        public void run() {
            try {
                String path = "async/unregister";
                String appcontext = (String)AsyncPoller.this.conf.get("app.context");
                String cluster = (String)AsyncPoller.this.conf.get("app.cluster");
                if (cluster != null) {
                    path = cluster + "/" + path;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", AsyncPoller.this.token.getId());
                params.put("connection", AsyncPoller.this.token.getConnection());
                params.put("context", appcontext);
                AsyncPoller.this.client.post(path, new Object[]{params});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

