/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.server;

import com.rameses.server.ServerConf;
import com.rameses.server.ServerLoader;
import com.rameses.server.ServerLoaderProvider;
import com.rameses.server.ServerPID;
import com.rameses.server.Shutdown;
import com.rameses.util.Service;
import com.rameses.util.URLStreamHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class BootLoader {
    public static final String KEY_USER_DIR = "user.dir";
    public static final String KEY_REPO_DIR = "osiris.repo.dir";
    public static final String KEY_BASE_DIR = "osiris.base.dir";
    public static final String KEY_RUN_DIR = "osiris.run.dir";
    public static final String KEY_OUTPUT_DIR = "osiris.output.dir";
    public static final String KEY_TEMPLATES_DIR = "osiris.templates.dir";
    public static final String KEY_FILE_STORAGE_DIR = "osiris.fileserver.dir";
    public static final String KEY_REPORT_FILES_DIR = "osiris.reportfiles.dir";
    public static final String KEY_OUTPUT_DIR_NAME = "output";
    public static final String KEY_TEMPLATES_DIR_NAME = "templates";
    public static final String KEY_FILE_STORAGE_DIR_NAME = "fileserver";
    public static final String KEY_REPORT_FILES_DIR_NAME = "report-files";
    private ExecutorService thread;
    private Map<String, ServerLoaderProvider> providers = new Hashtable<String, ServerLoaderProvider>();
    private Map<String, ServerLoader> servers = new Hashtable<String, ServerLoader>();

    private void initProviders() {
        this.providers.clear();
        Iterator iter = Service.providers(ServerLoaderProvider.class, BootLoader.class.getClassLoader());
        while (iter.hasNext()) {
            ServerLoaderProvider p = (ServerLoaderProvider)iter.next();
            this.providers.put(p.getName(), p);
        }
    }

    public static void main(String[] args) throws Throwable {
        BootLoader main = new BootLoader();
        main.start();
    }

    public static final synchronized File getRepoDir() {
        return new File(System.getProperty(KEY_REPO_DIR));
    }

    public static final synchronized File getBaseDir() {
        return new File(System.getProperty(KEY_BASE_DIR));
    }

    public static final synchronized File getRunDir() {
        return new File(System.getProperty(KEY_RUN_DIR));
    }

    public static final synchronized File getOutputDir() {
        return new File(System.getProperty(KEY_OUTPUT_DIR));
    }

    public static final synchronized File getTemplatesDir() {
        return new File(System.getProperty(KEY_TEMPLATES_DIR));
    }

    public static final synchronized File getReportFilesDir() {
        return new File(System.getProperty(KEY_REPORT_FILES_DIR));
    }

    public static final synchronized File getStorageDir() {
        return new File(System.getProperty(KEY_FILE_STORAGE_DIR));
    }

    public static final synchronized File getStorageDownloadDir() {
        return new File(System.getProperty(KEY_FILE_STORAGE_DIR), "downloads");
    }

    public static final synchronized File getStorageUploadDir() {
        return new File(System.getProperty(KEY_FILE_STORAGE_DIR), "uploads");
    }

    public static final synchronized String getBaseDirPath() {
        return System.getProperty(KEY_BASE_DIR);
    }

    public static final synchronized String getRunDirPath() {
        return System.getProperty(KEY_RUN_DIR);
    }

    public static final synchronized String getOutputDirPath() {
        return System.getProperty(KEY_OUTPUT_DIR);
    }

    public static final synchronized String getTemplatesDirPath() {
        return System.getProperty(KEY_TEMPLATES_DIR);
    }

    public static final synchronized String getReportFilesDirPath() {
        return System.getProperty(KEY_REPORT_FILES_DIR);
    }

    public static final synchronized String getStorageDirPath() {
        return System.getProperty(KEY_FILE_STORAGE_DIR);
    }

    public static final synchronized String getStorageDownloadDirPath() {
        return System.getProperty(KEY_FILE_STORAGE_DIR) + "/downloads";
    }

    public static final synchronized String getStorageUploadDirPath() {
        return System.getProperty(KEY_FILE_STORAGE_DIR) + "/uploads";
    }

    public void start() throws Exception {
        System.out.println("[BootLoader] starting...");
        String userdir = System.getProperty(KEY_USER_DIR);
        String basedir = System.getProperty(KEY_BASE_DIR, userdir);
        String repodir = System.getProperty(KEY_REPO_DIR, basedir);
        String rundir = System.getProperty(KEY_RUN_DIR, userdir);
        System.getProperties().put(KEY_REPO_DIR, repodir);
        System.getProperties().put(KEY_BASE_DIR, basedir);
        System.getProperties().put(KEY_RUN_DIR, rundir);
        System.out.println("[BootLoader] building system file properties...");
        this.buildSysFileProperty(basedir, KEY_OUTPUT_DIR, KEY_OUTPUT_DIR_NAME);
        this.buildSysFileProperty(basedir, KEY_TEMPLATES_DIR, KEY_TEMPLATES_DIR_NAME);
        this.buildSysFileProperty(basedir, KEY_REPORT_FILES_DIR, KEY_REPORT_FILES_DIR_NAME);
        this.buildSysFileProperty(basedir, KEY_FILE_STORAGE_DIR, KEY_FILE_STORAGE_DIR_NAME);
        System.out.println("[BootLoader] resolving directories...");
        File file_repodir = BootLoader.getRepoDir();
        File file_basedir = BootLoader.getBaseDir();
        File file_rundir = BootLoader.getRunDir();
        File file_outputdir = BootLoader.getOutputDir();
        File file_templatedir = BootLoader.getTemplatesDir();
        File file_reportdir = BootLoader.getReportFilesDir();
        File file_storage_downdir = BootLoader.getStorageDownloadDir();
        File file_storage_updir = BootLoader.getStorageUploadDir();
        this.resolveDirectory(file_outputdir);
        this.resolveDirectory(file_templatedir);
        this.resolveDirectory(file_reportdir);
        this.resolveDirectory(file_storage_downdir);
        this.resolveDirectory(file_storage_updir);
        System.out.println("[BootLoader]   repo-dir   : " + this.getCanonicalPath(file_repodir));
        System.out.println("[BootLoader]   base-dir   : " + this.getCanonicalPath(file_basedir));
        System.out.println("[BootLoader]   bin-dir    : " + this.getCanonicalPath(file_rundir));
        System.out.println("[BootLoader]   output-dir : " + this.getCanonicalPath(file_outputdir));
        System.out.println("[BootLoader]   templates-dir : " + this.getCanonicalPath(file_templatedir));
        System.out.println("[BootLoader]   report-dir    : " + this.getCanonicalPath(file_reportdir));
        System.out.println("[BootLoader]   storage-download-dir : " + this.getCanonicalPath(file_storage_downdir));
        System.out.println("[BootLoader]   storage-upload-dir   : " + this.getCanonicalPath(file_storage_updir));
        System.out.println("");
        Shutdown.removePID();
        this.createInstancePID();
        this.initProviders();
        ServerConf.load(new File(file_rundir, "server.conf"));
        String baseURL = file_basedir.toURI().toURL().toString();
        for (Map.Entry<String, Map> entry : ServerConf.getGroups().entrySet()) {
            String groupName = entry.getKey().toString();
            Map groupConf = this.resolveConf(entry.getValue());
            String providerName = (String)groupConf.get("provider");
            if (providerName == null) continue;
            ServerLoaderProvider sp = this.providers.get(providerName);
            if (sp == null) {
                System.out.println("[WARN] '" + providerName + "' provider name not found");
                continue;
            }
            ServerLoader loader = sp.createServer(groupName);
            System.out.println("[BootLoader] initializing " + groupName + "... (" + loader.getClass().getName() + ")");
            loader.init(baseURL, groupConf);
            this.servers.put(groupName, loader);
            ServerPID.add(groupName);
        }
        System.getProperties().put(URLStreamHandler.class.getName(), new URLStreamHandlerImpl());
        this.thread = Executors.newFixedThreadPool(this.servers.size());
        System.out.println("");
        System.out.println("[BootLoader] starting server loaders...");
        for (final String key : this.servers.keySet()) {
            final ServerLoader loader = this.servers.get(key);
            Runnable proc = new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println("[BootLoader] starting " + key + "... (" + loader.getClass().getName() + ")");
                        loader.start();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable t) {
                        System.out.println("[BootLoader-" + key + "] failed to start caused by " + t.getMessage());
                        t.printStackTrace();
                    }
                    finally {
                        try {
                            loader.stop();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            this.thread.submit(proc);
        }
        System.out.println("");
        System.out.println("[BootLoader] creating shutdown hook");
        final ShutdownAgent shutdownAgent = new ShutdownAgent();
        Runnable shutdownHook = new Runnable(){

            @Override
            public void run() {
                shutdownAgent.cancel();
                BootLoader.this.onshutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownHook));
        new Thread(shutdownAgent).start();
        System.out.println("[BootLoader] started shutdown agent");
        System.out.println("");
    }

    private void onshutdown() {
        System.out.println("");
        System.out.println("[BootLoader] shutdown server loaders...");
        for (String key : this.servers.keySet()) {
            ServerLoader loader = this.servers.get(key);
            try {
                System.out.println("[BootLoader] stopping " + key + " (" + loader.getClass().getName() + ")...");
                loader.stop();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("[BootLoader] removing process IDs...");
        this.removeInstancePID();
        Shutdown.removePID();
    }

    private File getPID() {
        File rundir = BootLoader.getRunDir();
        return new File(rundir, ".osiris_pid");
    }

    private void createInstancePID() {
        File file = this.getPID();
        if (file.exists()) {
            throw new RuntimeException("Cannot start the server because there is already a process-ID instance.");
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void removeInstancePID() {
        File file = this.getPID();
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Map resolveConf(Map conf) {
        LinkedHashMap newconf = new LinkedHashMap();
        if (conf == null) {
            return newconf;
        }
        for (Object key : conf.keySet()) {
            Object val = this.resolveValue(conf.get(key), newconf);
            newconf.put(key, val);
        }
        return newconf;
    }

    private Object resolveValue(Object value, Map conf) {
        int idx1;
        int idx0;
        if (value == null) {
            return null;
        }
        int startidx = 0;
        boolean has_expression = false;
        String str = value.toString();
        StringBuilder builder = new StringBuilder();
        while ((idx0 = str.indexOf("${", startidx)) >= 0 && (idx1 = str.indexOf("}", idx0)) >= 0) {
            has_expression = true;
            String skey = str.substring(idx0 + 2, idx1);
            builder.append(str.substring(startidx, idx0));
            Object objval = null;
            if (skey.startsWith("@@")) {
                String[] arr = skey.split(":");
                String sname = arr.length == 2 ? arr[1] : "";
                Map<String, Map> group = ServerConf.getGroup(skey);
                objval = group.get(sname);
            } else {
                objval = conf.get(skey);
            }
            if (objval == null) {
                objval = System.getProperty(skey);
            }
            if (objval == null) {
                builder.append(str.substring(idx0, idx1 + 1));
            } else {
                builder.append(objval);
            }
            startidx = idx1 + 1;
        }
        if (has_expression) {
            builder.append(str.substring(startidx));
            return builder.toString();
        }
        return value;
    }

    private void buildSysFileProperty(String basedir, String key, String alias) {
        File file = null;
        String pathdir = System.getProperty(key, "");
        if (pathdir == null || pathdir.trim().length() == 0) {
            file = new File(basedir);
            if (alias != null && alias.trim().length() > 0) {
                file = new File(basedir, alias);
            }
        } else {
            file = new File(pathdir);
        }
        try {
            System.getProperties().put(key, file.getCanonicalPath());
        }
        catch (IOException ex) {
            System.out.println("[Warn] failed to get the canonical path for '" + file.getAbsolutePath() + "'");
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private void resolveDirectory(File dir) {
        try {
            if (dir != null) {
                dir.mkdirs();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getCanonicalPath(File file) {
        try {
            if (file == null) {
                return null;
            }
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            System.out.println("[Warn] failed to get the canonical path for '" + file.getAbsolutePath() + "'");
            return file.getAbsolutePath();
        }
    }

    private class URLStreamHandlerImpl
    extends URLStreamHandler {
        private URLStreamHandlerImpl() {
        }

        @Override
        public String getProtocol() {
            return "classpath";
        }

        @Override
        public URL getResource(String spath) {
            URL url = this.getResourceImpl(spath);
            return url;
        }

        URL getResourceImpl(String spath) {
            File dir = BootLoader.getReportFilesDir();
            File file = new File(dir, spath);
            if (file.exists()) {
                return this.toURL(file);
            }
            File tmplDir = BootLoader.getTemplatesDir();
            ArrayList<URL> list = new ArrayList<URL>();
            this.scan(list, new File(tmplDir, "custom"));
            this.scan(list, tmplDir);
            URL[] urls = list.toArray(new URL[0]);
            URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
            return loader.getResource(spath);
        }

        URL toURL(File file) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        void scan(ArrayList<URL> urls, File dir) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".jar");
                }
            };
            File[] files = dir.listFiles(filter);
            Comparator sorter = new Comparator(){

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            };
            Arrays.sort(files, sorter);
            for (File file : files) {
                urls.add(this.toURL(file));
            }
        }
    }

    private class ShutdownAgent
    implements Runnable {
        BootLoader root;
        private boolean cancelled;

        private ShutdownAgent() {
            this.root = BootLoader.this;
        }

        void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            while (!this.cancelled) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.cancelled) break;
                if (Shutdown.hasPID()) {
                    this.processShutdown();
                    break;
                }
                File file = this.root.getPID();
                if (file.exists()) continue;
                this.processShutdown();
                break;
            }
        }

        void processShutdown() {
            this.cancelled = true;
            try {
                this.root.onshutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                System.out.println("Stopping JVM...");
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

