/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import com.rameses.io.IOStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class StreamUtil {
    private static IOStream io = new IOStream();

    public static String toString(String filePath) {
        ClassLoader loader = StreamUtil.class.getClassLoader();
        return StreamUtil.toString(loader.getResourceAsStream(filePath));
    }

    public static String toString(InputStream is) {
        try {
            byte[] bytes = IOStream.toByteArray(is);
            String string = new String(bytes, "utf8");
            return string;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void write(InputStream is, StringBuilder out) {
        try {
            int i = -1;
            while ((i = is.read()) != -1) {
                out.append((char)i);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void write(byte[] bytes, OutputStream output) {
        StreamUtil.write(bytes, output, 1024);
    }

    public static void write(byte[] bytes, OutputStream output, int bufferSize) {
        StreamUtil.write(new ByteArrayInputStream(bytes), output, bufferSize);
    }

    public static void write(InputStream input, OutputStream output) {
        StreamUtil.write(input, output, 1024);
    }

    public static void write(InputStream input, OutputStream output, int bufferSize) {
        IOStream.write(input, output, bufferSize);
    }

    public static byte[] toByteArray(InputStream input) {
        return StreamUtil.toByteArray(input, 4096);
    }

    public static byte[] toByteArray(InputStream input, int bufferSize) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtil.write(input, (OutputStream)output, bufferSize);
        return output.toByteArray();
    }

    public static void readURLStream(String urlPath, InputStreamHandler handler) {
        StreamUtil.readURLStream(urlPath, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readURLStream(String urlPath, InputStreamHandler handler, boolean ignoreFileNotFound) {
        block12: {
            InputStream is = null;
            try {
                URL u = new URL(urlPath);
                is = u.openStream();
                handler.handle(is);
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException && ignoreFileNotFound) {
                    break block12;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static interface InputStreamHandler {
        public void handle(InputStream var1) throws Exception;
    }
}

