/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import com.rameses.io.FileTransferException;
import com.rameses.io.FileTransferInfo;
import com.rameses.io.TargetFileExistsException;
import com.rameses.io.TransferFileModifiedException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileTransferOutputStream
extends OutputStream {
    private FileTransferInfo fileTransferInfo;
    private FileOutputStream out;
    private String filename;
    private String suffix = ".dwd2";
    private File tempFile;
    private boolean bytesVerified;

    public FileTransferOutputStream(FileTransferInfo fileInfo, String outputFileName) throws Exception {
        this.filename = outputFileName;
        this.bytesVerified = false;
        this.fileTransferInfo = fileInfo;
        this.prepareTarget(outputFileName);
    }

    public void setSuffix(String s) {
        this.suffix = s;
    }

    protected long getCurrentPos() throws IOException {
        return this.out.getChannel().size();
    }

    private void prepareTarget(String fileName) throws Exception {
        if (fileName == null) {
            throw new NullPointerException("Please indicate an output filename ");
        }
        File test = new File(fileName);
        if (test.exists()) {
            boolean exact = test.lastModified() == this.fileTransferInfo.getLastModified();
            throw new TargetFileExistsException(exact);
        }
        this.tempFile = new File(fileName + this.suffix);
        if (!this.tempFile.exists()) {
            this.tempFile.createNewFile();
            this.tempFile.setLastModified(this.fileTransferInfo.getLastModified());
            this.out = new FileOutputStream(this.tempFile, true);
        } else {
            this.out = new FileOutputStream(this.tempFile, true);
            if (this.fileTransferInfo.getLastModified() != this.tempFile.lastModified()) {
                throw new TransferFileModifiedException("Last modified of source file does not match");
            }
        }
    }

    public void verifyBytes(byte[] bytesToTransfer) throws IOException {
        long currentPos = this.getCurrentPos();
        if (this.fileTransferInfo.getBytesRead() != currentPos + (long)bytesToTransfer.length) {
            throw new FileTransferException(currentPos);
        }
        this.bytesVerified = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.bytesVerified) {
            throw new IOException("Please run bytes verify method first and verify bytes to copy");
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (!this.bytesVerified) {
            this.verifyBytes(bytes);
        }
        this.out.write(bytes);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.fileTransferInfo.isEof()) {
            File newFile = new File(this.filename);
            boolean t = this.tempFile.renameTo(newFile);
            newFile.setLastModified(this.fileTransferInfo.getLastModified());
        } else {
            this.tempFile.setLastModified(this.fileTransferInfo.getLastModified());
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

