/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import com.rameses.io.FileTransferInfo;
import com.rameses.io.TransferFileModifiedException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class FileTransferInputStream
extends InputStream {
    private long restorePoint = 0L;
    private int byteSize = 8192;
    private InputStream inputStream;
    private FileTransferInfo fileTransferInfo;
    private String suffix = ".dwd";

    public FileTransferInputStream(File f) throws Exception {
        this.inputStream = new FileInputStream(f);
        boolean exists = this.retrieveInfo(f);
        if (exists) {
            this.verify(f);
            this.restore();
        }
    }

    public FileTransferInputStream(File f, FileTransferInfo fileInfo) throws Exception {
        this.inputStream = new FileInputStream(f);
        boolean exists = this.retrieveInfo(f, fileInfo);
        if (exists) {
            this.verify(f);
            this.restore();
        }
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    private boolean retrieveInfo(File sourceFile) throws Exception {
        return this.retrieveInfo(sourceFile, null);
    }

    private boolean retrieveInfo(File sourceFile, FileTransferInfo fileInfo) throws Exception {
        String tmpFileName = null;
        tmpFileName = fileInfo == null ? sourceFile.getPath() + this.suffix : fileInfo.getTempFileName();
        File tmpFile = new File(tmpFileName);
        if (!tmpFile.exists()) {
            this.fileTransferInfo = new FileTransferInfo(sourceFile);
            this.fileTransferInfo.setTempFileName(tmpFileName);
            return false;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(tmpFile);
            ois = new ObjectInputStream(fis);
            this.fileTransferInfo = (FileTransferInfo)ois.readObject();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (this.fileTransferInfo.isEof()) {
            this.fileTransferInfo.delete();
            throw new EOFException("File Transfer Info is currently at EOF position. Existing file is removed");
        }
        return true;
    }

    private void verify(File f) throws Exception {
        if (f.length() != this.fileTransferInfo.getSize() || f.lastModified() != this.fileTransferInfo.getLastModified()) {
            this.fileTransferInfo.delete();
            throw new TransferFileModifiedException();
        }
    }

    private void restore() throws Exception {
        if (this.fileTransferInfo != null) {
            this.restorePoint = this.fileTransferInfo.getBytesRead();
            int _loops = new Integer(Long.toString(this.restorePoint / (long)this.byteSize));
            int _remainder = new Integer(Long.toString(this.restorePoint % (long)this.byteSize));
            byte[] b = new byte[this.byteSize];
            for (int i = 0; i < _loops; ++i) {
                this.inputStream.read(b, 0, this.byteSize);
            }
            if (_remainder > 0) {
                b = new byte[_remainder];
                this.inputStream.read(b, 0, _remainder);
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    public byte[] readNext() throws Exception {
        byte[] readByte = new byte[this.byteSize];
        int fetchCount = this.inputStream.read(readByte, 0, this.byteSize);
        if (fetchCount < 0) {
            return null;
        }
        if (fetchCount < this.byteSize) {
            byte[] fixedBytes = new byte[fetchCount];
            for (int i = 0; i < fetchCount; ++i) {
                fixedBytes[i] = readByte[i];
            }
            this.restorePoint += (long)fixedBytes.length;
            this.fileTransferInfo.setEof(true);
            return fixedBytes;
        }
        this.restorePoint += (long)this.byteSize;
        return readByte;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(int size) {
        this.byteSize = size;
    }

    public long getRestorePoint() {
        return this.restorePoint;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public FileTransferInfo getFileTransferInfo() {
        this.fileTransferInfo.setBytesRead(this.restorePoint);
        return this.fileTransferInfo;
    }

    public void saveRestorePoint() throws Exception {
        this.fileTransferInfo.setBytesRead(this.restorePoint);
        this.fileTransferInfo.save();
    }
}

