/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class FileTransfer {
    public final void transfer(InputSource in, OutputHandler out) throws Exception {
        this.transfer(in, out, null);
    }

    public final void transfer(InputSource in, OutputHandler out, TransferListener listener) throws Exception {
        try {
            byte[] b = null;
            if (listener != null) {
                listener.start(in.getPosition());
            }
            while ((b = in.read()) != null) {
                if (b.length == 0) {
                    break;
                }
                out.write(b);
                if (listener == null) continue;
                listener.process(in.getPosition());
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            in.close();
            out.close();
            if (listener != null) {
                listener.end(in.getPosition());
            }
        }
    }

    public static class FileOutputHandler
    implements OutputHandler {
        private FileOutputStream fos;

        public FileOutputHandler(File file) throws Exception {
            this(file, true);
        }

        public FileOutputHandler(File file, boolean append) throws Exception {
            this.fos = new FileOutputStream(file, append);
        }

        @Override
        public void write(byte[] bytes) throws Exception {
            this.fos.write(bytes);
        }

        @Override
        public void close() {
            try {
                this.fos.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class FileInputSource
    implements InputSource {
        private InputStream bis;
        int bufferSize = 8192;
        boolean eof = false;
        long position = 0L;

        public FileInputSource(InputStream s) throws Exception {
            this.bis = s;
        }

        public FileInputSource(InputStream s, int bufferSize) throws Exception {
            this.bis = s;
            this.bufferSize = bufferSize;
        }

        public FileInputSource(File f, int bufferSize) throws Exception {
            this(new BufferedInputStream(new FileInputStream(f)), bufferSize);
        }

        public FileInputSource(File f) throws Exception {
            this(new BufferedInputStream(new FileInputStream(f)));
        }

        public void setPosition(long pos) throws Exception {
            int _loops = new Integer(Long.toString(pos / (long)this.bufferSize));
            int _remainder = new Integer(Long.toString(pos % (long)this.bufferSize));
            byte[] b = new byte[this.bufferSize];
            for (int i = 0; i < _loops; ++i) {
                this.bis.read(b, 0, this.bufferSize);
            }
            if (_remainder > 0) {
                b = new byte[_remainder];
                this.bis.read(b, 0, _remainder);
            }
            this.position = _loops * this.bufferSize + _remainder;
        }

        @Override
        public long getPosition() {
            return this.position;
        }

        @Override
        public byte[] read() throws Exception {
            if (this.eof) {
                return null;
            }
            if (this.bis.available() < this.bufferSize) {
                byte[] readBytes = new byte[this.bis.available()];
                this.bis.read(readBytes, 0, this.bis.available());
                System.out.println("last count " + readBytes.length);
                this.position += (long)readBytes.length;
                this.eof = true;
                return readBytes;
            }
            byte[] readBytes = new byte[this.bufferSize];
            this.bis.read(readBytes);
            this.position += (long)readBytes.length;
            return readBytes;
        }

        @Override
        public void close() {
            try {
                this.bis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface TransferListener {
        public void start(long var1);

        public void process(long var1);

        public void end(long var1);
    }

    public static interface OutputHandler {
        public void write(byte[] var1) throws Exception;

        public void close();
    }

    public static interface InputSource {
        public byte[] read() throws Exception;

        public void close();

        public long getPosition();
    }
}

