/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.io;

import com.rameses.io.IOStream;
import com.rameses.service.ScriptServiceContext;
import com.rameses.service.ServiceProxy;
import com.rameses.util.Base64Cipher;
import com.rameses.util.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class FileReader {
    private ScriptServiceContext serviceContext;
    private Map conf;
    private Map env;
    private boolean cache;
    private OutputListener outputListener;

    public FileReader() {
        this(null);
    }

    public FileReader(Map conf) {
        this.conf = conf;
        this.cache = true;
    }

    public void setConf(Map conf) {
        this.conf = conf;
    }

    public void setEnv(Map env) {
        this.env = env == null ? new HashMap() : env;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public OutputListener getOutputListener() {
        return this.outputListener;
    }

    public void setOutputListener(OutputListener outputListener) {
        this.outputListener = outputListener;
    }

    public byte[] read(String id) {
        try {
            ResourceObject res = new ResourceObject(id);
            new CleanupTask(res.getBaseFolder()).start();
            return res.getData();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void remove(String id) {
        try {
            String serviceName = this.getPropertyString("serviceName");
            if (serviceName == null) {
                serviceName = "FileService";
            }
            if (this.env == null) {
                this.env = new HashMap();
            }
            ServiceProxy proxy = (ServiceProxy)this.getServiceContext().create(serviceName, this.env);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("objid", id);
            proxy.invoke("removeFile", new Object[]{params});
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Object getProperty(String name) {
        return this.conf == null ? null : this.conf.get(name);
    }

    private String getPropertyString(String name) {
        Object value = this.getProperty(name);
        return value == null ? null : value.toString();
    }

    private ScriptServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            if (this.conf == null) {
                throw new RuntimeException("Please specify a conf for the service context");
            }
            this.serviceContext = new ScriptServiceContext(this.conf);
        }
        return this.serviceContext;
    }

    private class CleanupTask {
        private File basedir;

        CleanupTask(File dir) {
            this.basedir = dir == null ? null : dir.getParentFile();
        }

        void start() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CleanupTask.this.removeObsoleteFiles();
                }
            }).start();
        }

        void removeObsoleteFiles() {
            File[] files;
            if (this.basedir == null) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            for (File f : files = this.basedir.listFiles()) {
                cal.setTimeInMillis(f.lastModified());
                cal.add(10, 24);
                if (cal.getTimeInMillis() >= System.currentTimeMillis()) continue;
                this.delete(f);
            }
        }

        void delete(File f) {
            if (f.isDirectory()) {
                File[] files;
                for (File o : files = f.listFiles()) {
                    this.delete(o);
                }
            }
            f.delete();
        }
    }

    public static interface OutputListener {
        public void write(byte[] var1);
    }

    private class MapWrapper {
        private Map data;

        MapWrapper(Map data) {
            this.data = data;
        }

        Object get(String name) {
            return this.data == null ? null : this.data.get(name);
        }

        String getString(String name) {
            Object value = this.get(name);
            return value == null ? null : value.toString();
        }

        Integer getInteger(String name) {
            try {
                Object value = this.get(name);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                int num = Integer.parseInt(value.toString());
                return new Integer(num);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private class ResourceObject {
        private String id;
        private String encid;

        ResourceObject(String id) {
            this.id = id;
            this.encid = Encoder.MD5.encode(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] getData() throws Exception {
            Map header;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("objid", this.id);
            File folder = this.getBaseFolder();
            File fhead = new File(folder, "header");
            if (!fhead.exists()) {
                this.downloadData(fhead, "getHeader", params);
            }
            if ((header = (Map)this.read(fhead)) == null) {
                return null;
            }
            MapWrapper map = new MapWrapper(header);
            Integer chunkcount = map.getInteger("chunkcount");
            if (chunkcount == null) {
                return null;
            }
            params.put("context", map.getString("context"));
            OutputListener outputListener = FileReader.this.getOutputListener();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            int count = chunkcount;
            for (int i = 0; i < count; ++i) {
                Object oitem;
                int indexno = i + 1;
                File fitem = new File(folder, "item-" + indexno);
                if (!fitem.exists()) {
                    params.put("indexno", indexno);
                    this.downloadData(fitem, "getDetail", params);
                }
                if ((oitem = this.read(fitem)) instanceof Map) {
                    oitem = ((Map)oitem).get("content");
                }
                if (!(oitem instanceof byte[])) continue;
                byte[] itembytes = (byte[])oitem;
                if (outputListener == null) {
                    baos.write(itembytes);
                    continue;
                }
                outputListener.write(itembytes);
            }
            try {
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            finally {
                try {
                    baos.close();
                }
                catch (Throwable throwable) {}
            }
        }

        Object read(File file) throws Exception {
            byte[] bytes = IOStream.toByteArray(file);
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            return new Base64Cipher().decode(new String(bytes));
        }

        private File getBaseFolder() {
            File maindir;
            File ftempdir;
            File basedir;
            String tempdir = FileReader.this.getPropertyString("tempdir");
            if (tempdir == null || tempdir.length() == 0) {
                tempdir = System.getProperty("java.io.tmpdir");
            }
            if (!(basedir = new File(ftempdir = new File(tempdir), "rameses")).exists()) {
                basedir.mkdir();
            }
            if (!(maindir = new File(basedir, this.encid)).exists()) {
                maindir.mkdir();
            }
            return maindir;
        }

        byte[] downloadData(File file, String action, Map params) throws Exception {
            byte[] data_bytes;
            String serviceName = FileReader.this.getPropertyString("serviceName");
            if (serviceName == null) {
                serviceName = "FileService";
            }
            if (FileReader.this.env == null) {
                FileReader.this.env = new HashMap();
            }
            ServiceProxy proxy = (ServiceProxy)FileReader.this.getServiceContext().create(serviceName, FileReader.this.env);
            HashMap data = (HashMap)proxy.invoke(action, new Object[]{params});
            if (data == null) {
                data = new HashMap();
            }
            if ((data_bytes = IOStream.toByteArray(data)) == null) {
                data_bytes = new byte[]{};
            }
            String encstr = new Base64Cipher().encode(data_bytes);
            if (FileReader.this.isCache()) {
                new IOStream().write(encstr.getBytes(), file);
            }
            return data_bytes;
        }

        Object readObject(byte[] bytes) {
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            try {
                bais = new ByteArrayInputStream(bytes);
                ois = new ObjectInputStream(bais);
                Object object = ois.readObject();
                return object;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    ois.close();
                }
                catch (Throwable throwable) {}
                try {
                    bais.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

