/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DataMap
extends HashMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean editing = false;
    private Stack<Entry> changeLog;
    private Map originalData;
    private UndoListener undoListener;
    private Map data;

    public DataMap(Map d) {
        this.data = d;
        this.edit();
    }

    public Object set(Object key, Object value) {
        return this.data.put(key, value);
    }

    public void edit() {
        this.editing = true;
        this.changeLog = new Stack();
        this.originalData = new HashMap();
    }

    public void unedit() {
        this.undoAll();
    }

    @Override
    public Object put(Object key, Object value) {
        Object prevValue = this.data.get(key);
        if (this.isEqual(prevValue, value)) {
            return value;
        }
        this.data.put(key, value);
        if (!this.editing) {
            return value;
        }
        if (value instanceof Map) {
            return value;
        }
        if (value instanceof List) {
            return value;
        }
        ValueEntry ve = new ValueEntry(key.toString(), prevValue);
        this.changeLog.push(ve);
        if (!this.originalData.containsKey(key)) {
            this.originalData.put(key, prevValue);
        }
        return value;
    }

    public Map data() {
        return this.data;
    }

    public void undoAll() {
        this.changeLog.clear();
        Iterator iterator = this.originalData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry me = e = iterator.next();
            this.data.put(me.getKey(), me.getValue());
        }
    }

    public Object undo() {
        System.out.println("fire undo");
        if (this.changeLog == null || this.changeLog.empty()) {
            return null;
        }
        Entry entry = this.changeLog.pop();
        if (this.undoListener == null) {
            this.undoListener = new UndoListener(){

                @Override
                public void undoValue(ValueEntry ve) {
                }
            };
        }
        System.out.println("entry is " + entry);
        if (entry instanceof ValueEntry) {
            ValueEntry ve = (ValueEntry)entry;
            this.data.put(ve.getKey(), ve.getValue());
            this.undoListener.undoValue(ve);
        }
        System.out.println("change log is ->" + this.changeLog.size());
        return entry;
    }

    private final boolean isEqual(Object oldValue, Object newValue) {
        if (newValue == null && oldValue != null) {
            return false;
        }
        if (newValue != null && oldValue == null) {
            return false;
        }
        return newValue == null || newValue.equals(oldValue);
    }

    @Override
    public Object get(Object key) {
        return this.data.get(key);
    }

    public Map diff() {
        HashMap newMap = new HashMap();
        if (this.originalData != null) {
            Iterator iterator = this.originalData.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry k;
                Map.Entry orig = k = iterator.next();
                Object newVal = this.data.get(orig.getKey());
                if (this.isEqual(orig.getValue(), newVal)) continue;
                newMap.put("_" + orig.getKey(), orig.getValue());
                newMap.put((String)orig.getKey(), newVal);
            }
        }
        return newMap;
    }

    public static interface UndoListener {
        public void undoValue(ValueEntry var1);
    }

    public static class ValueEntry
    implements Entry {
        private String key;
        private Object value;

        public ValueEntry(String k, Object v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static interface Entry {
    }
}

